/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.branding;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.ComboBoxEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.text.DefaultFormatter;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.modules.apisupport.project.spi.BrandingSupport;
import org.openide.util.NbBundle;

class SplashUISupport {
    private SplashUISupport() {
    }

    static Rectangle stringToBounds(String bounds) throws NumberFormatException {
        StringTokenizer st = new StringTokenizer(bounds, " ,");
        int height = 0;
        int width = 0;
        int y = 0;
        int x = 0;
        block6: for (int i = 0; i < 4; ++i) {
            if (!st.hasMoreElements()) {
                throw new NumberFormatException();
            }
            switch (i) {
                case 0: {
                    x = Integer.parseInt(st.nextToken());
                    continue block6;
                }
                case 1: {
                    y = Integer.parseInt(st.nextToken());
                    continue block6;
                }
                case 2: {
                    width = Integer.parseInt(st.nextToken());
                    continue block6;
                }
                case 3: {
                    height = Integer.parseInt(st.nextToken());
                }
            }
        }
        return new Rectangle(x, y, width, height);
    }

    static Rectangle bundleKeyToBounds(@NullAllowed BrandingSupport.BundleKey bk) throws NumberFormatException {
        return bk != null ? SplashUISupport.stringToBounds(bk.getValue()) : new Rectangle();
    }

    static String boundsToString(Rectangle bounds) {
        if (bounds == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        sb.append(String.valueOf(bounds.x)).append(",");
        sb.append(String.valueOf(bounds.y)).append(",");
        sb.append(String.valueOf(bounds.width)).append(",");
        sb.append(String.valueOf(bounds.height));
        return sb.toString();
    }

    static Color stringToColor(String color) throws NumberFormatException {
        return new Color(Integer.decode(color));
    }

    static Color bundleKeyToColor(@NullAllowed BrandingSupport.BundleKey bk) throws NumberFormatException {
        return bk != null ? SplashUISupport.stringToColor(bk.getValue()) : Color.BLACK;
    }

    static String colorToString(Color color) {
        return "0x" + Integer.toString(0xFFFFFF & color.getRGB(), 16).toUpperCase(Locale.ENGLISH);
    }

    static int stringToInteger(String integer) throws NumberFormatException {
        return Integer.decode(integer);
    }

    static int bundleKeyToInteger(@NullAllowed BrandingSupport.BundleKey bk) throws NumberFormatException {
        return bk != null ? SplashUISupport.stringToInteger(bk.getValue()) : 0;
    }

    static String integerToString(int integer) {
        return Integer.toString(integer, 10);
    }

    static String numberToString(@NullAllowed Number n) {
        return n != null ? SplashUISupport.integerToString(n.intValue()) : "";
    }

    static boolean bundleKeyToBoolean(@NullAllowed BrandingSupport.BundleKey bk) {
        return bk != null ? Boolean.parseBoolean(bk.getValue()) : false;
    }

    static void setValue(@NullAllowed BrandingSupport.BundleKey bk, @NonNull String value) {
        if (bk != null) {
            bk.setValue(value);
        }
    }

    static JFormattedTextField getIntegerField() {
        JFormattedTextField retval = new JFormattedTextField(NumberFormat.getIntegerInstance());
        retval = new JFormattedTextField(new FontFormatter(retval.getFormatter()));
        return retval;
    }

    static JFormattedTextField getBoundsField() {
        JFormattedTextField retval = new JFormattedTextField(new BoundsFormatter());
        return retval;
    }

    static ColorComboBox getColorComboBox() {
        ColorComboBox retval = new ColorComboBox();
        return retval;
    }

    private static class BoundsFormatter
    extends DefaultFormatter {
        BoundsFormatter() {
            this.setOverwriteMode(false);
        }

        @Override
        public Object stringToValue(String string) throws ParseException {
            if (string == null) {
                return super.stringToValue(string);
            }
            try {
                return SplashUISupport.stringToBounds(string);
            }
            catch (NumberFormatException ex) {
                throw new ParseException(string, 0);
            }
        }

        @Override
        public String valueToString(Object value) throws ParseException {
            if (value == null) {
                return super.valueToString(value);
            }
            try {
                return SplashUISupport.boundsToString((Rectangle)value);
            }
            catch (NumberFormatException ex) {
                throw new ParseException(value.toString(), 0);
            }
        }
    }

    static class ColorComboBox
    extends JComboBox {
        public static final String PROP_COLOR = "color";
        public static final Value CUSTOM_COLOR = new Value(ColorComboBox.loc("Custom"), null);
        private static Map<Color, String> colorMap = new HashMap<Color, String>();
        private static Object[] content;

        public ColorComboBox() {
            super(content);
            this.setRenderer(new Renderer());
            this.setEditable(true);
            this.setEditor(new Renderer());
            this.setSelectedItem(new Value(null, null));
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    if (ColorComboBox.this.getSelectedItem() == CUSTOM_COLOR) {
                        Color c = JColorChooser.showDialog(SwingUtilities.getAncestorOfClass(Dialog.class, ColorComboBox.this), ColorComboBox.loc("SelectColor"), null);
                        ColorComboBox.this.setColor(c);
                    }
                    ColorComboBox.this.firePropertyChange(ColorComboBox.PROP_COLOR, null, null);
                }
            });
        }

        public void setDefaultColor(Color color) {
            Object[] ncontent = new Object[content.length];
            System.arraycopy(content, 0, ncontent, 0, content.length);
            ncontent[ColorComboBox.content.length - 1] = new Value(NbBundle.getMessage(SplashUISupport.class, (String)"SplashUISupport_color_default"), color);
            this.setModel(new DefaultComboBoxModel<Object>(ncontent));
        }

        public void setColor(Color color) {
            if (color == null) {
                this.setSelectedIndex(content.length - 1);
            } else {
                this.setSelectedItem(new Value(color));
            }
        }

        public Color getColor() {
            if (this.getSelectedIndex() == content.length - 1) {
                return null;
            }
            return ((Value)this.getSelectedItem()).color;
        }

        private static String loc(String key) {
            return NbBundle.getMessage(ColorComboBox.class, (String)key);
        }

        static {
            colorMap.put(Color.BLACK, ColorComboBox.loc("Black"));
            colorMap.put(Color.BLUE, ColorComboBox.loc("Blue"));
            colorMap.put(Color.CYAN, ColorComboBox.loc("Cyan"));
            colorMap.put(Color.DARK_GRAY, ColorComboBox.loc("Dark_Gray"));
            colorMap.put(Color.GRAY, ColorComboBox.loc("Gray"));
            colorMap.put(Color.GREEN, ColorComboBox.loc("Green"));
            colorMap.put(Color.LIGHT_GRAY, ColorComboBox.loc("Light_Gray"));
            colorMap.put(Color.MAGENTA, ColorComboBox.loc("Magenta"));
            colorMap.put(Color.ORANGE, ColorComboBox.loc("Orange"));
            colorMap.put(Color.PINK, ColorComboBox.loc("Pink"));
            colorMap.put(Color.RED, ColorComboBox.loc("Red"));
            colorMap.put(Color.WHITE, ColorComboBox.loc("White"));
            colorMap.put(Color.YELLOW, ColorComboBox.loc("Yellow"));
            content = new Object[]{new Value(Color.BLACK), new Value(Color.BLUE), new Value(Color.CYAN), new Value(Color.DARK_GRAY), new Value(Color.GRAY), new Value(Color.GREEN), new Value(Color.LIGHT_GRAY), new Value(Color.MAGENTA), new Value(Color.ORANGE), new Value(Color.PINK), new Value(Color.RED), new Value(Color.WHITE), new Value(Color.YELLOW), CUSTOM_COLOR, new Value(NbBundle.getMessage(SplashUISupport.class, (String)"SplashUISupport_color_none"), null)};
        }

        private static class Editor
        extends JLabel
        implements ComboBoxEditor {
            private Object value;

            Editor() {
            }

            @Override
            public Component getEditorComponent() {
                return this;
            }

            @Override
            public void setItem(Object anObject) {
                this.value = anObject;
                if (this.value instanceof String) {
                    this.setText(NbBundle.getMessage(SplashUISupport.class, (String)"SplashUISupport_color_default"));
                    super.setForeground(SystemColor.textText);
                    super.setBackground(SystemColor.text);
                } else {
                    this.setText("");
                    super.setBackground((Color)this.value);
                }
            }

            @Override
            public Object getItem() {
                return this.value;
            }

            @Override
            public void setBackground(Color c) {
            }

            @Override
            public void setForeground(Color c) {
            }

            @Override
            public void selectAll() {
            }

            @Override
            public void addActionListener(ActionListener l) {
            }

            @Override
            public void removeActionListener(ActionListener l) {
            }
        }

        private class Renderer
        extends JComponent
        implements ListCellRenderer,
        ComboBoxEditor {
            private int SIZE = 9;
            private Value value;

            Renderer() {
                this.setPreferredSize(new Dimension(50, this.getFontMetrics(ColorComboBox.this.getFont()).getHeight() + 2));
                this.setOpaque(true);
            }

            @Override
            public void paint(Graphics g) {
                Graphics2D g2d = (Graphics2D)g;
                if (!this.isEnabled()) {
                    g2d.setComposite(AlphaComposite.getInstance(3, 0.3f));
                }
                Color oldColor = g.getColor();
                Dimension size = this.getSize();
                g.setColor(this.getBackground());
                g.fillRect(0, 0, size.width, size.height);
                int i = (size.height - this.SIZE) / 2;
                if (this.value.color != null) {
                    g.setColor(Color.black);
                    g.drawRect(i, i, this.SIZE, this.SIZE);
                    g.setColor(this.value.color);
                    g.fillRect(i + 1, i + 1, this.SIZE - 1, this.SIZE - 1);
                }
                if (this.value.text != null) {
                    g.setColor(Color.black);
                    if (this.value.color != null) {
                        g.drawString(this.value.text, i + this.SIZE + 5, i + this.SIZE);
                    } else {
                        g.drawString(this.value.text, 5, i + this.SIZE);
                    }
                }
                g.setColor(oldColor);
            }

            @Override
            public void setEnabled(boolean enabled) {
                this.setBackground(enabled ? SystemColor.text : SystemColor.control);
                super.setEnabled(enabled);
            }

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                this.value = (Value)value;
                this.setEnabled(list.isEnabled());
                return this;
            }

            @Override
            public Component getEditorComponent() {
                this.setEnabled(ColorComboBox.this.isEnabled());
                return this;
            }

            @Override
            public void setItem(Object anObject) {
                this.value = (Value)anObject;
            }

            @Override
            public Object getItem() {
                return this.value;
            }

            @Override
            public void selectAll() {
            }

            @Override
            public void addActionListener(ActionListener l) {
            }

            @Override
            public void removeActionListener(ActionListener l) {
            }
        }

        public static class Value {
            String text;
            Color color;

            Value(Color color) {
                this.color = color;
                this.text = (String)colorMap.get(color);
                if (this.text != null) {
                    return;
                }
                StringBuffer sb = new StringBuffer();
                sb.append('[').append(color.getRed()).append(',').append(color.getGreen()).append(',').append(color.getBlue()).append(']');
                this.text = sb.toString();
            }

            Value(String text, Color color) {
                this.text = text;
                this.color = color;
            }
        }
    }

    private static class FontFormatter
    extends DefaultFormatter {
        private JFormattedTextField.AbstractFormatter deleg;

        FontFormatter(JFormattedTextField.AbstractFormatter deleg) {
            this.setOverwriteMode(false);
            this.deleg = deleg;
        }

        @Override
        public Object stringToValue(String string) throws ParseException {
            Object retval = this.deleg.stringToValue(string);
            int i = ((Number)retval).intValue();
            if (i < 0) {
                throw new ParseException(string, 0);
            }
            return retval;
        }

        @Override
        public String valueToString(Object value) throws ParseException {
            return this.deleg.valueToString(value);
        }
    }
}

