/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.branding;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import org.netbeans.modules.apisupport.project.ui.branding.SplashComponentPreview;

final class DragManager
implements DragGestureListener,
DragSourceListener,
DropTargetListener,
MouseMotionListener {
    private JComponent component;
    private DragGestureRecognizer dRecognizer;
    private DragSource dSource;
    private DropTarget dTarget;
    private int translateX;
    private int translateY;
    private final Cursor oCursor;
    List<DragItem> allItems = new ArrayList<DragItem>();
    private DragItem activeDragItem = null;

    DragManager(JComponent component) {
        this.component = component;
        this.dSource = new DragSource();
        this.dRecognizer = this.dSource.createDefaultDragGestureRecognizer(this.component, 2, this);
        this.dTarget = new DropTarget(this.component, 2, this);
        component.addMouseMotionListener(this);
        this.oCursor = component.getCursor();
    }

    DragItem createNewItem() {
        DragItem retval = new DragItem();
        this.allItems.add(retval);
        return retval;
    }

    void setTranslate(int translateX, int translateY) {
        this.translateX = -translateX;
        this.translateY = -translateY;
        SplashComponentPreview scomp = (SplashComponentPreview)this.component;
        if (scomp.image != null) {
            Rectangle bounds = new Rectangle(new Dimension(scomp.image.getWidth(null), scomp.image.getHeight(null)));
            for (DragItem elem : this.allItems) {
                elem.setBounds(bounds);
            }
        }
    }

    public void paint(Graphics g) {
        g.setXORMode(Color.white);
        for (DragItem elem : this.allItems) {
            elem.paint(g);
        }
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent dge) {
        Point gesturePoint = dge.getDragOrigin();
        DragItem item = this.getDragItem(this.transformMousePoint(gesturePoint));
        if (item != null) {
            this.activeDragItem = item;
            this.activeDragItem.setGesturePoint(gesturePoint);
            Cursor curs = this.activeDragItem.getCursor();
            assert (curs != null);
            dge.startDrag(curs, new StringSelection(""), this);
            this.component.repaint();
        }
    }

    private Point transformMousePoint(Point mousePoint) {
        return new Point(mousePoint.x + this.translateX, mousePoint.y + this.translateY);
    }

    @Override
    public void dragEnter(DragSourceDragEvent dsde) {
    }

    @Override
    public void dragOver(DragSourceDragEvent dsde) {
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent dsde) {
    }

    @Override
    public void dragExit(DragSourceEvent dse) {
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent dsde) {
        if (!dsde.getDropSuccess() && this.activeDragItem != null) {
            this.activeDragItem.dragAccepted();
        }
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
        this.dragOverImpl(dtde.getLocation());
    }

    private void dragOverImpl(Point p) {
        if (this.activeDragItem != null) {
            this.activeDragItem.recalculateSize(p);
            this.activeDragItem.updateSize();
            this.activeDragItem.scroll(this.component);
            this.component.repaint();
        }
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    @Override
    public void dragExit(DropTargetEvent dte) {
    }

    @Override
    public void drop(DropTargetDropEvent dtde) {
        if (dtde.isDataFlavorSupported(DataFlavor.stringFlavor)) {
            dtde.dropComplete(true);
            if (this.activeDragItem != null) {
                this.activeDragItem.dragAccepted();
            }
        } else {
            dtde.rejectDrop();
        }
        this.component.setCursor(this.oCursor);
        this.activeDragItem = null;
        this.component.repaint();
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.activeDragItem = null;
        DragItem item = null;
        for (DragItem elem : this.allItems) {
            if (!elem.contains(this.transformMousePoint(e.getPoint()))) continue;
            item = elem;
            break;
        }
        if (item != null) {
            Cursor c = item.getCursor();
            this.component.setCursor(c);
        } else {
            this.component.setCursor(this.oCursor);
        }
    }

    DragItem getDragItem(Point p2Compare) {
        DragItem retval = null;
        for (DragItem elem : this.allItems) {
            if (!elem.contains(p2Compare)) continue;
            retval = elem;
            break;
        }
        return retval;
    }

    static class DragItem
    implements Mode {
        private Point gesturePoint = new Point();
        private Rectangle rectangle = new Rectangle();
        private Rectangle currentDragRect = new Rectangle();
        private Mode dragMode;
        private DropHandler dHandler;
        private Rectangle bounds;
        private Mode[] allmodes = new Mode[9];
        private boolean enabled = true;

        DragItem() {
            this.allmodes[0] = new OneSideScaleMode(5);
            this.allmodes[1] = new OneSideScaleMode(7);
            this.allmodes[2] = new OneSideScaleMode(8);
            this.allmodes[3] = new OneSideScaleMode(6);
            this.allmodes[4] = new ScaleMode(0);
            this.allmodes[5] = new ScaleMode(1);
            this.allmodes[6] = new ScaleMode(2);
            this.allmodes[7] = new ScaleMode(3);
            this.allmodes[8] = new MoveMode();
        }

        void setDropHandler(DropHandler dHandler) {
            this.dHandler = dHandler;
        }

        public void dragAccepted() {
            if (this.dHandler != null) {
                this.dHandler.dragAccepted(this.rectangle, this.currentDragRect);
            }
        }

        void setRectangle(Rectangle rectangle) {
            this.rectangle.setBounds(rectangle);
            this.currentDragRect.setBounds(rectangle);
            this.updateSize(rectangle);
        }

        void setGesturePoint(Point gesturePoint) {
            this.gesturePoint = gesturePoint;
        }

        Point getGesturePoint() {
            return this.gesturePoint;
        }

        @Override
        public boolean contains(Point point) {
            Mode mode = null;
            if (this.isEnabled()) {
                for (int i = 0; i < this.allmodes.length; ++i) {
                    if (!this.allmodes[i].contains(point)) continue;
                    mode = this.allmodes[i];
                    break;
                }
            }
            this.dragMode = mode;
            return mode != null;
        }

        public void updateSize() {
            this.updateSize(this.currentDragRect);
        }

        @Override
        public void updateSize(Rectangle rec) {
            for (int i = 0; i < this.allmodes.length; ++i) {
                this.allmodes[i].updateSize(rec);
            }
        }

        @Override
        public void recalculateSize(Point p) {
            if (this.dragMode != null && !p.equals(this.gesturePoint)) {
                Rectangle oldtDragRect = new Rectangle();
                oldtDragRect.setBounds(this.currentDragRect);
                this.dragMode.recalculateSize(p);
                int x = this.currentDragRect.x;
                int y = this.currentDragRect.y;
                int w = this.currentDragRect.width;
                int h = this.currentDragRect.height;
                if (this.bounds != null && !this.bounds.contains(this.currentDragRect)) {
                    if (h + y > this.bounds.height + this.bounds.y) {
                        if (y == oldtDragRect.y) {
                            h = this.bounds.height + this.bounds.y - y;
                        } else {
                            y = this.bounds.height + this.bounds.y - h;
                        }
                    }
                    if (w + x > this.bounds.width + this.bounds.x) {
                        if (x == oldtDragRect.x) {
                            w = this.bounds.width + this.bounds.x - x;
                        } else {
                            x = this.bounds.width + this.bounds.x - w;
                        }
                    }
                    if (x < this.bounds.x) {
                        x = this.bounds.x;
                    }
                    if (y < this.bounds.y) {
                        y = this.bounds.y;
                    }
                    this.currentDragRect.setBounds(x, y, w, h);
                }
                if (w <= 3 || h <= 3 && !(this.dragMode instanceof MoveMode)) {
                    this.currentDragRect.setBounds(oldtDragRect);
                }
            }
        }

        public void scroll(JComponent component) {
            component.scrollRectToVisible(this.currentDragRect);
        }

        void setBounds(Rectangle bounds) {
            this.bounds = bounds;
        }

        @Override
        public void paint(Graphics g) {
            if (this.isEnabled()) {
                for (int i = 0; i < this.allmodes.length; ++i) {
                    this.allmodes[i].paint(g);
                }
            }
        }

        @Override
        public Cursor getCursor() {
            return this.dragMode != null ? this.dragMode.getCursor() : null;
        }

        boolean isEnabled() {
            return this.enabled;
        }

        void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        private class MoveMode
        implements Mode {
            private MoveMode() {
            }

            @Override
            public boolean contains(Point point) {
                return DragItem.this.currentDragRect != null && DragItem.this.currentDragRect.contains(point);
            }

            @Override
            public void updateSize(Rectangle rec) {
            }

            @Override
            public void paint(Graphics g) {
            }

            @Override
            public Cursor getCursor() {
                return Cursor.getPredefinedCursor(13);
            }

            @Override
            public void recalculateSize(Point p) {
                DragItem.this.currentDragRect.setBounds(p.x - ((DragItem)DragItem.this).gesturePoint.x + ((DragItem)DragItem.this).rectangle.x, p.y - ((DragItem)DragItem.this).gesturePoint.y + ((DragItem)DragItem.this).rectangle.y, ((DragItem)DragItem.this).rectangle.width, ((DragItem)DragItem.this).rectangle.height);
            }
        }

        private class OneSideScaleMode
        implements Mode {
            static final int N_RESIZE_MODE = 5;
            static final int E_RESIZE_MODE = 6;
            static final int S_RESIZE_MODE = 7;
            static final int W_RESIZE_MODE = 8;
            private int resizeMode = -1;
            private Rectangle rec = new Rectangle();

            OneSideScaleMode(int resizeMode) {
                this.resizeMode = resizeMode;
            }

            @Override
            public boolean contains(Point point) {
                assert (this.resizeMode != -1);
                assert (this.rec != null);
                return this.rec.contains(point);
            }

            @Override
            public void updateSize(Rectangle currentDragRect) {
                assert (this.resizeMode != -1);
                int inset = 5;
                switch (this.resizeMode) {
                    case 5: {
                        this.rec = new Rectangle(currentDragRect.x + inset, currentDragRect.y - 2 * inset, currentDragRect.width - inset, 2 * inset);
                        break;
                    }
                    case 6: {
                        this.rec = new Rectangle(currentDragRect.x + currentDragRect.width, currentDragRect.y + inset, 2 * inset, currentDragRect.height - inset);
                        break;
                    }
                    case 7: {
                        this.rec = new Rectangle(currentDragRect.x + inset, currentDragRect.y + currentDragRect.height, currentDragRect.width - inset, 2 * inset);
                        break;
                    }
                    case 8: {
                        this.rec = new Rectangle(currentDragRect.x - 2 * inset, currentDragRect.y + inset, 2 * inset, currentDragRect.height - inset);
                    }
                }
            }

            @Override
            public void paint(Graphics g) {
                assert (this.resizeMode != -1);
                assert (this.rec != null);
                int inset = 5;
                Graphics2D g2d = (Graphics2D)g;
                Stroke oStroke = g2d.getStroke();
                g2d.setStroke(new BasicStroke(1.0f, 0, 0, 10.0f, new float[]{3.0f}, 0.0f));
                Rectangle2D rec2d = this.rec.getBounds2D();
                Line2D.Double line = null;
                switch (this.resizeMode) {
                    case 5: {
                        line = new Line2D.Double(rec2d.getMinX(), rec2d.getMaxY(), rec2d.getMaxX() - (double)inset, rec2d.getMaxY());
                        break;
                    }
                    case 6: {
                        line = new Line2D.Double(rec2d.getMinX(), rec2d.getMinY(), rec2d.getMinX(), rec2d.getMaxY() - (double)inset);
                        break;
                    }
                    case 7: {
                        line = new Line2D.Double(rec2d.getMinX(), rec2d.getMinY(), rec2d.getMaxX() - (double)inset, rec2d.getMinY());
                        break;
                    }
                    case 8: {
                        line = new Line2D.Double(rec2d.getMaxX(), rec2d.getMinY(), rec2d.getMaxX(), rec2d.getMaxY() - (double)inset);
                    }
                }
                g2d.draw(line);
                g2d.setStroke(oStroke);
            }

            @Override
            public Cursor getCursor() {
                assert (this.resizeMode != -1);
                assert (this.rec != null);
                Cursor retval = null;
                switch (this.resizeMode) {
                    case 5: {
                        retval = Cursor.getPredefinedCursor(8);
                        break;
                    }
                    case 6: {
                        retval = Cursor.getPredefinedCursor(11);
                        break;
                    }
                    case 7: {
                        retval = Cursor.getPredefinedCursor(9);
                        break;
                    }
                    case 8: {
                        retval = Cursor.getPredefinedCursor(10);
                    }
                }
                assert (retval != null);
                return retval;
            }

            @Override
            public void recalculateSize(Point p) {
                int xDelta = p.x - ((DragItem)DragItem.this).gesturePoint.x;
                int yDelta = p.y - ((DragItem)DragItem.this).gesturePoint.y;
                switch (this.resizeMode) {
                    case 5: {
                        DragItem.this.currentDragRect.setBounds(((DragItem)DragItem.this).rectangle.x, ((DragItem)DragItem.this).rectangle.y + yDelta, ((DragItem)DragItem.this).rectangle.width, ((DragItem)DragItem.this).rectangle.height - yDelta);
                        break;
                    }
                    case 6: {
                        DragItem.this.currentDragRect.setBounds(((DragItem)DragItem.this).rectangle.x, ((DragItem)DragItem.this).rectangle.y, ((DragItem)DragItem.this).rectangle.width + xDelta, ((DragItem)DragItem.this).rectangle.height);
                        break;
                    }
                    case 7: {
                        DragItem.this.currentDragRect.setBounds(((DragItem)DragItem.this).rectangle.x, ((DragItem)DragItem.this).rectangle.y, ((DragItem)DragItem.this).rectangle.width, ((DragItem)DragItem.this).rectangle.height + yDelta);
                        break;
                    }
                    case 8: {
                        DragItem.this.currentDragRect.setBounds(((DragItem)DragItem.this).rectangle.x + xDelta, ((DragItem)DragItem.this).rectangle.y, ((DragItem)DragItem.this).rectangle.width - xDelta, ((DragItem)DragItem.this).rectangle.height);
                    }
                }
            }
        }

        private class ScaleMode
        implements Mode {
            static final int NW_RESIZE_MODE = 0;
            static final int NE_RESIZE_MODE = 1;
            static final int SW_RESIZE_MODE = 2;
            static final int SE_RESIZE_MODE = 3;
            private int resizeMode = -1;
            private Rectangle rec = new Rectangle();

            ScaleMode(int resizeMode) {
                this.resizeMode = resizeMode;
            }

            @Override
            public boolean contains(Point point) {
                assert (this.resizeMode != -1);
                assert (this.rec != null);
                return this.rec.contains(point);
            }

            @Override
            public void updateSize(Rectangle currentDragRect) {
                assert (this.resizeMode != -1);
                int inset = Math.min(Math.min(5, currentDragRect.width / 5), Math.min(5, currentDragRect.height / 5));
                Dimension d = new Dimension(inset * 2, inset * 2);
                Point origin = new Point(currentDragRect.x - inset, currentDragRect.y - inset);
                switch (this.resizeMode) {
                    case 0: {
                        this.rec = new Rectangle(origin, d);
                        break;
                    }
                    case 1: {
                        this.rec = new Rectangle(new Point(origin.x + currentDragRect.width, origin.y), d);
                        break;
                    }
                    case 2: {
                        this.rec = new Rectangle(new Point(origin.x, origin.y + currentDragRect.height), d);
                        break;
                    }
                    case 3: {
                        this.rec = new Rectangle(new Point(origin.x + currentDragRect.width, origin.y + currentDragRect.height), d);
                    }
                }
            }

            @Override
            public void paint(Graphics g) {
                assert (this.resizeMode != -1);
                assert (this.rec != null);
                g.fillRect(this.rec.x, this.rec.y, this.rec.width, this.rec.height);
            }

            @Override
            public Cursor getCursor() {
                assert (this.resizeMode != -1);
                assert (this.rec != null);
                Cursor retval = null;
                switch (this.resizeMode) {
                    case 0: {
                        retval = Cursor.getPredefinedCursor(6);
                        break;
                    }
                    case 1: {
                        retval = Cursor.getPredefinedCursor(7);
                        break;
                    }
                    case 2: {
                        retval = Cursor.getPredefinedCursor(4);
                        break;
                    }
                    case 3: {
                        retval = Cursor.getPredefinedCursor(5);
                    }
                }
                assert (retval != null);
                return retval;
            }

            @Override
            public void recalculateSize(Point p) {
                int xDelta = p.x - ((DragItem)DragItem.this).gesturePoint.x;
                int yDelta = p.y - ((DragItem)DragItem.this).gesturePoint.y;
                switch (this.resizeMode) {
                    case 0: {
                        DragItem.this.currentDragRect.setBounds(((DragItem)DragItem.this).rectangle.x + xDelta, ((DragItem)DragItem.this).rectangle.y + yDelta, ((DragItem)DragItem.this).rectangle.width - xDelta, ((DragItem)DragItem.this).rectangle.height - yDelta);
                        break;
                    }
                    case 1: {
                        DragItem.this.currentDragRect.setBounds(((DragItem)DragItem.this).rectangle.x, ((DragItem)DragItem.this).rectangle.y + yDelta, ((DragItem)DragItem.this).rectangle.width + xDelta, ((DragItem)DragItem.this).rectangle.height - yDelta);
                        break;
                    }
                    case 2: {
                        DragItem.this.currentDragRect.setBounds(((DragItem)DragItem.this).rectangle.x + xDelta, ((DragItem)DragItem.this).rectangle.y, ((DragItem)DragItem.this).rectangle.width - xDelta, ((DragItem)DragItem.this).rectangle.height + yDelta);
                        break;
                    }
                    case 3: {
                        DragItem.this.currentDragRect.setBounds(((DragItem)DragItem.this).rectangle.x, ((DragItem)DragItem.this).rectangle.y, ((DragItem)DragItem.this).rectangle.width + xDelta, ((DragItem)DragItem.this).rectangle.height + yDelta);
                    }
                }
            }
        }
    }

    static interface DropHandler {
        public void dragAccepted(Rectangle var1, Rectangle var2);
    }

    private static interface Mode {
        public boolean contains(Point var1);

        public void updateSize(Rectangle var1);

        public void recalculateSize(Point var1);

        public void paint(Graphics var1);

        public Cursor getCursor();
    }
}

