/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.api;

import java.util.Set;
import org.netbeans.api.project.Project;
import org.netbeans.modules.apisupport.project.api.LayerHandle;
import org.netbeans.modules.apisupport.project.layers.LayerNode;
import org.netbeans.modules.apisupport.project.spi.NbModuleProvider;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.loaders.DataObject;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;

public final class NodeFactoryUtils {
    private NodeFactoryUtils() {
    }

    public static Node createLayersNode(Project project) {
        NbModuleProvider prv = (NbModuleProvider)project.getLookup().lookup(NbModuleProvider.class);
        if (prv != null && prv.getManifestFile() != null) {
            return NodeFactoryUtils.createLayerNode(project);
        }
        return null;
    }

    private static Node createLayerNode(Project prj) {
        LayerHandle handle = LayerHandle.forProject(prj);
        if (handle != null && handle.getLayerFile() != null) {
            return new SpecialFileNode((Node)new LayerNode(handle), null);
        }
        return null;
    }

    public static Node createSpecialFileNode(Node orig, String displayName) {
        return new SpecialFileNode(orig, displayName);
    }

    public static String computeAnnotatedHtmlDisplayName(String htmlDisplayName, Set<? extends FileObject> files) {
        String result = null;
        if (files != null && files.iterator().hasNext()) {
            try {
                FileSystem.HtmlStatus hstat;
                String annotated;
                FileObject fo = files.iterator().next();
                FileSystem.Status stat = fo.getFileSystem().getStatus();
                if (stat instanceof FileSystem.HtmlStatus && !htmlDisplayName.equals(annotated = (hstat = (FileSystem.HtmlStatus)stat).annotateNameHtml(htmlDisplayName, files))) {
                    result = annotated;
                }
            }
            catch (FileStateInvalidException e) {
                ErrorManager.getDefault().notify(1, (Throwable)e);
            }
        }
        return result;
    }

    private static final class SpecialFileNode
    extends FilterNode {
        private final String displayName;

        public SpecialFileNode(Node orig, String displayName) {
            super(orig);
            this.displayName = displayName;
        }

        public String getDisplayName() {
            if (this.displayName != null) {
                return this.displayName;
            }
            return super.getDisplayName();
        }

        public boolean canRename() {
            return false;
        }

        public boolean canDestroy() {
            return false;
        }

        public boolean canCut() {
            return false;
        }

        public String getHtmlDisplayName() {
            String result = null;
            DataObject dob = (DataObject)this.getLookup().lookup(DataObject.class);
            if (dob != null) {
                Set files = dob.files();
                result = NodeFactoryUtils.computeAnnotatedHtmlDisplayName(this.getDisplayName(), files);
            }
            return result;
        }
    }
}

