/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.api;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class EditableManifest {
    private static final String MANIFEST_VERSION = "Manifest-Version";
    private static final String MANIFEST_VERSION_VALUE = "1.0";
    private final Section mainSection;
    private final List<Section> sections;
    private static final String RET = System.getProperty("line.separator");

    public EditableManifest() {
        try {
            this.mainSection = new Section(Collections.singletonList(new Line(MANIFEST_VERSION, MANIFEST_VERSION_VALUE)), true, 1);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
        this.sections = new ArrayList<Section>();
    }

    public EditableManifest(InputStream is) throws IOException {
        BufferedReader r = new BufferedReader(new InputStreamReader(is, "UTF-8"));
        this.sections = new LinkedList<Section>();
        int blankLines = 0;
        ArrayList<Line> lines = new ArrayList<Line>();
        Section _mainSection = null;
        while (true) {
            String text;
            if ((text = r.readLine()) == null || text.length() > 0 && blankLines > 0) {
                Section s = new Section(lines, _mainSection == null, blankLines);
                if (_mainSection == null) {
                    _mainSection = s;
                } else {
                    this.sections.add(s);
                }
                lines.clear();
                blankLines = 0;
            }
            if (text == null) break;
            if (text.length() > 0) {
                Line line;
                if (text.charAt(0) == ' ') {
                    if (lines.isEmpty()) {
                        throw new IOException("Continuation lines only allowed for attributes");
                    }
                    Line prev = (Line)lines.remove(lines.size() - 1);
                    line = new Line(prev.name, prev.value + text.substring(1), prev.text + System.getProperty("line.separator") + text);
                } else {
                    line = new Line(text);
                }
                lines.add(line);
                continue;
            }
            ++blankLines;
        }
        this.mainSection = _mainSection;
        HashSet<String> names = new HashSet<String>();
        for (Section s : this.sections) {
            if (names.add(s.name)) continue;
            throw new IOException("Duplicated section names: " + s.name);
        }
    }

    public void write(OutputStream os) throws IOException {
        OutputStreamWriter w = new OutputStreamWriter(os, "UTF-8");
        this.mainSection.write(w, !this.sections.isEmpty());
        Iterator<Section> it = this.sections.iterator();
        while (it.hasNext()) {
            it.next().write(w, it.hasNext());
        }
        ((Writer)w).flush();
    }

    public void addSection(String name) throws IllegalArgumentException {
        int i;
        if (name == null) {
            throw new IllegalArgumentException();
        }
        if (this.findSection(name) != null) {
            throw new IllegalArgumentException(name);
        }
        for (i = 0; i < this.sections.size(); ++i) {
            Section s = this.sections.get(i);
            if (s.name.compareTo(name) > 0) break;
        }
        this.sections.add(i, new Section(name));
    }

    public void removeSection(String name) throws IllegalArgumentException {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        Iterator<Section> it = this.sections.iterator();
        while (it.hasNext()) {
            Section s = it.next();
            if (!s.name.equals(name)) continue;
            it.remove();
            return;
        }
        throw new IllegalArgumentException(name);
    }

    public Set<String> getSectionNames() {
        HashSet<String> names = new HashSet<String>();
        for (Section s : this.sections) {
            names.add(s.name);
        }
        return names;
    }

    private Section findSection(String section) {
        if (section == null) {
            return this.mainSection;
        }
        for (Section s : this.sections) {
            if (!s.name.equals(section)) continue;
            return s;
        }
        return null;
    }

    public String getAttribute(String name, String section) throws IllegalArgumentException {
        Section s = this.findSection(section);
        if (s == null) {
            throw new IllegalArgumentException(section);
        }
        return s.getAttribute(name);
    }

    public void setAttribute(String name, String value, String section) throws IllegalArgumentException {
        Section s = this.findSection(section);
        if (s == null) {
            throw new IllegalArgumentException(section);
        }
        s.setAttribute(name, value);
    }

    public void removeAttribute(String name, String section) throws IllegalArgumentException {
        Section s = this.findSection(section);
        if (s == null) {
            throw new IllegalArgumentException(section);
        }
        s.removeAttribute(name);
    }

    public Set<String> getAttributeNames(String section) throws IllegalArgumentException {
        Section s = this.findSection(section);
        if (s == null) {
            throw new IllegalArgumentException(section);
        }
        return s.getAttributeNames();
    }

    private static void newline(Writer w) throws IOException {
        w.write(RET);
    }

    private static final class Line {
        private static final Pattern NAME_VALUE = Pattern.compile("([^: ]+) *: *(.*)");
        public final String text;
        public final String name;
        public final String value;
        private static final Pattern NEWLINE = Pattern.compile("\r?\n");

        public Line(String text) throws IOException {
            this.text = text;
            assert (text.length() > 0);
            Matcher m = NAME_VALUE.matcher(text);
            if (!m.matches()) {
                throw new IOException("Malformed line: " + text);
            }
            this.name = m.group(1);
            this.value = m.group(2);
        }

        public Line(String name, String value) {
            this(name, value, name + ": " + value);
        }

        public Line(String name, String value, String text) {
            this.name = name;
            this.value = value;
            this.text = text;
        }

        public void write(Writer w) throws IOException {
            String output = NEWLINE.matcher(this.text).replaceAll(RET);
            w.write(output);
            EditableManifest.newline(w);
        }
    }

    private static final class Section {
        private static final String NAME = "Name";
        public final String name;
        private final List<Line> lines;
        private final int blankLinesAfter;

        public Section(List<Line> lines, boolean main, int blankLinesAfter) throws IOException {
            Line first;
            this.lines = new ArrayList<Line>(lines);
            this.blankLinesAfter = blankLinesAfter;
            if (main) {
                this.name = null;
                if (!lines.isEmpty()) {
                    first = lines.get(0);
                    if (first.name.equalsIgnoreCase(NAME)) {
                        throw new IOException("Cannot start with a named section");
                    }
                }
            } else {
                assert (!lines.isEmpty());
                first = lines.get(0);
                if (!first.name.equalsIgnoreCase(NAME)) {
                    throw new IOException("Section did not start with Name");
                }
                this.name = first.value;
                if (this.name.length() == 0) {
                    throw new IOException("Cannot have a blank section name");
                }
            }
            HashSet<String> attrNames = new HashSet<String>();
            Iterator<Line> it = lines.iterator();
            if (!main) {
                it.next();
            }
            while (it.hasNext()) {
                String name = it.next().name;
                if (name.equals(NAME)) {
                    throw new IOException("Sections not separated by blank lines");
                }
                if (attrNames.add(name.toLowerCase(Locale.US))) continue;
                throw new IOException("Duplicated attributes in a section: " + name);
            }
        }

        public Section(String name) {
            this.name = name;
            this.lines = new ArrayList<Line>();
            this.lines.add(new Line(NAME, name));
            this.blankLinesAfter = 1;
        }

        private Line findAttribute(String name) {
            Iterator<Line> it = this.lines.iterator();
            if (this.name != null) {
                it.next();
            }
            while (it.hasNext()) {
                Line line = it.next();
                if (!line.name.equalsIgnoreCase(name)) continue;
                return line;
            }
            return null;
        }

        private int findAttributeIndex(String name) {
            int i;
            int n = i = this.name != null ? 1 : 0;
            while (i < this.lines.size()) {
                Line line = this.lines.get(i);
                if (line.name.equalsIgnoreCase(name)) {
                    return i;
                }
                ++i;
            }
            return -1;
        }

        public String getAttribute(String name) {
            Line line = this.findAttribute(name);
            if (line != null) {
                return line.value;
            }
            return null;
        }

        public void setAttribute(String name, String value) {
            int insertionPoint;
            int i;
            int n = i = this.name != null ? 1 : 0;
            while (i < this.lines.size()) {
                Line line = this.lines.get(i);
                if (name.equalsIgnoreCase(line.name)) {
                    if (line.value.equals(value)) {
                        return;
                    }
                    this.lines.remove(i);
                    int insertionPoint2 = name.equalsIgnoreCase(EditableManifest.MANIFEST_VERSION) ? 0 : i;
                    this.lines.add(insertionPoint2, new Line(name, value));
                    return;
                }
                ++i;
            }
            if (name.equalsIgnoreCase(EditableManifest.MANIFEST_VERSION)) {
                insertionPoint = 0;
            } else {
                int i2;
                insertionPoint = this.lines.size();
                int n2 = i2 = this.name != null ? 1 : 0;
                while (i2 < this.lines.size()) {
                    Line line = this.lines.get(i2);
                    int comp = line.name.compareToIgnoreCase(name);
                    assert (comp != 0);
                    if (comp > 0 && !line.name.equalsIgnoreCase(EditableManifest.MANIFEST_VERSION)) {
                        insertionPoint = i2;
                        break;
                    }
                    ++i2;
                }
            }
            this.lines.add(insertionPoint, new Line(name, value));
        }

        public void removeAttribute(String name) throws IllegalArgumentException {
            int i = this.findAttributeIndex(name);
            if (i == -1) {
                throw new IllegalArgumentException(name);
            }
            this.lines.remove(i);
        }

        public Set<String> getAttributeNames() {
            HashSet<String> attrNames = new HashSet<String>();
            Iterator<Line> it = this.lines.iterator();
            if (this.name != null) {
                it.next();
            }
            while (it.hasNext()) {
                attrNames.add(it.next().name);
            }
            return attrNames;
        }

        public void write(Writer w, boolean forceBlankLine) throws IOException {
            for (Line line : this.lines) {
                line.write(w);
            }
            for (int i = 0; i < this.blankLinesAfter; ++i) {
                EditableManifest.newline(w);
            }
            if (forceBlankLine && this.blankLinesAfter == 0) {
                EditableManifest.newline(w);
            }
        }
    }
}

