/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.format.checkstyle;

import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import org.netbeans.modules.maven.api.customizer.ModelHandle2;
import org.netbeans.modules.maven.api.customizer.support.CheckBoxUpdater;
import org.netbeans.modules.maven.format.checkstyle.AuxPropsImpl;
import org.netbeans.modules.maven.model.ModelOperation;
import org.netbeans.modules.maven.model.pom.Configuration;
import org.netbeans.modules.maven.model.pom.POMModel;
import org.netbeans.modules.maven.model.pom.Properties;
import org.netbeans.modules.maven.model.pom.ReportPlugin;
import org.netbeans.modules.maven.model.pom.Reporting;
import org.netbeans.spi.project.ui.support.ProjectCustomizer;
import org.openide.awt.HtmlBrowser;
import org.openide.awt.Mnemonics;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class CheckstylePanel
extends JPanel {
    private final ModelHandle2 handle;
    private final ProjectCustomizer.Category category;
    private boolean generated = false;
    private final CheckBoxUpdater checkboxUpdater;
    private JButton btnLearnMore;
    private JButton btnMissing;
    private JCheckBox cbEnable;
    private JLabel lblHint;
    private JLabel lblMissing;

    CheckstylePanel(ModelHandle2 hndl, ProjectCustomizer.Category cat) {
        this.initComponents();
        this.handle = hndl;
        this.category = cat;
        this.checkboxUpdater = new CheckBoxUpdater(this.cbEnable){
            private String modifiedValue;
            private ModelOperation<POMModel> operation;
            {
                this.operation = new ModelOperation<POMModel>(){

                    public void performOperation(POMModel model) {
                        Properties modprops = model.getProject().getProperties();
                        if (modprops == null) {
                            modprops = model.getFactory().createProperties();
                            model.getProject().setProperties(modprops);
                        }
                        modprops.setProperty("netbeans.checkstyle.format", modifiedValue);
                    }
                };
            }

            public Boolean getValue() {
                Properties props;
                String val = this.modifiedValue;
                if (val == null && (props = CheckstylePanel.this.handle.getPOMModel().getProject().getProperties()) != null) {
                    val = props.getProperty("netbeans.checkstyle.format");
                }
                if (val == null) {
                    val = CheckstylePanel.this.handle.getRawAuxiliaryProperty("netbeans.checkstyle.format", true);
                }
                if (val != null) {
                    Boolean ret = Boolean.parseBoolean(val);
                    return ret;
                }
                return null;
            }

            public boolean getDefaultValue() {
                return Boolean.FALSE;
            }

            public void setValue(Boolean value) {
                boolean hasConfig;
                CheckstylePanel.this.handle.removePOMModification(this.operation);
                this.modifiedValue = null;
                String val = value != null ? value.toString() : null;
                boolean bl = hasConfig = CheckstylePanel.this.handle.getRawAuxiliaryProperty("netbeans.checkstyle.format", true) != null;
                if (CheckstylePanel.this.handle.getProject().getProperties().containsKey("netbeans.checkstyle.format")) {
                    this.modifiedValue = val;
                    CheckstylePanel.this.handle.addPOMModification(this.operation);
                    if (hasConfig) {
                        CheckstylePanel.this.handle.setRawAuxiliaryProperty("netbeans.checkstyle.format", null, true);
                    }
                    return;
                }
                CheckstylePanel.this.handle.setRawAuxiliaryProperty("netbeans.checkstyle.format", val, true);
            }
        };
        this.btnLearnMore.setCursor(Cursor.getPredefinedCursor(12));
        this.btnLearnMore.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    HtmlBrowser.URLDisplayer.getDefault().showURL(new URL("http://maven.apache.org/plugins/maven-checkstyle-plugin"));
                }
                catch (MalformedURLException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        });
    }

    @Override
    public void addNotify() {
        super.addNotify();
        boolean defines = AuxPropsImpl.definesCheckStyle(this.handle.getProject());
        boolean missing = !defines && !this.generated;
        this.lblMissing.setVisible(missing);
        this.btnMissing.setVisible(missing);
    }

    private void initComponents() {
        this.cbEnable = new JCheckBox();
        this.lblHint = new JLabel();
        this.lblMissing = new JLabel();
        this.btnMissing = new JButton();
        this.btnLearnMore = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)this.cbEnable, (String)NbBundle.getMessage(CheckstylePanel.class, (String)"CheckstylePanel.cbEnable.text"));
        Mnemonics.setLocalizedText((JLabel)this.lblHint, (String)NbBundle.getMessage(CheckstylePanel.class, (String)"CheckstylePanel.lblHint.text"));
        this.lblHint.setVerticalAlignment(1);
        Mnemonics.setLocalizedText((JLabel)this.lblMissing, (String)NbBundle.getMessage(CheckstylePanel.class, (String)"CheckstylePanel.lblMissing.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.btnMissing, (String)NbBundle.getMessage(CheckstylePanel.class, (String)"CheckstylePanel.btnMissing.text"));
        this.btnMissing.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CheckstylePanel.this.btnMissingActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.btnLearnMore, (String)NbBundle.getMessage(CheckstylePanel.class, (String)"CheckstylePanel.btnLearnMore.text"));
        this.btnLearnMore.setBorderPainted(false);
        this.btnLearnMore.setContentAreaFilled(false);
        this.btnLearnMore.setHorizontalTextPosition(2);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.cbEnable).addGroup(layout.createSequentialGroup().addComponent(this.lblMissing).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnMissing)).addGroup(layout.createSequentialGroup().addGap(21, 21, 21).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.btnLearnMore, -2, -1, -2).addComponent(this.lblHint, -1, 541, Short.MAX_VALUE)))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.cbEnable).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.lblHint, -2, 162, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnLearnMore, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 31, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblMissing).addComponent(this.btnMissing)).addContainerGap()));
    }

    private void btnMissingActionPerformed(ActionEvent evt) {
        this.generated = true;
        this.handle.addPOMModification((ModelOperation)new ModelOperation<POMModel>(){

            public void performOperation(POMModel mdl) {
                ReportPlugin plg;
                Reporting rep = mdl.getProject().getReporting();
                if (rep == null) {
                    rep = mdl.getFactory().createReporting();
                    mdl.getProject().setReporting(rep);
                }
                if ((plg = rep.findReportPluginById("org.apache.maven.plugins", "maven-checkstyle-plugin")) == null) {
                    plg = mdl.getFactory().createReportPlugin();
                    plg.setGroupId("org.apache.maven.plugins");
                    plg.setArtifactId("maven-checkstyle-plugin");
                    Configuration conf = mdl.getFactory().createConfiguration();
                    conf.setSimpleParameter("configLocation", "config/sun_checks.xml");
                    plg.setConfiguration(conf);
                    rep.addReportPlugin(plg);
                }
            }
        });
        this.lblMissing.setVisible(false);
        this.btnMissing.setVisible(false);
    }
}

