/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.validation.api.ui;

import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.EventListener;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.validation.api.Problems;
import org.netbeans.validation.api.Validator;
import org.netbeans.validation.api.ui.ValidationListener;
import org.netbeans.validation.api.ui.ValidationStrategy;
import org.netbeans.validation.api.ui.ValidationUI;
import org.netbeans.validation.api.ui.swing.SwingValidationGroup;

class JListValidationListenerImpl
extends ValidationListener<JList>
implements EventListener,
ListSelectionListener,
FocusListener {
    private Validator<ListSelectionModel> validator;
    private boolean hasFatalProblem = false;

    public JListValidationListenerImpl(JList component, ValidationStrategy strategy, ValidationUI validationUI, Validator<ListSelectionModel> validator) {
        super(JList.class, validationUI, component);
        this.validator = validator;
        if (strategy == null) {
            throw new NullPointerException("strategy null");
        }
        ((JList)this.getTarget()).addPropertyChangeListener("enabled", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                JListValidationListenerImpl.this.performValidation();
            }
        });
        switch (strategy) {
            case DEFAULT: 
            case ON_CHANGE_OR_ACTION: {
                component.addListSelectionListener(this);
                break;
            }
            case ON_FOCUS_LOSS: {
                component.addFocusListener(this);
                break;
            }
            case INPUT_VERIFIER: {
                component.setInputVerifier(new InputVerifier(){

                    @Override
                    public boolean verify(JComponent input) {
                        JListValidationListenerImpl.this.performValidation();
                        return !JListValidationListenerImpl.this.hasFatalProblem;
                    }
                });
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        this.performValidation();
    }

    @Override
    protected void performValidation(Problems ps) {
        JList component = (JList)this.getTarget();
        if (!((JList)this.getTarget()).isEnabled()) {
            return;
        }
        this.validator.validate(ps, SwingValidationGroup.nameForComponent(component), component.getSelectionModel());
        this.hasFatalProblem = ps.hasFatal();
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.performValidation();
    }

    @Override
    public void valueChanged(ListSelectionEvent lse) {
        this.performValidation();
    }

    @Override
    public void focusGained(FocusEvent e) {
    }
}

