/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javafx2.samples;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Box;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.java.platform.PlatformsCustomizer;
import org.netbeans.modules.javafx2.platform.api.JavaFXPlatformUtils;
import org.netbeans.modules.javafx2.project.api.JavaFXProjectUtils;
import org.netbeans.modules.javafx2.samples.PanelConfigureProject;
import org.openide.WizardDescriptor;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.util.TaskListener;
import org.openide.util.WeakListeners;

public class PanelOptionsVisual
extends JPanel
implements TaskListener {
    private static final Logger LOGGER = Logger.getLogger("javafx");
    private PanelConfigureProject panel;
    private volatile RequestProcessor.Task task;
    private DetectPlatformTask detectPlatformTask;
    boolean detectPlatformTaskPerformed = false;
    private ComboBoxModel platformsModel;
    private ListCellRenderer platformsCellRenderer;
    private JavaPlatformChangeListener jpcl;
    private JButton btnManagePlatforms;
    private Box.Filler filler1;
    private JLabel lblPlatform;
    private JComboBox platformComboBox;

    public PanelOptionsVisual(PanelConfigureProject panel) {
        this.panel = panel;
        this.detectPlatformTask = new DetectPlatformTask();
        this.preInitComponents();
        this.initComponents();
        this.postInitComponents();
    }

    private void preInitComponents() {
        this.platformsModel = JavaFXProjectUtils.createPlatformComboBoxModel();
        this.platformsCellRenderer = JavaFXProjectUtils.createPlatformListCellRenderer();
    }

    private void postInitComponents() {
        if (!UIManager.getLookAndFeel().getClass().getName().toUpperCase().contains("AQUA")) {
            this.platformComboBox.putClientProperty("JComboBox.isTableCellEditor", Boolean.TRUE);
        }
        this.jpcl = new JavaPlatformChangeListener();
        JavaPlatformManager.getDefault().addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.jpcl, (Object)JavaPlatformManager.getDefault()));
        this.selectJavaFXEnabledPlatform();
    }

    private void initComponents() {
        this.lblPlatform = new JLabel();
        this.platformComboBox = new JComboBox();
        this.btnManagePlatforms = new JButton();
        this.filler1 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(0, Short.MAX_VALUE));
        this.setLayout(new GridBagLayout());
        this.lblPlatform.setLabelFor(this.platformComboBox);
        this.lblPlatform.setText(NbBundle.getMessage(PanelOptionsVisual.class, (String)"LBL_Platform_ComboBox"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 512;
        gridBagConstraints.insets = new Insets(5, 0, 5, 12);
        this.add((Component)this.lblPlatform, gridBagConstraints);
        this.platformComboBox.setModel(this.platformsModel);
        this.platformComboBox.setRenderer(this.platformsCellRenderer);
        this.platformComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                PanelOptionsVisual.this.platformComboBoxItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 512;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(5, 0, 5, 0);
        this.add((Component)this.platformComboBox, gridBagConstraints);
        this.btnManagePlatforms.setText(NbBundle.getMessage(PanelOptionsVisual.class, (String)"LBL_PanelOptions_Manage_Button"));
        this.btnManagePlatforms.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PanelOptionsVisual.this.btnManagePlatformsActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 512;
        gridBagConstraints.insets = new Insets(5, 10, 5, 0);
        this.add((Component)this.btnManagePlatforms, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 3;
        gridBagConstraints.weighty = 0.1;
        this.add((Component)this.filler1, gridBagConstraints);
    }

    private void btnManagePlatformsActionPerformed(ActionEvent evt) {
        PlatformsCustomizer.showCustomizer((JavaPlatform)this.getSelectedPlatform());
    }

    private void platformComboBoxItemStateChanged(ItemEvent evt) {
        this.panel.fireChangeEvent();
    }

    private JavaPlatform getSelectedPlatform() {
        Object selectedItem = this.platformComboBox.getSelectedItem();
        JavaPlatform platform = selectedItem == null ? null : JavaFXProjectUtils.getPlatform((Object)selectedItem);
        return platform;
    }

    private void selectJavaFXEnabledPlatform() {
        for (int i = 0; i < this.platformsModel.getSize(); ++i) {
            JavaPlatform platform = JavaFXProjectUtils.getPlatform(this.platformsModel.getElementAt(i));
            if (!JavaFXPlatformUtils.isJavaFXEnabled((JavaPlatform)platform)) continue;
            this.platformComboBox.setSelectedIndex(i);
            break;
        }
    }

    boolean valid(WizardDescriptor wizardDescriptor) {
        if (!JavaFXPlatformUtils.isJavaFXEnabled((JavaPlatform)this.getSelectedPlatform())) {
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)(this.detectPlatformTaskPerformed ? NbBundle.getMessage(PanelOptionsVisual.class, (String)"WARN_PanelOptionsVisual.notFXPlatform") : NbBundle.getMessage(PanelOptionsVisual.class, (String)"WARN_PanelOptionsVisual.creatingDefaultFXPlatform")));
            return false;
        }
        return true;
    }

    void store(WizardDescriptor d) {
        String platformName = (String)this.getSelectedPlatform().getProperties().get("platform.ant.name");
        d.putProperty("java.platform.name", (Object)platformName);
    }

    void read(WizardDescriptor d) {
        if (this.task == null) {
            this.checkPlatforms();
        }
    }

    private void checkPlatforms() {
        if (!JavaFXPlatformUtils.isThereAnyJavaFXPlatform()) {
            this.task = RequestProcessor.getDefault().create((Runnable)this.detectPlatformTask);
            this.task.addTaskListener((TaskListener)this);
            this.task.schedule(0);
        }
    }

    public synchronized void taskFinished(Task task) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JavaPlatform platform = PanelOptionsVisual.this.detectPlatformTask.getPlatform();
                if (platform != null) {
                    PanelOptionsVisual.this.platformComboBox.setModel(PanelOptionsVisual.this.platformsModel);
                    PanelOptionsVisual.this.selectJavaFXEnabledPlatform();
                    PanelOptionsVisual.this.detectPlatformTaskPerformed = true;
                    PanelOptionsVisual.this.panel.fireChangeEvent();
                }
            }
        });
        this.task.removeTaskListener((TaskListener)this);
        this.task = null;
    }

    private class DetectPlatformTask
    implements Runnable {
        private JavaPlatform platform;

        private DetectPlatformTask() {
        }

        public JavaPlatform getPlatform() {
            return this.platform;
        }

        @Override
        public void run() {
            try {
                this.platform = JavaFXPlatformUtils.createDefaultJavaFXPlatform();
            }
            catch (Exception ex) {
                LOGGER.log(Level.WARNING, "Can't create Java Platform instance: {0}", ex);
            }
        }
    }

    private class JavaPlatformChangeListener
    implements PropertyChangeListener {
        private JavaPlatformChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            PanelOptionsVisual.this.panel.fireChangeEvent();
        }
    }
}

