/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.metadata.model.jdbc;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Logger;
import org.netbeans.modules.db.metadata.model.MetadataUtilities;
import org.netbeans.modules.db.metadata.model.api.MetadataElement;
import org.netbeans.modules.db.metadata.model.api.Nullable;
import org.netbeans.modules.db.metadata.model.api.SQLType;
import org.netbeans.modules.db.metadata.model.jdbc.JDBCUtils;
import org.netbeans.modules.db.metadata.model.spi.ValueImplementation;

public class JDBCValue
extends ValueImplementation {
    private static final Logger LOGGER = Logger.getLogger(JDBCValue.class.getName());
    private final String name;
    private final SQLType type;
    private final int length;
    private final int precision;
    private final short radix;
    private final short scale;
    private final Nullable nullable;

    public static JDBCValue createProcedureValue(ResultSet rs) throws SQLException {
        String name = MetadataUtilities.trimmed(rs.getString("COLUMN_NAME"));
        SQLType type = JDBCUtils.getSQLType(rs.getInt("DATA_TYPE"));
        int length = rs.getInt("LENGTH");
        int precision = rs.getInt("PRECISION");
        short scale = rs.getShort("SCALE");
        short radix = rs.getShort("RADIX");
        Nullable nullable = JDBCUtils.getProcedureNullable(rs.getShort("NULLABLE"));
        return new JDBCValue(name, type, length, precision, radix, scale, nullable);
    }

    public static JDBCValue createTableColumnValue(ResultSet rs) throws SQLException {
        String name = MetadataUtilities.trimmed(rs.getString("COLUMN_NAME"));
        SQLType type = JDBCUtils.getSQLType(rs.getInt("DATA_TYPE"));
        int length = 0;
        int precision = 0;
        if (JDBCUtils.isCharType(type)) {
            length = rs.getInt("COLUMN_SIZE");
        } else {
            precision = rs.getInt("COLUMN_SIZE");
        }
        short scale = rs.getShort("DECIMAL_DIGITS");
        short radix = rs.getShort("NUM_PREC_RADIX");
        Nullable nullable = JDBCUtils.getColumnNullable(rs.getShort("NULLABLE"));
        return new JDBCValue(name, type, length, precision, radix, scale, nullable);
    }

    public static JDBCValue createTableColumnValueODBC(ResultSet rs) throws SQLException {
        String name = MetadataUtilities.trimmed(rs.getString("COLUMN_NAME"));
        SQLType type = JDBCUtils.getSQLType(rs.getInt("DATA_TYPE"));
        int length = 0;
        int precision = 0;
        if (JDBCUtils.isCharType(type)) {
            length = rs.getInt("LENGTH");
        } else {
            precision = rs.getInt("PRECISION");
        }
        short scale = rs.getShort("SCALE");
        short radix = rs.getShort("RADIX");
        Nullable nullable = JDBCUtils.getColumnNullable(rs.getShort("NULLABLE"));
        return new JDBCValue(name, type, length, precision, radix, scale, nullable);
    }

    public JDBCValue(String name, SQLType type, int length, int precision, short radix, short scale, Nullable nullable) {
        this.name = name;
        this.type = type;
        this.length = length;
        this.precision = precision;
        this.radix = radix;
        this.scale = scale;
        this.nullable = nullable;
    }

    @Override
    public int getLength() {
        return this.length;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Nullable getNullable() {
        return this.nullable;
    }

    @Override
    public int getPrecision() {
        return this.precision;
    }

    @Override
    public short getRadix() {
        return this.radix;
    }

    @Override
    public short getScale() {
        return this.scale;
    }

    @Override
    public SQLType getType() {
        return this.type;
    }

    public String toString() {
        return "name=" + this.name + ", type=" + (Object)((Object)this.type) + ", length=" + this.getLength() + ", precision=" + this.getPrecision() + ", radix=" + this.getRadix() + ", scale=" + this.getScale() + ", nullable=" + (Object)((Object)this.nullable);
    }

    @Override
    public MetadataElement getParent() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

