/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.deployment.autodeploy;

import com.sun.enterprise.config.serverbeans.DasConfig;
import com.sun.logging.LogDomains;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.deployment.autodeploy.AutoDeployer;
import org.glassfish.deployment.autodeploy.AutoDeploymentException;
import org.glassfish.deployment.common.DeploymentUtils;
import org.glassfish.internal.api.PostStartup;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PostConstruct;
import org.jvnet.hk2.component.PreDestroy;
import org.jvnet.hk2.component.Singleton;
import org.jvnet.hk2.config.ConfigListener;
import org.jvnet.hk2.config.UnprocessedChangeEvents;

@Service
@Scoped(value=Singleton.class)
public class AutoDeployService
implements PostStartup,
PostConstruct,
PreDestroy,
ConfigListener {
    @Inject
    DasConfig activeDasConfig;
    @Inject
    Habitat habitat;
    @Inject
    ServerEnvironment env;
    private AutoDeployer autoDeployer = null;
    private Timer autoDeployerTimer;
    private TimerTask autoDeployerTimerTask;
    private String target;
    private static final String DAS_TARGET = "server";
    private static final List<String> configPropertyNames = Arrays.asList("autodeploy-enabled", "autodeploy-polling-interval-in-seconds", "autodeploy-verifier-enabled", "autodeploy-jsp-precompilation-enabled");
    private Logger logger;
    private static final String DEFAULT_POLLING_INTERVAL_IN_SECONDS = "2";
    private static final String DEFAULT_AUTO_DEPLOY_ENABLED = "true";
    private static final Pattern TOKEN_SUBSTITUTION = Pattern.compile("\\$\\{([^\\}]*)\\}");
    private static final String SLASH_REPLACEMENT = Matcher.quoteReplacement("\\\\");
    private static final String DOLLAR_REPLACEMENT = Matcher.quoteReplacement("\\$");

    public void postConstruct() {
        this.logger = LogDomains.getLogger(DeploymentUtils.class, (String)"javax.enterprise.system.tools.deployment");
        if (!this.env.isDas()) {
            return;
        }
        String directory = this.activeDasConfig.getAutodeployDir();
        this.target = this.getTarget();
        try {
            this.autoDeployer = new AutoDeployer(this.target, directory, this.getDefaultVirtualServer(), Boolean.parseBoolean(this.activeDasConfig.getAutodeployJspPrecompilationEnabled()), Boolean.parseBoolean(this.activeDasConfig.getAutodeployVerifierEnabled()), true, true, true, this.habitat);
            boolean isEnabled = this.isAutoDeployEnabled();
            int pollingIntervalInSeconds = Integer.valueOf(DEFAULT_POLLING_INTERVAL_IN_SECONDS);
            try {
                pollingIntervalInSeconds = this.getPollingIntervalInSeconds();
            }
            catch (NumberFormatException ex) {
                this.logger.log(Level.WARNING, "enterprise.deployment.autodeploy.error_parsing_polling_interval", new Object[]{this.activeDasConfig.getAutodeployPollingIntervalInSeconds(), ex.getClass().getName(), ex.getLocalizedMessage()});
            }
            if (isEnabled) {
                this.startAutoDeployer(pollingIntervalInSeconds);
            }
        }
        catch (AutoDeploymentException e) {
            this.logger.log(Level.SEVERE, e.getLocalizedMessage(), (Throwable)((Object)e));
        }
    }

    public void preDestroy() {
        this.stopAutoDeployer();
    }

    static String getValue(String value, String defaultValue) {
        return value == null || value.equals("") ? defaultValue : value;
    }

    private void logConfig(String title, boolean isEnabled, int pollingIntervalInSeconds, String directory) {
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine("[AutoDeploy] " + title + ", enabled=" + isEnabled + ", polling interval(seconds)=" + pollingIntervalInSeconds + ", directory=" + directory);
        }
    }

    private String getTarget() {
        return DAS_TARGET;
    }

    private String getDefaultVirtualServer() {
        return null;
    }

    private boolean isAutoDeployEnabled() {
        return Boolean.parseBoolean(AutoDeployService.getValue(this.activeDasConfig.getAutodeployEnabled(), DEFAULT_AUTO_DEPLOY_ENABLED));
    }

    private int getPollingIntervalInSeconds() throws NumberFormatException {
        return Integer.parseInt(AutoDeployService.getValue(this.activeDasConfig.getAutodeployPollingIntervalInSeconds(), DEFAULT_POLLING_INTERVAL_IN_SECONDS));
    }

    private void startAutoDeployer(int pollingIntervalInSeconds) {
        long pollingInterval = (long)pollingIntervalInSeconds * 1000L;
        this.autoDeployer.init();
        this.autoDeployerTimer = new Timer("AutoDeployer", true);
        this.autoDeployerTimerTask = new TimerTask(){

            public void run() {
                try {
                    AutoDeployService.this.autoDeployer.run();
                }
                catch (Exception ex) {
                    AutoDeployer.sLogger.log(Level.FINE, ex.getMessage(), ex);
                }
            }
        };
        this.autoDeployerTimer.schedule(this.autoDeployerTimerTask, pollingInterval, pollingInterval);
        this.logConfig("Started", this.isAutoDeployEnabled(), pollingIntervalInSeconds, this.activeDasConfig.getAutodeployDir());
    }

    private void stopAutoDeployer() {
        this.logger.fine("[AutoDeploy] Stopping");
        if (this.autoDeployer != null) {
            this.autoDeployer.cancel(true);
        }
        if (this.autoDeployerTimerTask != null) {
            this.autoDeployerTimerTask.cancel();
        }
        if (this.autoDeployerTimer != null) {
            this.autoDeployerTimer.cancel();
        }
    }

    private void rescheduleAutoDeployer(int pollingIntervalInSeconds) {
        this.logger.fine("[AutoDeploy] Restarting...");
        this.stopAutoDeployer();
        try {
            this.autoDeployer.waitUntilIdle();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.startAutoDeployer(pollingIntervalInSeconds);
    }

    public UnprocessedChangeEvents changed(PropertyChangeEvent[] events) {
        if (this.autoDeployer == null) {
            return null;
        }
        ArrayList unprocessedEvents = new ArrayList();
        Boolean newEnabled = null;
        Integer newPollingIntervalInSeconds = null;
        for (PropertyChangeEvent event : events) {
            if (!(event.getSource() instanceof DasConfig)) continue;
            String propName = event.getPropertyName();
            if (configPropertyNames.contains(propName) && event.getOldValue().equals(event.getNewValue())) {
                this.logger.fine("[AutoDeploy] Ignoring reconfig of " + propName + " from " + event.getOldValue() + " to " + event.getNewValue());
                continue;
            }
            String oldValue = AutoDeployService.replaceTokens((String)event.getOldValue(), System.getProperties());
            String newValue = AutoDeployService.replaceTokens((String)event.getNewValue(), System.getProperties());
            if (propName.equals("autodeploy-enabled")) {
                newEnabled = Boolean.valueOf(newValue);
                this.logger.fine("[AutoDeploy] Reconfig - enabled changed to " + newEnabled);
                continue;
            }
            if (propName.equals("autodeploy-polling-interval-in-seconds")) {
                try {
                    newPollingIntervalInSeconds = new Integer(newValue);
                    this.logger.fine("[AutoDeploy] Reconfig - polling interval (seconds) changed from " + oldValue + " to " + newPollingIntervalInSeconds);
                }
                catch (NumberFormatException ex) {
                    this.logger.log(Level.WARNING, "enterprise.deployment.autodeploy.error_processing_config_change", new Object[]{propName, oldValue, newValue, ex.getClass().getName(), ex.getLocalizedMessage()});
                }
                continue;
            }
            if (propName.equals("autodeploy-dir")) {
                String newDir = newValue;
                try {
                    this.autoDeployer.setDirectory(newDir);
                    this.logger.fine("[AutoDeploy] Reconfig - directory changed from " + oldValue + " to " + newDir);
                }
                catch (AutoDeploymentException ex) {
                    this.logger.log(Level.WARNING, "enterprise.deployment.autodeploy.error_processing_config_change", new Object[]{propName, oldValue, newValue, ((Object)((Object)ex)).getClass().getName(), ex.getCause().getLocalizedMessage()});
                }
                continue;
            }
            if (propName.equals("autodeploy-verifier-enabled")) {
                boolean newVerifierEnabled = Boolean.parseBoolean(newValue);
                this.autoDeployer.setVerifierEnabled(newVerifierEnabled);
                this.logger.fine("[AutoDeploy] Reconfig - verifierEnabled changed from " + Boolean.parseBoolean(oldValue) + " to " + newVerifierEnabled);
                continue;
            }
            if (!propName.equals("autodeploy-jsp-precompilation-enabled")) continue;
            boolean newJspPrecompiled = Boolean.parseBoolean(newValue);
            this.autoDeployer.setJspPrecompilationEnabled(newJspPrecompiled);
            this.logger.fine("[AutoDeploy] Reconfig - jspPrecompilationEnabled changed from " + Boolean.parseBoolean(oldValue) + " to " + newJspPrecompiled);
        }
        if (newEnabled != null) {
            if (newEnabled.booleanValue()) {
                this.startAutoDeployer(newPollingIntervalInSeconds == null ? this.getPollingIntervalInSeconds() : newPollingIntervalInSeconds.intValue());
            } else {
                this.stopAutoDeployer();
            }
        } else if (newPollingIntervalInSeconds != null && this.isAutoDeployEnabled()) {
            this.rescheduleAutoDeployer(newPollingIntervalInSeconds);
        }
        return unprocessedEvents.size() > 0 ? new UnprocessedChangeEvents(unprocessedEvents) : null;
    }

    private static String replaceTokens(String s, Properties values) {
        Matcher m = TOKEN_SUBSTITUTION.matcher(s);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            String propertyName = m.group(1);
            String propertyValue = values.getProperty(propertyName);
            if (propertyValue == null) continue;
            String adjustedPropertyValue = propertyValue.replaceAll("\\\\", SLASH_REPLACEMENT).replaceAll("\\$", DOLLAR_REPLACEMENT);
            String x = s.substring(m.start(), m.end());
            try {
                m.appendReplacement(sb, adjustedPropertyValue);
            }
            catch (IllegalArgumentException iae) {
                System.err.println("**** appendReplacement failed: segment is " + x + "; original replacement was " + propertyValue + " and adj. replacement is " + adjustedPropertyValue + "; exc follows");
                throw iae;
            }
        }
        m.appendTail(sb);
        return sb.toString();
    }
}

