/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.ha.store.adapter.file;

import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import org.glassfish.ha.store.adapter.file.FileBackingStore;
import org.glassfish.ha.store.adapter.file.FileStoreTransaction;
import org.glassfish.ha.store.api.BackingStore;
import org.glassfish.ha.store.api.BackingStoreConfiguration;
import org.glassfish.ha.store.api.BackingStoreException;
import org.glassfish.ha.store.api.BackingStoreFactory;
import org.glassfish.ha.store.api.BackingStoreTransaction;
import org.jvnet.hk2.annotations.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(name="file")
public class FileBackingStoreFactory
implements BackingStoreFactory {
    private static ThreadLocal<FileStoreTransaction> _current = new ThreadLocal();
    private String instanceName;
    private String groupName;
    private static ConcurrentHashMap<String, FileBackingStore> _stores = new ConcurrentHashMap();

    static FileBackingStore getFileBackingStore(String storeName) {
        return _stores.get(storeName);
    }

    static void removemapping(String storeName) {
        _stores.remove(storeName);
    }

    @Override
    public <K extends Serializable, V extends Serializable> BackingStore<K, V> createBackingStore(BackingStoreConfiguration<K, V> conf) throws BackingStoreException {
        FileBackingStore<K, V> fs = new FileBackingStore<K, V>();
        fs.initialize(conf);
        fs.setFileBackingStoreFactory(this);
        _stores.put(conf.getStoreName(), fs);
        return fs;
    }

    @Override
    public BackingStoreTransaction createBackingStoreTransaction() {
        FileStoreTransaction tx = new FileStoreTransaction();
        _current.set(tx);
        return tx;
    }

    static final FileStoreTransaction getCurrent() {
        return _current.get();
    }
}

