/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.ant;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.netbeans.api.java.queries.BinaryForSourceQuery;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.modules.java.source.ant.UserCancel;
import org.netbeans.modules.java.source.usages.BuildArtifactMapperImpl;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.Utilities;

public class TranslateClassPath
extends Task {
    private String classpath;
    private String targetProperty;
    private boolean clean;

    public void setClasspath(String cp) {
        this.classpath = cp;
    }

    public void setTargetProperty(String tp) {
        this.targetProperty = tp;
    }

    public void setClean(boolean clean) {
        this.clean = clean;
    }

    public void execute() throws BuildException {
        if (this.classpath == null) {
            throw new BuildException("Classpath must be set.");
        }
        if (this.targetProperty == null) {
            throw new BuildException("Target property must be set.");
        }
        Project p = this.getProject();
        String translated = this.translate(this.classpath);
        p.setProperty(this.targetProperty, translated);
    }

    private String translate(String classpath) {
        StringBuilder cp = new StringBuilder();
        boolean first = true;
        Object o = this.getProject().getProperties().get("maven.disableSources");
        Boolean disableSources = o instanceof Boolean ? (Boolean)o : Boolean.FALSE;
        for (String path : PropertyUtils.tokenizePath((String)classpath)) {
            File[] files = this.translateEntry(path, disableSources);
            if (files.length == 0) continue;
            for (File f : files) {
                if (!first) {
                    cp.append(File.pathSeparatorChar);
                }
                cp.append(f.getAbsolutePath());
                first = false;
            }
        }
        return cp.toString();
    }

    private File[] translateEntry(String path, Boolean disableSources) throws BuildException {
        File entryFile = new File(path);
        try {
            URL entry = FileUtil.urlForArchiveOrDir((File)entryFile);
            SourceForBinaryQuery.Result2 r = SourceForBinaryQuery.findSourceRoots2((URL)entry);
            boolean appendEntry = false;
            if (!disableSources.booleanValue() && r.preferSources() && r.getRoots().length > 0) {
                ArrayList<File> translated = new ArrayList<File>();
                for (FileObject source : r.getRoots()) {
                    Boolean bamiResult;
                    File sourceFile = FileUtil.toFile((FileObject)source);
                    if (sourceFile == null) {
                        this.log("Source URL: " + source.toURL().toExternalForm() + " cannot be translated to file, skipped", 1);
                        appendEntry = true;
                        continue;
                    }
                    Boolean bl = bamiResult = this.clean ? BuildArtifactMapperImpl.clean((URL)Utilities.toURI((File)sourceFile).toURL()) : BuildArtifactMapperImpl.ensureBuilt((URL)Utilities.toURI((File)sourceFile).toURL(), (Object)this.getProject(), (boolean)true, (boolean)true);
                    if (bamiResult == null) {
                        appendEntry = true;
                        continue;
                    }
                    if (!bamiResult.booleanValue()) {
                        throw new UserCancel();
                    }
                    for (URL binary : BinaryForSourceQuery.findBinaryRoots((URL)source.toURL()).getRoots()) {
                        File finaryFile;
                        FileObject binaryFO = URLMapper.findFileObject((URL)binary);
                        File file = finaryFile = binaryFO != null ? FileUtil.toFile((FileObject)binaryFO) : null;
                        if (finaryFile == null) continue;
                        translated.add(finaryFile);
                    }
                }
                if (appendEntry) {
                    translated.add(entryFile);
                }
                return translated.toArray(new File[translated.size()]);
            }
            return new File[]{entryFile};
        }
        catch (IOException ex) {
            throw new BuildException((Throwable)ex);
        }
    }
}

