/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.utils;

import java.awt.EventQueue;
import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.swing.JEditorPane;
import org.netbeans.api.queries.SharabilityQuery;
import org.netbeans.libs.git.GitBranch;
import org.netbeans.libs.git.GitRevisionInfo;
import org.netbeans.libs.git.progress.ProgressMonitor;
import org.netbeans.modules.git.FileInformation;
import org.netbeans.modules.git.FileStatusCache;
import org.netbeans.modules.git.Git;
import org.netbeans.modules.git.GitModuleConfig;
import org.netbeans.modules.git.VersionsCache;
import org.netbeans.modules.git.ui.blame.AnnotateAction;
import org.netbeans.modules.git.ui.commit.CommitAction;
import org.netbeans.modules.git.ui.ignore.IgnoreAction;
import org.netbeans.modules.git.ui.status.GitStatusNode;
import org.netbeans.modules.git.ui.status.StatusAction;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.netbeans.modules.versioning.util.FileSelector;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.Line;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.Lookups;
import org.openide.windows.TopComponent;

public final class GitUtils {
    public static final String DOT_GIT = ".git";
    private static final Pattern METADATA_PATTERN = Pattern.compile(".*\\" + File.separatorChar + "(\\.)git(\\" + File.separatorChar + ".*|$)");
    private static final String FILENAME_GITIGNORE = ".gitignore";
    public static final String HEAD = "HEAD";
    public static final String INDEX = "INDEX";
    public static final String CURRENT = "CURRENT";
    public static final String PREFIX_R_HEADS = "refs/heads/";
    public static final String PREFIX_R_REMOTES = "refs/remotes/";
    public static final ProgressMonitor NULL_PROGRESS_MONITOR = new NullProgressMonitor();
    private static final Map<File, Set<String>> notSharable = Collections.synchronizedMap(new HashMap(5));
    private static final String REF_SPEC_PATTERN = "+refs/heads/{0}:refs/remotes/{1}/{0}";
    private static final String REF_PUSHSPEC_PATTERN = "+refs/heads/{0}:refs/heads/{1}";
    private static final String REF_TAG_PUSHSPEC_PATTERN = "+refs/tags/{0}:refs/tags/{0}";

    public static boolean isPartOfGitMetadata(File file) {
        return METADATA_PATTERN.matcher(file.getAbsolutePath()).matches();
    }

    public static boolean isAdministrative(File file) {
        String name = file.getName();
        return GitUtils.isAdministrative(name) && file.isDirectory();
    }

    public static boolean isAdministrative(String fileName) {
        return fileName.equals(DOT_GIT);
    }

    public static boolean repositoryExistsFor(File file) {
        return new File(file, DOT_GIT).exists();
    }

    public static File getGitFolderForRoot(File repositoryRoot) {
        return FileUtil.normalizeFile((File)new File(repositoryRoot, DOT_GIT));
    }

    public static boolean prepareRootFiles(File repository, Collection<File> filesUnderRoot, File file) {
        boolean added = false;
        HashSet<File> filesToRemove = new HashSet<File>();
        for (File fileUnderRoot : filesUnderRoot) {
            if (file.equals(fileUnderRoot) || fileUnderRoot.equals(repository)) {
                added = true;
                break;
            }
            if (file.equals(repository)) {
                filesUnderRoot.clear();
                break;
            }
            if (file.getAbsolutePath().length() < fileUnderRoot.getAbsolutePath().length()) {
                if (!Utils.isAncestorOrEqual((File)file, (File)fileUnderRoot)) continue;
                filesToRemove.add(fileUnderRoot);
                continue;
            }
            if (!Utils.isAncestorOrEqual((File)fileUnderRoot, (File)file)) continue;
            added = true;
            break;
        }
        filesUnderRoot.removeAll(filesToRemove);
        if (!added) {
            filesUnderRoot.add(file);
        }
        return added;
    }

    public static boolean isIgnored(File file, boolean checkSharability) {
        int sharability;
        if (file == null) {
            return false;
        }
        String path = file.getPath();
        File topFile = Git.getInstance().getRepositoryRoot(file);
        if (topFile == null || topFile.equals(file)) {
            return false;
        }
        if (GitUtils.isNotSharable(path, topFile)) {
            return true;
        }
        File parentFile = file.getParentFile();
        if (!parentFile.equals(topFile) && GitUtils.isIgnored(parentFile, false)) {
            return true;
        }
        if (FILENAME_GITIGNORE.equals(file.getName())) {
            return false;
        }
        if (checkSharability && (sharability = SharabilityQuery.getSharability((File)FileUtil.normalizeFile((File)file))) == 2) {
            if (GitModuleConfig.getDefault().getAutoIgnoreFiles()) {
                GitUtils.ignoreNotSharableAncestor(topFile, file);
            } else {
                GitUtils.addNotSharable(topFile, path);
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addNotSharable(File topFile, String ignoredPath) {
        Map<File, Set<String>> map = notSharable;
        synchronized (map) {
            Set<String> ignores = notSharable.get(topFile);
            if (ignores == null) {
                ignores = new HashSet<String>();
            }
            String patternCandidate = ignoredPath;
            Iterator<String> it = ignores.iterator();
            while (it.hasNext()) {
                String storedPattern = it.next();
                if (storedPattern.equals(ignoredPath) || ignoredPath.startsWith(storedPattern + '/')) {
                    patternCandidate = null;
                    break;
                }
                if (!storedPattern.startsWith(ignoredPath + '/')) continue;
                it.remove();
            }
            if (patternCandidate != null) {
                ignores.add(patternCandidate);
            }
            notSharable.put(topFile, ignores);
        }
    }

    private static boolean isNotSharable(String path, File topFile) {
        boolean retval = false;
        Set<String> notSharablePaths = notSharable.get(topFile);
        if (notSharablePaths == null) {
            notSharablePaths = Collections.emptySet();
        }
        retval = notSharablePaths.contains(path);
        return retval;
    }

    private static void ignoreNotSharableAncestor(File topFile, File notSharableFile) {
        File parent;
        if (topFile.equals(notSharableFile)) {
            throw new IllegalStateException("Trying to ignore " + notSharableFile + " in " + topFile);
        }
        while (!topFile.equals(parent = notSharableFile.getParentFile()) && SharabilityQuery.getSharability((File)FileUtil.normalizeFile((File)parent)) == 2) {
            notSharableFile = parent;
        }
        GitUtils.addNotSharable(topFile, notSharableFile.getAbsolutePath());
        if (notSharableFile.isDirectory()) {
            for (File f : Git.getInstance().getCreatedFolders()) {
                if (!Utils.isAncestorOrEqual((File)f, (File)notSharableFile)) continue;
                ((IgnoreAction)SystemAction.get(IgnoreAction.class)).ignoreFolders(topFile, new File[]{notSharableFile});
            }
        }
    }

    public static boolean isFromGitRepository(VCSContext context) {
        return GitUtils.getRootFile(context) != null;
    }

    public static File getRootFile(VCSContext context) {
        if (context == null) {
            return null;
        }
        Git git = Git.getInstance();
        File[] files = context.getRootFiles().toArray(new File[context.getRootFiles().size()]);
        if (files == null || files.length == 0) {
            return null;
        }
        File root = git.getRepositoryRoot(files[0]);
        return root;
    }

    public static Set<File> getRepositoryRoots(VCSContext context) {
        Set rootsSet = context.getRootFiles();
        return GitUtils.getRepositoryRoots(rootsSet);
    }

    public static Set<File> getRepositoryRoots(Set<File> roots) {
        HashSet<File> ret = new HashSet<File>();
        for (File file : roots) {
            File repoRoot;
            if (!Git.getInstance().isManaged(file) || (repoRoot = Git.getInstance().getRepositoryRoot(file)) == null) continue;
            ret.add(repoRoot);
        }
        return ret;
    }

    public static AbstractMap.SimpleImmutableEntry<File, File[]> getActionRoots(VCSContext ctx) {
        List l;
        Set rootsSet = ctx.getRootFiles();
        HashMap<File, LinkedList<File>> map = new HashMap<File, LinkedList<File>>();
        for (File file : rootsSet) {
            File repoRoot;
            if (!Git.getInstance().isManaged(file) || (repoRoot = Git.getInstance().getRepositoryRoot(file)) == null) continue;
            l = (LinkedList<File>)map.get(repoRoot);
            if (l == null) {
                l = new LinkedList<File>();
                map.put(repoRoot, (LinkedList<File>)l);
            }
            l.add(file);
        }
        Set repoRoots = map.keySet();
        if (map.size() > 1) {
            FileSelector fs = new FileSelector(NbBundle.getMessage(GitUtils.class, (String)"LBL_FileSelector_Title"), NbBundle.getMessage(GitUtils.class, (String)"FileSelector.jLabel1.text"), new HelpCtx("org.netbeans.modules.git.FileSelector"), GitModuleConfig.getDefault().getPreferences());
            if (fs.show(repoRoots.toArray(new File[repoRoots.size()]))) {
                File selection = fs.getSelectedFile();
                l = (List)map.get(selection);
                return new AbstractMap.SimpleImmutableEntry<File, File[]>(selection, l.toArray(new File[l.size()]));
            }
            return null;
        }
        if (map.isEmpty()) {
            return null;
        }
        File root = (File)map.keySet().iterator().next();
        List l2 = (List)map.get(root);
        return new AbstractMap.SimpleImmutableEntry<File, File[]>(root, l2.toArray(new File[l2.size()]));
    }

    public static File[] filterForRepository(VCSContext ctx, File repository) {
        File[] files = null;
        if (ctx != null) {
            Set s = ctx.getRootFiles();
            files = s.toArray(new File[s.size()]);
        }
        if (files != null) {
            LinkedList<File> l = new LinkedList<File>();
            for (File file : files) {
                File r = Git.getInstance().getRepositoryRoot(file);
                if (r == null || !r.equals(repository)) continue;
                l.add(file);
            }
            files = l.toArray(new File[l.size()]);
        }
        return files;
    }

    public static File[] flatten(File[] files, Set<FileInformation.Status> statuses) {
        LinkedList<File> ret = new LinkedList<File>();
        FileStatusCache cache = Git.getInstance().getFileStatusCache();
        for (int i = 0; i < files.length; ++i) {
            File dir = files[i];
            FileInformation info = cache.getStatus(dir);
            if (info.containsStatus(statuses)) {
                ret.add(dir);
            }
            File[] entries = cache.listFiles(dir);
            for (int e = 0; e < entries.length; ++e) {
                File entry = entries[e];
                info = cache.getStatus(entry);
                if (!info.containsStatus(statuses)) continue;
                ret.add(entry);
            }
        }
        return ret.toArray(new File[ret.size()]);
    }

    public static File[] listFiles(File[] roots, EnumSet<FileInformation.Status> includedStatuses) {
        File[][] split = Utils.splitFlatOthers((File[])roots);
        ArrayList<File> fileList = new ArrayList<File>();
        FileStatusCache cache = Git.getInstance().getFileStatusCache();
        for (int c = 0; c < split.length; ++c) {
            File[] splitRoots = split[c];
            if (c == 1) {
                fileList.addAll(Arrays.asList(cache.listFiles(splitRoots, includedStatuses)));
                continue;
            }
            fileList.addAll(Arrays.asList(GitUtils.flatten(splitRoots, includedStatuses)));
        }
        return fileList.toArray(new File[fileList.size()]);
    }

    public static VCSContext getCurrentContext(Node[] nodes) {
        if (nodes == null) {
            nodes = TopComponent.getRegistry().getActivatedNodes();
        }
        return VCSContext.forNodes((Node[])nodes);
    }

    public static String getMimeType(File file) {
        String foMime;
        FileObject fo = FileUtil.toFileObject((File)file);
        boolean hasMime = false;
        if (fo == null) {
            foMime = "content/unknown";
        } else {
            foMime = fo.getMIMEType();
            if ("content/unknown".equals(foMime)) {
                foMime = "text/plain";
            } else {
                hasMime = true;
            }
        }
        if (!hasMime) {
            return GitUtils.isFileContentBinary(file) ? "application/octet-stream" : foMime;
        }
        return foMime;
    }

    public static boolean isFileContentBinary(File file) {
        FileObject fo = FileUtil.toFileObject((File)file);
        if (fo == null) {
            return false;
        }
        try {
            DataObject dao = DataObject.find((FileObject)fo);
            return dao.getCookie(EditorCookie.class) == null;
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            return false;
        }
    }

    public static boolean isFromInternalView(VCSContext context) {
        return context.getElements().lookup(GitStatusNode.class) != null;
    }

    public static List<String> getRelativePaths(File workDir, File[] roots) {
        ArrayList<String> paths = new ArrayList<String>(roots.length);
        for (File root : roots) {
            if (workDir.equals(root)) {
                paths.clear();
                break;
            }
            paths.add(GitUtils.getRelativePath(workDir, root));
        }
        return paths;
    }

    public static String getRelativePath(File repo, File file) {
        StringBuilder relativePath = new StringBuilder("");
        File parent = file;
        if (!parent.equals(repo)) {
            while (parent != null && !parent.equals(repo)) {
                relativePath.insert(0, "/").insert(0, parent.getName());
                parent = parent.getParentFile();
            }
            if (parent == null) {
                throw new IllegalArgumentException(file.getAbsolutePath() + " is not under " + repo.getAbsolutePath());
            }
            relativePath.deleteCharAt(relativePath.length() - 1);
        }
        return relativePath.toString();
    }

    public static void openInVersioningView(Collection<File> files, File repository, ProgressMonitor pm) {
        LinkedList<AbstractNode> nodes = new LinkedList<AbstractNode>();
        for (File file : files) {
            AbstractNode node = new AbstractNode(Children.LEAF, Lookups.fixed((Object[])new Object[]{file}));
            nodes.add(node);
        }
        Git.getInstance().getFileStatusCache().refreshAllRoots(Collections.singletonMap(repository, files), pm);
        if (!pm.isCanceled()) {
            final VCSContext context = VCSContext.forNodes((Node[])nodes.toArray(new Node[nodes.size()]));
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ((StatusAction)SystemAction.get(StatusAction.class)).performContextAction(context);
                }
            });
        }
    }

    public static void printInfo(StringBuilder sb, GitRevisionInfo info) {
        String lbrevision = NbBundle.getMessage(CommitAction.class, (String)"MSG_CommitAction.logCommit.revision");
        String lbauthor = NbBundle.getMessage(CommitAction.class, (String)"MSG_CommitAction.logCommit.author");
        String lbcommitter = NbBundle.getMessage(CommitAction.class, (String)"MSG_CommitAction.logCommit.committer");
        String lbdate = NbBundle.getMessage(CommitAction.class, (String)"MSG_CommitAction.logCommit.date");
        String lbsummary = NbBundle.getMessage(CommitAction.class, (String)"MSG_CommitAction.logCommit.summary");
        String author = info.getAuthor().toString();
        String committer = info.getCommitter().toString();
        sb.append(NbBundle.getMessage(CommitAction.class, (String)"MSG_CommitAction.logCommit.title")).append("\n");
        sb.append(lbrevision);
        sb.append(info.getRevision());
        sb.append('\n');
        sb.append(lbauthor);
        sb.append(author);
        sb.append('\n');
        if (!author.equals(committer)) {
            sb.append(lbcommitter);
            sb.append(committer);
            sb.append('\n');
        }
        sb.append(lbdate);
        sb.append(DateFormat.getDateTimeInstance().format(new Date(info.getCommitTime())));
        sb.append('\n');
        sb.append(lbsummary);
        int prefixLen = lbsummary.length();
        sb.append(GitUtils.formatMultiLine(prefixLen, info.getFullMessage()));
        sb.append('\n');
    }

    private static String formatMultiLine(int prefixLen, String message) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < prefixLen; ++i) {
            sb.append(" ");
        }
        String prefix = sb.toString();
        String[] lines = message.split("\n");
        sb = new StringBuilder(lines.length > 0 ? lines[0] : "");
        for (int i = 1; i < lines.length; ++i) {
            sb.append("\n").append(prefix).append(lines[i]);
        }
        return sb.toString();
    }

    public static void headChanged(File repository) {
        Set openFiles = Utils.getOpenFiles();
        Iterator it = openFiles.iterator();
        while (it.hasNext()) {
            File file = (File)it.next();
            if (repository.equals(Git.getInstance().getRepositoryRoot(file))) continue;
            it.remove();
        }
        if (!openFiles.isEmpty()) {
            Git.getInstance().headChanged(openFiles);
        }
    }

    public static boolean isRepositoryLocked(File repository) {
        return new File(GitUtils.getGitFolderForRoot(repository), "index.lock").exists();
    }

    public static void openInRevision(final File originalFile, final int lineNumber, final String revision, boolean showAnnotations, ProgressMonitor pm) throws IOException {
        File file = VersionsCache.getInstance().getFileRevision(originalFile, revision, pm);
        if (pm.isCanceled()) {
            return;
        }
        if (file == null) {
            file = File.createTempFile("tmp", "-" + originalFile.getName(), Utils.getTempFolder());
            file.deleteOnExit();
        }
        FileObject fo = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)file));
        EditorCookie ec = null;
        OpenCookie oc = null;
        try {
            DataObject dobj = DataObject.find((FileObject)fo);
            ec = (EditorCookie)dobj.getCookie(EditorCookie.class);
            oc = (OpenCookie)dobj.getCookie(OpenCookie.class);
        }
        catch (DataObjectNotFoundException ex) {
            Logger.getLogger(GitUtils.class.getName()).log(Level.FINE, null, ex);
        }
        if (ec == null && oc != null) {
            oc.open();
        } else {
            CloneableEditorSupport ces = Utils.openFile((FileObject)fo, (String)revision.substring(0, 7));
            if (showAnnotations && ces != null && !pm.isCanceled()) {
                final CloneableEditorSupport support = ces;
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JEditorPane[] panes = support.getOpenedPanes();
                        if (panes != null) {
                            if (lineNumber >= 0 && lineNumber < support.getLineSet().getLines().size()) {
                                support.getLineSet().getCurrent(lineNumber).show(Line.ShowOpenType.NONE, Line.ShowVisibilityType.FRONT);
                            }
                            ((AnnotateAction)SystemAction.get(AnnotateAction.class)).showAnnotations(panes[0], originalFile, revision);
                        }
                    }
                });
            }
        }
    }

    public static Map<File, Set<File>> sortByRepository(Collection<File> files) {
        HashMap<File, Set<File>> sorted = new HashMap<File, Set<File>>(5);
        for (File f : files) {
            File repository = Git.getInstance().getRepositoryRoot(f);
            if (repository == null) continue;
            HashSet<File> repoFiles = (HashSet<File>)sorted.get(repository);
            if (repoFiles == null) {
                repoFiles = new HashSet<File>();
                sorted.put(repository, repoFiles);
            }
            repoFiles.add(f);
        }
        return sorted;
    }

    public static String getRefSpec(GitBranch branch, String remoteName) {
        return MessageFormat.format(REF_SPEC_PATTERN, branch.getName(), remoteName);
    }

    public static String getRefSpec(String branchName, String remoteName) {
        return MessageFormat.format(REF_SPEC_PATTERN, branchName, remoteName);
    }

    public static String getPushRefSpec(String branchName, String remoteRepositoryBranchName) {
        return MessageFormat.format(REF_PUSHSPEC_PATTERN, branchName, remoteRepositoryBranchName);
    }

    public static String getPushTagRefSpec(String tagName) {
        return MessageFormat.format(REF_TAG_PUSHSPEC_PATTERN, tagName);
    }

    private GitUtils() {
    }

    private static class NullProgressMonitor
    extends ProgressMonitor {
        private NullProgressMonitor() {
        }

        public boolean isCanceled() {
            return false;
        }

        public void started(String command) {
        }

        public void finished() {
        }

        public void preparationsFailed(String message) {
        }

        public void notifyError(String message) {
        }

        public void notifyWarning(String message) {
        }
    }
}

