/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.ui.selectors;

import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.modules.git.ui.selectors.ItemsPanel;
import org.openide.awt.Mnemonics;
import org.openide.util.ChangeSupport;

public class ItemSelector<I extends Item>
implements ListSelectionListener {
    private ItemsPanel panel;
    private ChangeSupport changeSupport = new ChangeSupport((Object)this);

    public ItemSelector(String title) {
        this.panel = new ItemsPanel();
        Mnemonics.setLocalizedText((JLabel)this.panel.titleLabel, (String)title);
        this.panel.list.setCellRenderer(new ItemRenderer());
        this.attachListeners();
    }

    public JPanel getPanel() {
        return this.panel;
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeSupport.removeChangeListener(listener);
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeSupport.addChangeListener(listener);
    }

    public void setBranches(List<I> branches) {
        Collections.sort(branches);
        DefaultListModel<Item> model = new DefaultListModel<Item>();
        for (Item i : branches) {
            model.addElement(i);
        }
        this.panel.list.setModel(model);
    }

    public List<I> getSelectedBranches() {
        ArrayList<Item> ret = new ArrayList<Item>(this.panel.list.getModel().getSize());
        for (int i = 0; i < this.panel.list.getModel().getSize(); ++i) {
            Item item = (Item)this.panel.list.getModel().getElementAt(i);
            if (!item.isSelected) continue;
            ret.add(item);
        }
        return ret;
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (!e.getValueIsAdjusting() && e.getSource() == this.panel.list.getSelectionModel()) {
            this.changeSupport.fireChange();
        }
    }

    public void setEnabled(boolean b) {
        this.panel.list.setEnabled(b);
        this.panel.titleLabel.setEnabled(b);
    }

    public boolean isEmpty() {
        return this.panel.list.getModel().getSize() == 0;
    }

    private void attachListeners() {
        this.panel.list.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ItemSelector.this.switchSelection(((ItemSelector)ItemSelector.this).panel.list.locationToIndex(e.getPoint()));
            }
        });
        this.panel.list.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 32) {
                    ItemSelector.this.switchSelection(((ItemSelector)ItemSelector.this).panel.list.getSelectedIndex());
                }
            }
        });
    }

    private void switchSelection(int index) {
        if (index != -1) {
            Item item = (Item)this.panel.list.getModel().getElementAt(index);
            item.isSelected = !item.isSelected;
            this.panel.list.repaint();
            this.changeSupport.fireChange();
        }
    }

    public static abstract class Item
    implements Comparable<Item> {
        boolean isSelected;

        protected Item(boolean selected) {
            this.isSelected = selected;
        }

        public abstract String getText();

        public abstract String getTooltipText();
    }

    public class ItemRenderer
    implements ListCellRenderer {
        private JCheckBox renderer = new JCheckBox();
        private Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);

        public ItemRenderer() {
            this.renderer.setBorder(this.noFocusBorder);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.renderer.setBackground(list.getBackground());
            this.renderer.setForeground(list.getForeground());
            this.renderer.setEnabled(list.isEnabled());
            this.renderer.setFont(list.getFont());
            this.renderer.setFocusPainted(false);
            this.renderer.setBorderPainted(true);
            if (value instanceof Item) {
                Item item = (Item)value;
                this.renderer.setText("<html>" + item.getText() + "</html>");
                this.renderer.setToolTipText(item.getTooltipText());
                this.renderer.setSelected(item.isSelected);
            }
            this.renderer.setBorder(isSelected ? UIManager.getBorder("List.focusCellHighlightBorder") : this.noFocusBorder);
            return this.renderer;
        }
    }
}

