/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.ui.push;

import java.text.MessageFormat;
import org.netbeans.libs.git.GitBranch;
import org.netbeans.libs.git.GitTag;
import org.netbeans.modules.git.ui.push.PushBranchesStep;
import org.netbeans.modules.git.ui.selectors.ItemSelector;
import org.netbeans.modules.git.utils.GitUtils;
import org.openide.util.NbBundle;

public abstract class PushMapping
extends ItemSelector.Item {
    private final String label;
    private final String tooltip;
    private static final String BRANCH_MAPPING_LABEL = "{0} -> {1} [{2}]";
    private final String localName;

    protected PushMapping(String localName, String remoteName) {
        super(false);
        this.localName = localName;
        if (remoteName == null) {
            this.label = MessageFormat.format(BRANCH_MAPPING_LABEL, localName, localName, "<font color=\"#00b400\">A</font>");
            this.tooltip = NbBundle.getMessage(PushBranchesStep.class, (String)"LBL_PushBranchMapping.description", (Object[])new Object[]{localName, NbBundle.getMessage(PushBranchesStep.class, (String)"LBL_PushBranchMapping.Mode.added.description")});
        } else {
            this.label = MessageFormat.format(BRANCH_MAPPING_LABEL, localName, remoteName, "<font color=\"#0000FF\">U</font>");
            this.tooltip = NbBundle.getMessage(PushBranchesStep.class, (String)"LBL_PushBranchMapping.description", (Object[])new Object[]{remoteName, NbBundle.getMessage(PushBranchesStep.class, (String)"LBL_PushBranchMapping.Mode.updated.description")});
        }
    }

    public abstract String getRefSpec();

    @Override
    public String getText() {
        return this.label;
    }

    @Override
    public String getTooltipText() {
        return this.tooltip;
    }

    @Override
    public int compareTo(ItemSelector.Item t) {
        if (t == null) {
            return 1;
        }
        if (t instanceof PushMapping) {
            return this.localName.compareTo(((PushMapping)t).localName);
        }
        return 0;
    }

    public static final class PushBranchMapping
    extends PushMapping {
        private final GitBranch localBranch;
        private final GitBranch remoteBranch;

        public PushBranchMapping(GitBranch remoteBranch, GitBranch localBranch) {
            super(localBranch.getName(), remoteBranch == null ? null : remoteBranch.getName());
            this.localBranch = localBranch;
            this.remoteBranch = remoteBranch;
        }

        public String getRemoteRepositoryBranchName() {
            return this.remoteBranch == null ? this.localBranch.getName() : this.remoteBranch.getName();
        }

        public String getRemoteRepositoryBranchHeadId() {
            return this.remoteBranch == null ? null : this.remoteBranch.getId();
        }

        public String getLocalRepositoryBranchHeadId() {
            return this.localBranch == null ? null : this.localBranch.getId();
        }

        @Override
        public String getRefSpec() {
            return GitUtils.getPushRefSpec(this.localBranch.getName(), (this.remoteBranch == null ? this.localBranch : this.remoteBranch).getName());
        }
    }

    public static final class PushTagMapping
    extends PushMapping {
        private final GitTag tag;

        public PushTagMapping(GitTag tag) {
            super("tags/" + tag.getTagName(), null);
            this.tag = tag;
        }

        @Override
        public String getRefSpec() {
            return GitUtils.getPushTagRefSpec(this.tag.getTagName());
        }
    }
}

