/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.ui.history;

import java.awt.Color;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.netbeans.libs.git.GitBranch;
import org.netbeans.libs.git.GitUser;
import org.netbeans.libs.git.progress.ProgressMonitor;
import org.netbeans.modules.git.Git;
import org.netbeans.modules.git.client.GitProgressSupport;
import org.netbeans.modules.git.ui.diff.ExportCommitAction;
import org.netbeans.modules.git.ui.history.RepositoryRevision;
import org.netbeans.modules.git.ui.history.SearchHistoryPanel;
import org.netbeans.modules.git.ui.revert.RevertCommitAction;
import org.netbeans.modules.git.ui.tag.CreateTagAction;
import org.netbeans.modules.git.utils.GitUtils;
import org.netbeans.modules.versioning.history.AbstractSummaryView;
import org.netbeans.modules.versioning.util.VCSKenaiAccessor;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;
import org.openide.util.actions.SystemAction;

class SummaryView
extends AbstractSummaryView {
    private final SearchHistoryPanel master;
    private static final Logger LOG = Logger.getLogger(SummaryView.class.getName());
    private static DateFormat defaultFormat = DateFormat.getDateTimeInstance(3, 3);
    private static final Color HIGHLIGHT_BRANCH_FG = Color.BLACK;
    private static final Color HIGHLIGHT_TAG_FG = Color.BLACK;
    private static final Color HIGHLIGHT_BRANCH_BG = Color.decode("0xaaffaa");
    private static final Color HIGHLIGHT_TAG_BG = Color.decode("0xffffaa");

    public SummaryView(SearchHistoryPanel master, List<? extends AbstractSummaryView.LogEntry> results, Map<String, VCSKenaiAccessor.KenaiUser> kenaiUserMap) {
        super(SummaryView.createViewSummaryMaster(master), results, kenaiUserMap);
        this.master = master;
    }

    private static AbstractSummaryView.SummaryViewMaster createViewSummaryMaster(final SearchHistoryPanel master) {
        final HashMap<String, String> colors = new HashMap<String, String>();
        colors.put("A", "#008000");
        colors.put("C", "#008000");
        colors.put("R", "#008000");
        colors.put("M", "#0000ff");
        colors.put("D", "#999999");
        colors.put("?", "#000000");
        return new AbstractSummaryView.SummaryViewMaster(){

            public JComponent getComponent() {
                return master;
            }

            public File[] getRoots() {
                return master.getRoots();
            }

            public Collection<AbstractSummaryView.SummaryViewMaster.SearchHighlight> getSearchHighlights() {
                return master.getSearchHighlights();
            }

            public Map<String, String> getActionColors() {
                return colors;
            }

            public void getMoreResults(PropertyChangeListener callback, int count) {
                master.getMoreRevisions(callback, count);
            }

            public boolean hasMoreResults() {
                return master.hasMoreResults();
            }
        };
    }

    protected void onPopup(JComponent invoker, Point p, final Object[] selection) {
        boolean viewEnabled;
        RepositoryRevision.Event[] drev;
        RepositoryRevision container;
        boolean revisionSelected;
        JPopupMenu menu = new JPopupMenu();
        Object revCon = selection[0];
        boolean missingFile = false;
        if (revCon instanceof GitLogEntry && selection.length == 1) {
            revisionSelected = true;
            container = ((GitLogEntry)selection[0]).revision;
            drev = new RepositoryRevision.Event[]{};
        } else {
            revisionSelected = false;
            drev = new RepositoryRevision.Event[selection.length];
            for (int i = 0; i < selection.length; ++i) {
                if (!(selection[i] instanceof GitLogEvent)) {
                    return;
                }
                drev[i] = ((GitLogEvent)((Object)selection[i])).getEvent();
                if (missingFile || drev[i].getFile() != null) continue;
                missingFile = true;
            }
            container = drev[0].getLogInfoHeader();
        }
        boolean hasParents = container.getLog().getParents().length > 0;
        final boolean singleSelection = selection.length == 1;
        boolean bl = viewEnabled = singleSelection && !revisionSelected && drev[0].getFile() != null && drev[0].getAction() != 'D';
        if (hasParents) {
            menu.add(new JMenuItem(new AbstractAction(NbBundle.getMessage(SummaryView.class, (String)"CTL_SummaryView_DiffToPrevious")){
                {
                    super(x0);
                    this.setEnabled(singleSelection);
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    SummaryView.diffPrevious(selection[0], SummaryView.this.master);
                }
            }));
        }
        if (revisionSelected) {
            if (singleSelection) {
                menu.add(new JMenuItem(new AbstractAction(NbBundle.getMessage(CreateTagAction.class, (String)"LBL_CreateTagAction_PopupName.revision", (Object)container.getLog().getRevision().substring(0, 7))){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        CreateTagAction action = (CreateTagAction)SystemAction.get(CreateTagAction.class);
                        action.createTag(SummaryView.this.master.getRepository(), container.getLog().getRevision());
                    }
                }));
                if (container.getLog().getParents().length < 2) {
                    menu.add(new JMenuItem(new AbstractAction(NbBundle.getMessage(ExportCommitAction.class, (String)"LBL_ExportCommitAction_PopupName")){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            ExportCommitAction action = (ExportCommitAction)SystemAction.get(ExportCommitAction.class);
                            action.exportCommit(SummaryView.this.master.getRepository(), container.getLog().getRevision());
                        }
                    }));
                    menu.add(new JMenuItem(new AbstractAction(NbBundle.getMessage(RevertCommitAction.class, (String)"LBL_RevertCommitAction_PopupName")){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            RevertCommitAction action = (RevertCommitAction)SystemAction.get(RevertCommitAction.class);
                            action.revert(SummaryView.this.master.getRepository(), SummaryView.this.master.getRoots(), container.getLog().getRevision());
                        }
                    }));
                }
            }
        } else {
            menu.add(new JMenuItem(new AbstractAction(NbBundle.getMessage(SummaryView.class, (String)"CTL_SummaryView_View")){
                {
                    super(x0);
                    this.setEnabled(viewEnabled);
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    new GitProgressSupport(){

                        @Override
                        protected void perform() {
                            for (RepositoryRevision.Event evt : drev) {
                                SummaryView.openFile(evt, false, this.getProgressMonitor());
                            }
                        }
                    }.start(Git.getInstance().getRequestProcessor(), SummaryView.this.master.getRepository(), NbBundle.getMessage(SummaryView.class, (String)"MSG_SummaryView.openingFilesFromHistory"));
                }
            }));
            menu.add(new JMenuItem(new AbstractAction(NbBundle.getMessage(SummaryView.class, (String)"CTL_SummaryView_ShowAnnotations")){
                {
                    super(x0);
                    this.setEnabled(viewEnabled);
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    new GitProgressSupport(){

                        @Override
                        protected void perform() {
                            for (RepositoryRevision.Event evt : drev) {
                                SummaryView.openFile(evt, true, this.getProgressMonitor());
                            }
                        }
                    }.start(Git.getInstance().getRequestProcessor(), SummaryView.this.master.getRepository(), NbBundle.getMessage(SummaryView.class, (String)"MSG_SummaryView.openingFilesFromHistory"));
                }
            }));
        }
        menu.show(invoker, p.x, p.y);
    }

    private static void openFile(RepositoryRevision.Event evt, boolean showAnnotations, ProgressMonitor pm) {
        try {
            File originalFile = evt.getFile();
            String revision = evt.getLogInfoHeader().getLog().getRevision();
            GitUtils.openInRevision(originalFile, -1, revision, showAnnotations, pm);
        }
        catch (IOException ex) {
            LOG.log(Level.FINE, null, ex);
        }
    }

    private static void diffPrevious(Object o, SearchHistoryPanel master) {
        if (o instanceof RepositoryRevision.Event) {
            RepositoryRevision.Event drev = (RepositoryRevision.Event)o;
            master.showDiff(drev);
        } else if (o instanceof RepositoryRevision) {
            RepositoryRevision container = (RepositoryRevision)o;
            master.showDiff(container);
        } else if (o instanceof GitLogEvent) {
            master.showDiff(((GitLogEvent)((Object)o)).event);
        } else if (o instanceof GitLogEntry) {
            master.showDiff(((GitLogEntry)o).revision);
        }
    }

    static final class GitLogEntry
    extends AbstractSummaryView.LogEntry
    implements PropertyChangeListener {
        private RepositoryRevision revision;
        private List<AbstractSummaryView.LogEntry.Event> events = new ArrayList<AbstractSummaryView.LogEntry.Event>(10);
        private List<AbstractSummaryView.LogEntry.Event> dummyEvents;
        private SearchHistoryPanel master;
        private String complexRevision;
        private final PropertyChangeListener list;
        private Collection<AbstractSummaryView.LogEntry.RevisionHighlight> complexRevisionHighlights;

        public GitLogEntry(RepositoryRevision revision, SearchHistoryPanel master) {
            this.revision = revision;
            this.master = master;
            this.dummyEvents = Collections.emptyList();
            if (revision.isEventsInitialized()) {
                this.refreshEvents();
                this.list = null;
            } else {
                this.prepareDummyEvents();
                this.list = WeakListeners.propertyChange((PropertyChangeListener)this, (Object)revision);
                revision.addPropertyChangeListener("eventsChanged", this.list);
            }
        }

        public Collection<AbstractSummaryView.LogEntry.Event> getEvents() {
            return this.events;
        }

        public Collection<AbstractSummaryView.LogEntry.Event> getDummyEvents() {
            return this.dummyEvents;
        }

        public String getAuthor() {
            GitUser author = this.revision.getLog().getAuthor();
            return author == null ? "" : author.toString();
        }

        public String getDate() {
            Date date = new Date(this.revision.getLog().getCommitTime());
            return date != null ? defaultFormat.format(date) : null;
        }

        public String getRevision() {
            if (this.complexRevision == null) {
                this.complexRevisionHighlights = new ArrayList<AbstractSummaryView.LogEntry.RevisionHighlight>(this.revision.getBranches().length + this.revision.getTags().length + 1);
                StringBuilder sb = new StringBuilder();
                for (GitBranch gitBranch : this.revision.getBranches()) {
                    if (gitBranch.getName() != "(no branch)") {
                        this.complexRevisionHighlights.add(new AbstractSummaryView.LogEntry.RevisionHighlight(sb.length(), gitBranch.getName().length(), HIGHLIGHT_BRANCH_FG, HIGHLIGHT_BRANCH_BG));
                        sb.append(gitBranch.getName()).append(' ');
                    }
                    if (!gitBranch.isActive()) continue;
                    this.complexRevisionHighlights.add(new AbstractSummaryView.LogEntry.RevisionHighlight(sb.length(), "HEAD".length(), HIGHLIGHT_BRANCH_FG, HIGHLIGHT_BRANCH_BG));
                    sb.append("HEAD").append(' ');
                }
                for (GitBranch gitBranch : this.revision.getTags()) {
                    this.complexRevisionHighlights.add(new AbstractSummaryView.LogEntry.RevisionHighlight(sb.length(), gitBranch.getTagName().length(), HIGHLIGHT_TAG_FG, HIGHLIGHT_TAG_BG));
                    sb.append(gitBranch.getTagName()).append(' ');
                }
                String rev = this.revision.getLog().getRevision();
                sb.append(rev.length() > 7 ? rev.substring(0, 7) : rev);
                this.complexRevision = sb.toString();
            }
            return this.complexRevision;
        }

        protected Collection<AbstractSummaryView.LogEntry.RevisionHighlight> getRevisionHighlights() {
            this.getRevision();
            return this.complexRevisionHighlights;
        }

        public String getMessage() {
            return this.revision.getLog().getFullMessage();
        }

        public Action[] getActions() {
            boolean hasParents;
            ArrayList<AbstractAction> actions = new ArrayList<AbstractAction>();
            boolean bl = hasParents = this.revision.getLog().getParents().length > 0;
            if (hasParents) {
                actions.add(new AbstractAction(NbBundle.getMessage(SummaryView.class, (String)"CTL_SummaryView_DiffToPrevious_Short")){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        SummaryView.diffPrevious(GitLogEntry.this.revision, GitLogEntry.this.master);
                    }
                });
            }
            actions.add(new AbstractAction(NbBundle.getMessage(SummaryView.class, (String)"CTL_SummaryView_TagCommit")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CreateTagAction action = (CreateTagAction)SystemAction.get(CreateTagAction.class);
                    action.createTag(GitLogEntry.this.master.getRepository(), GitLogEntry.this.revision.getLog().getRevision());
                }
            });
            if (this.revision.getLog().getParents().length < 2) {
                actions.add(new AbstractAction(NbBundle.getMessage(ExportCommitAction.class, (String)"LBL_ExportCommitAction_PopupName")){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ExportCommitAction action = (ExportCommitAction)SystemAction.get(ExportCommitAction.class);
                        action.exportCommit(GitLogEntry.this.master.getRepository(), GitLogEntry.this.revision.getLog().getRevision());
                    }
                });
                actions.add(new AbstractAction(NbBundle.getMessage(RevertCommitAction.class, (String)"LBL_RevertCommitAction_PopupName")){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        RevertCommitAction action = (RevertCommitAction)SystemAction.get(RevertCommitAction.class);
                        action.revert(GitLogEntry.this.master.getRepository(), GitLogEntry.this.master.getRoots(), GitLogEntry.this.revision.getLog().getRevision());
                    }
                });
            }
            return actions.toArray(new Action[actions.size()]);
        }

        public String toString() {
            return this.revision.toString();
        }

        protected void expand() {
            this.revision.expandEvents();
        }

        protected void cancelExpand() {
            this.revision.cancelExpand();
        }

        protected boolean isEventsInitialized() {
            return this.revision.isEventsInitialized();
        }

        public boolean isVisible() {
            return this.master.applyFilter(this.revision);
        }

        protected boolean isLessInteresting() {
            return this.getRepositoryRevision().getLog().getParents().length > 1;
        }

        RepositoryRevision getRepositoryRevision() {
            return this.revision;
        }

        void prepareDummyEvents() {
            ArrayList<AbstractSummaryView.LogEntry.Event> evts = new ArrayList<AbstractSummaryView.LogEntry.Event>(this.revision.getDummyEvents().length);
            for (RepositoryRevision.Event event : this.revision.getDummyEvents()) {
                evts.add(new GitLogEvent(this.master, event));
            }
            this.dummyEvents = evts;
        }

        void refreshEvents() {
            ArrayList<AbstractSummaryView.LogEntry.Event> evts = new ArrayList<AbstractSummaryView.LogEntry.Event>(this.revision.getEvents().length);
            for (RepositoryRevision.Event event : this.revision.getEvents()) {
                evts.add(new GitLogEvent(this.master, event));
            }
            ArrayList<AbstractSummaryView.LogEntry.Event> oldEvents = new ArrayList<AbstractSummaryView.LogEntry.Event>(this.events);
            ArrayList newEvents = new ArrayList(evts);
            this.events = evts;
            this.dummyEvents.clear();
            this.eventsChanged(oldEvents, newEvents);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("eventsChanged".equals(evt.getPropertyName()) && this.revision == evt.getSource()) {
                this.refreshEvents();
            }
        }
    }

    static class GitLogEvent
    extends AbstractSummaryView.LogEntry.Event {
        private final RepositoryRevision.Event event;
        private final SearchHistoryPanel master;

        GitLogEvent(SearchHistoryPanel master, RepositoryRevision.Event event) {
            this.master = master;
            this.event = event;
        }

        public String getPath() {
            return this.event.getPath();
        }

        public String getOriginalPath() {
            return this.event.getOriginalPath();
        }

        public String getAction() {
            return Character.toString(this.event.getAction());
        }

        public RepositoryRevision.Event getEvent() {
            return this.event;
        }

        public Action[] getUserActions() {
            boolean hasParents;
            ArrayList<AbstractAction> actions = new ArrayList<AbstractAction>();
            boolean viewEnabled = this.event.getFile() != null && this.event.getAction() != 'D';
            boolean bl = hasParents = this.event.getLogInfoHeader().getLog().getParents().length > 0;
            if (hasParents) {
                actions.add(new AbstractAction(NbBundle.getMessage(SummaryView.class, (String)"CTL_SummaryView_DiffToPrevious")){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        SummaryView.diffPrevious(GitLogEvent.this.event, GitLogEvent.this.master);
                    }
                });
            }
            if (viewEnabled) {
                actions.add(new AbstractAction(NbBundle.getMessage(SummaryView.class, (String)"CTL_SummaryView_View")){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        new GitProgressSupport(){

                            @Override
                            protected void perform() {
                                SummaryView.openFile(GitLogEvent.this.event, false, this.getProgressMonitor());
                            }
                        }.start(Git.getInstance().getRequestProcessor(), GitLogEvent.this.master.getRepository(), NbBundle.getMessage(SummaryView.class, (String)"MSG_SummaryView.openingFilesFromHistory"));
                    }
                });
                actions.add(new AbstractAction(NbBundle.getMessage(SummaryView.class, (String)"CTL_SummaryView_ShowAnnotations")){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        new GitProgressSupport(){

                            @Override
                            protected void perform() {
                                SummaryView.openFile(GitLogEvent.this.event, true, this.getProgressMonitor());
                            }
                        }.start(Git.getInstance().getRequestProcessor(), GitLogEvent.this.master.getRepository(), NbBundle.getMessage(SummaryView.class, (String)"MSG_SummaryView.openingFilesFromHistory"));
                    }
                });
            }
            return actions.toArray(new Action[actions.size()]);
        }

        public boolean isVisibleByDefault() {
            return this.master.isShowInfo() || this.event.isUnderRoots();
        }

        public String toString() {
            return this.event.toString();
        }
    }
}

