/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.ui.history;

import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import org.netbeans.modules.git.GitModuleConfig;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

class SearchCriteriaPanel
extends JPanel {
    private JLabel commitMessageLabel;
    private JLabel fromInfoLabel;
    private JLabel fromLabel;
    private JLabel limitLabel;
    private JCheckBox showMergesChkBox;
    private JTextField tfCommitMessage;
    final JTextField tfFrom = new JTextField();
    final JTextField tfLimit = new JTextField();
    final JTextField tfTo = new JTextField();
    private JTextField tfUsername;
    private JLabel toInfoLabel;
    private JLabel toLabel;
    private JLabel usernameLabel;

    public SearchCriteriaPanel() {
        this.initComponents();
        this.showMergesChkBox.setSelected(GitModuleConfig.getDefault().getShowHistoryMerges());
        this.tfLimit.setText(Integer.toString(10));
    }

    public String getFrom() {
        String s = this.tfFrom.getText().trim();
        if (s.isEmpty()) {
            return null;
        }
        return s;
    }

    public String getTo() {
        String s = this.tfTo.getText().trim();
        if (s.isEmpty()) {
            return null;
        }
        return s;
    }

    public int getLimit() {
        String s = this.tfLimit.getText().trim();
        Integer retval = -1;
        try {
            retval = Integer.parseInt(s);
        }
        catch (NumberFormatException ex) {
            retval = -1;
        }
        if (retval <= 0) {
            retval = -1;
        }
        return retval;
    }

    public void setLimit(int limit) {
        if (limit > 0) {
            this.tfLimit.setText(Integer.toString(limit));
        } else {
            this.tfLimit.setText("");
        }
    }

    public String getCommitMessage() {
        String s = this.tfCommitMessage.getText().trim();
        return s.isEmpty() ? null : s;
    }

    public String getUsername() {
        String s = this.tfUsername.getText().trim();
        return s.isEmpty() ? null : s;
    }

    boolean isIncludeMerges() {
        return this.showMergesChkBox.isSelected();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SearchCriteriaPanel.this.tfCommitMessage.requestFocusInWindow();
            }
        });
    }

    private void initComponents() {
        this.commitMessageLabel = new JLabel();
        this.tfCommitMessage = new JTextField();
        this.usernameLabel = new JLabel();
        this.tfUsername = new JTextField();
        this.fromLabel = new JLabel();
        this.fromInfoLabel = new JLabel();
        this.toLabel = new JLabel();
        this.toInfoLabel = new JLabel();
        this.limitLabel = new JLabel();
        this.showMergesChkBox = new JCheckBox();
        this.setBorder(BorderFactory.createEmptyBorder(8, 12, 0, 11));
        this.commitMessageLabel.setLabelFor(this.tfCommitMessage);
        ResourceBundle bundle = ResourceBundle.getBundle("org/netbeans/modules/git/ui/history/Bundle");
        Mnemonics.setLocalizedText((JLabel)this.commitMessageLabel, (String)bundle.getString("CTL_UseCommitMessage"));
        this.commitMessageLabel.setToolTipText(bundle.getString("TT_CommitMessage"));
        this.tfCommitMessage.setColumns(20);
        this.usernameLabel.setLabelFor(this.tfUsername);
        Mnemonics.setLocalizedText((JLabel)this.usernameLabel, (String)bundle.getString("CTL_UseUsername"));
        this.usernameLabel.setToolTipText(bundle.getString("TT_Username"));
        this.tfUsername.setColumns(20);
        this.fromLabel.setLabelFor(this.tfFrom);
        Mnemonics.setLocalizedText((JLabel)this.fromLabel, (String)bundle.getString("CTL_UseFrom"));
        this.fromLabel.setToolTipText(bundle.getString("TT_From"));
        this.tfFrom.setColumns(20);
        Mnemonics.setLocalizedText((JLabel)this.fromInfoLabel, (String)bundle.getString("CTL_FromToHint"));
        this.toLabel.setLabelFor(this.tfTo);
        Mnemonics.setLocalizedText((JLabel)this.toLabel, (String)bundle.getString("CTL_UseTo"));
        this.toLabel.setToolTipText(bundle.getString("TT_To"));
        this.tfTo.setColumns(20);
        Mnemonics.setLocalizedText((JLabel)this.toInfoLabel, (String)bundle.getString("CTL_FromToHint"));
        this.limitLabel.setLabelFor(this.tfLimit);
        Mnemonics.setLocalizedText((JLabel)this.limitLabel, (String)bundle.getString("CTL_UseLimit"));
        this.limitLabel.setToolTipText(bundle.getString("TT_Limit"));
        this.tfLimit.setColumns(10);
        this.showMergesChkBox.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.showMergesChkBox, (String)NbBundle.getMessage(SearchCriteriaPanel.class, (String)"CTL_ShowMerge"));
        this.showMergesChkBox.setToolTipText(NbBundle.getMessage(SearchCriteriaPanel.class, (String)"TT_ShowMerges"));
        this.showMergesChkBox.setHorizontalTextPosition(4);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.limitLabel).addComponent(this.commitMessageLabel).addComponent(this.usernameLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addComponent(this.tfLimit, -2, 1, Short.MAX_VALUE).addGap(18, 18, 18).addComponent(this.showMergesChkBox)).addComponent(this.tfUsername, GroupLayout.Alignment.LEADING).addComponent(this.tfCommitMessage, GroupLayout.Alignment.LEADING)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.fromLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.fromInfoLabel).addComponent(this.tfFrom))).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(16, 16, 16).addComponent(this.toLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.toInfoLabel).addComponent(this.tfTo))))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.tfCommitMessage, -2, -1, -2).addComponent(this.commitMessageLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.tfUsername, -2, -1, -2).addComponent(this.usernameLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.limitLabel).addComponent(this.tfLimit, -2, -1, -2).addComponent(this.showMergesChkBox))).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.fromLabel).addComponent(this.tfFrom, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.fromInfoLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.tfTo, -2, -1, -2).addComponent(this.toLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.toInfoLabel))).addContainerGap(-1, Short.MAX_VALUE)));
    }
}

