/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.ui.fetch;

import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.GitPullResult;
import org.netbeans.libs.git.GitRemoteConfig;
import org.netbeans.modules.git.Git;
import org.netbeans.modules.git.client.GitClient;
import org.netbeans.modules.git.client.GitClientExceptionHandler;
import org.netbeans.modules.git.client.GitProgressSupport;
import org.netbeans.modules.git.ui.actions.GitAction;
import org.netbeans.modules.git.ui.fetch.GetRemoteChangesAction;
import org.netbeans.modules.git.ui.fetch.PullWizard;
import org.netbeans.modules.git.ui.merge.MergeRevisionAction;
import org.netbeans.modules.git.ui.repository.RepositoryInfo;
import org.netbeans.modules.git.utils.GitUtils;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.util.NbBundle;

public class PullAction
extends GetRemoteChangesAction {
    private static final Logger LOG = Logger.getLogger(PullAction.class.getName());

    @Override
    protected void performAction(File repository, File[] roots, VCSContext context) {
        this.pull(repository);
    }

    private void pull(File repository) {
        RepositoryInfo info = RepositoryInfo.getInstance(repository);
        info.refreshRemotes();
        Map<String, GitRemoteConfig> remotes = info.getRemotes();
        PullWizard wiz = new PullWizard(repository, remotes);
        if (wiz.show()) {
            Utils.logVCSExternalRepository((String)"GIT", (String)wiz.getFetchUri());
            this.pull(repository, wiz.getFetchUri(), wiz.getFetchRefSpecs(), wiz.getBranchToMerge());
        }
    }

    public void pull(File repository, final String remote, final List<String> fetchRefSpecs, final String branchToMerge) {
        GitProgressSupport supp = new GitProgressSupport(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void perform() {
                File repository = this.getRepositoryRoot();
                LOG.log(Level.FINE, "Pulling {0}/{1} from {2}", new Object[]{fetchRefSpecs, branchToMerge, remote});
                try {
                    boolean cont;
                    GitClient client = this.getClient();
                    MergeRevisionAction.MergeResultProcessor mrp = new MergeRevisionAction.MergeResultProcessor(client, repository, branchToMerge, this.getLogger(), this.getProgressMonitor());
                    do {
                        cont = false;
                        try {
                            GitPullResult result = client.pull(remote, fetchRefSpecs, branchToMerge, this.getProgressMonitor());
                            PullAction.this.log(result.getFetchResult(), this.getLogger());
                            mrp.processResult(result.getMergeResult());
                        }
                        catch (GitException.CheckoutConflictException ex) {
                            if (LOG.isLoggable(Level.FINE)) {
                                LOG.log(Level.FINE, "Local modifications in WT during merge: {0} - {1}", new Object[]{repository, Arrays.asList(ex.getConflicts())});
                            }
                            cont = mrp.resolveLocalChanges(ex.getConflicts());
                        }
                    } while (cont);
                }
                catch (GitException ex) {
                    GitClientExceptionHandler.notifyException((Exception)((Object)ex), true);
                }
                finally {
                    this.setDisplayName(NbBundle.getMessage(GitAction.class, (String)"LBL_Progress.RefreshingStatuses"));
                    Git.getInstance().getFileStatusCache().refreshAllRoots(Collections.singletonMap(repository, Git.getInstance().getSeenRoots(repository)));
                    GitUtils.headChanged(repository);
                }
            }
        };
        supp.start(Git.getInstance().getRequestProcessor(repository), repository, NbBundle.getMessage(PullAction.class, (String)"LBL_PullAction.progressName"));
    }
}

