/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.ui.fetch;

import java.text.MessageFormat;
import org.netbeans.libs.git.GitRemoteConfig;
import org.netbeans.modules.git.ui.fetch.FetchBranchesStep;
import org.netbeans.modules.git.ui.selectors.ItemSelector;
import org.netbeans.modules.git.utils.GitUtils;
import org.openide.util.NbBundle;

public class BranchMapping
extends ItemSelector.Item {
    private final String label;
    private final String tooltip;
    private final String remoteBranch;
    private final GitRemoteConfig remote;
    private static final String BRANCH_MAPPING_LABEL = "{0} -> {1}/{0} [{2}]";

    public BranchMapping(String remoteBranch, String localBranch, GitRemoteConfig remote, boolean preselected) {
        super(preselected);
        this.remoteBranch = remoteBranch;
        this.remote = remote;
        if (localBranch == null) {
            this.label = MessageFormat.format(BRANCH_MAPPING_LABEL, remoteBranch, remote.getRemoteName(), "<font color=\"#00b400\">A</font>");
            this.tooltip = NbBundle.getMessage(FetchBranchesStep.class, (String)"LBL_FetchBranchesPanel.BranchMapping.description", (Object[])new Object[]{localBranch == null ? remote.getRemoteName() + "/" + remoteBranch : localBranch, NbBundle.getMessage(FetchBranchesStep.class, (String)"LBL_FetchBranchesPanel.BranchMapping.Mode.added.description")});
        } else {
            this.label = MessageFormat.format(BRANCH_MAPPING_LABEL, remoteBranch, remote.getRemoteName(), "<font color=\"#0000FF\">U</font>");
            this.tooltip = NbBundle.getMessage(FetchBranchesStep.class, (String)"LBL_FetchBranchesPanel.BranchMapping.description", (Object[])new Object[]{localBranch, NbBundle.getMessage(FetchBranchesStep.class, (String)"LBL_FetchBranchesPanel.BranchMapping.Mode.updated.description")});
        }
    }

    public String getRefSpec() {
        return GitUtils.getRefSpec(this.remoteBranch, this.remote.getRemoteName());
    }

    @Override
    public String getText() {
        return this.label;
    }

    @Override
    public String getTooltipText() {
        return this.tooltip;
    }

    public String getRemoteBranchName() {
        return this.remoteBranch;
    }

    public String getRemoteName() {
        return this.remote.getRemoteName();
    }

    @Override
    public int compareTo(ItemSelector.Item t) {
        if (t == null) {
            return 1;
        }
        if (t instanceof BranchMapping) {
            return this.remoteBranch.compareTo(((BranchMapping)t).remoteBranch);
        }
        return 0;
    }
}

