/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.ui.diff;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.EnumSet;
import java.util.ResourceBundle;
import org.netbeans.api.diff.DiffController;
import org.netbeans.api.diff.StreamSource;
import org.netbeans.modules.git.FileInformation;
import org.netbeans.modules.git.ui.commit.GitFileNode;
import org.netbeans.modules.git.ui.diff.DiffNode;
import org.netbeans.modules.git.ui.diff.DiffStreamSource;
import org.netbeans.modules.versioning.diff.AbstractDiffSetup;
import org.openide.util.NbBundle;

class Setup
extends AbstractDiffSetup {
    private final File baseFile;
    private final String firstRevision;
    private final String secondRevision;
    private FileInformation info;
    private DiffStreamSource firstSource;
    private DiffStreamSource secondSource;
    private DiffController view;
    private DiffNode node;
    private String title;

    public Setup(DiffNode node, FileInformation.Mode mode) {
        String secondTitle;
        String firstTitle;
        this.node = node;
        this.baseFile = node.getFile();
        ResourceBundle loc = NbBundle.getBundle(Setup.class);
        this.info = ((GitFileNode)node.getFileNode()).getInformation();
        File originalFile = null;
        if (this.info != null && (this.info.isCopied() || this.info.isRenamed())) {
            originalFile = this.info.getOldFile();
        }
        switch (mode) {
            case HEAD_VS_WORKING_TREE: 
            case HEAD_VS_INDEX: {
                this.firstRevision = originalFile == null && this.info.containsStatus(EnumSet.of(FileInformation.Status.NEW_HEAD_WORKING_TREE, FileInformation.Status.NEW_HEAD_INDEX)) ? null : "HEAD";
                firstTitle = originalFile == null ? loc.getString("MSG_DiffPanel_HeadRevision") : MessageFormat.format(loc.getString("MSG_DiffPanel_HeadRevision.file"), originalFile.getName());
                break;
            }
            case INDEX_VS_WORKING_TREE: {
                this.firstRevision = "INDEX";
                firstTitle = MessageFormat.format(loc.getString("MSG_DiffPanel_IndexRevision"), this.firstRevision);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown diff type: " + (Object)((Object)mode));
            }
        }
        switch (mode) {
            case HEAD_VS_WORKING_TREE: 
            case INDEX_VS_WORKING_TREE: {
                if (this.info.containsStatus(FileInformation.Status.NEW_HEAD_WORKING_TREE)) {
                    this.secondRevision = "CURRENT";
                    if (originalFile != null) {
                        if (this.info.isRenamed()) {
                            secondTitle = loc.getString("MSG_DiffPanel_LocalRenamed");
                            break;
                        }
                        secondTitle = loc.getString("MSG_DiffPanel_LocalCopied");
                        break;
                    }
                    secondTitle = loc.getString("MSG_DiffPanel_LocalNew");
                    break;
                }
                if (this.info.containsStatus(FileInformation.Status.REMOVED_HEAD_WORKING_TREE)) {
                    this.secondRevision = null;
                    secondTitle = loc.getString("MSG_DiffPanel_LocalDeleted");
                    break;
                }
                this.secondRevision = "CURRENT";
                secondTitle = loc.getString("MSG_DiffPanel_LocalModified");
                break;
            }
            case HEAD_VS_INDEX: {
                if (this.info.containsStatus(FileInformation.Status.NEW_HEAD_INDEX)) {
                    this.secondRevision = "INDEX";
                    if (originalFile != null) {
                        if (this.info.isRenamed()) {
                            secondTitle = loc.getString("MSG_DiffPanel_IndexRenamed");
                            break;
                        }
                        secondTitle = loc.getString("MSG_DiffPanel_IndexCopied");
                        break;
                    }
                    secondTitle = loc.getString("MSG_DiffPanel_IndexNew");
                    break;
                }
                if (this.info.containsStatus(FileInformation.Status.REMOVED_HEAD_INDEX)) {
                    this.secondRevision = null;
                    secondTitle = loc.getString("MSG_DiffPanel_IndexDeleted");
                    break;
                }
                this.secondRevision = "INDEX";
                secondTitle = loc.getString("MSG_DiffPanel_IndexModified");
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown diff type: " + (Object)((Object)mode));
            }
        }
        this.firstSource = new DiffStreamSource(originalFile == null || mode == FileInformation.Mode.INDEX_VS_WORKING_TREE ? this.baseFile : originalFile, this.firstRevision, firstTitle);
        this.secondSource = new DiffStreamSource(this.baseFile, this.secondRevision, secondTitle);
        this.title = "<html>" + this.info.annotateNameHtml(this.baseFile.getName());
    }

    Setup(File file, FileInformation.Mode mode, final boolean forceNonEditable) {
        this.baseFile = file;
        switch (mode) {
            case HEAD_VS_INDEX: {
                this.firstRevision = "HEAD";
                this.secondRevision = "INDEX";
                break;
            }
            case HEAD_VS_WORKING_TREE: {
                this.firstRevision = "HEAD";
                this.secondRevision = "CURRENT";
                break;
            }
            case INDEX_VS_WORKING_TREE: {
                this.firstRevision = "INDEX";
                this.secondRevision = "CURRENT";
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        this.firstSource = new DiffStreamSource(this.baseFile, this.firstRevision, this.firstRevision);
        this.secondSource = new DiffStreamSource(this.baseFile, this.secondRevision, this.secondRevision){

            @Override
            public boolean isEditable() {
                return !forceNonEditable && super.isEditable();
            }
        };
    }

    Setup(File file, String rev1, String rev2) {
        this.baseFile = file;
        this.firstRevision = rev1;
        this.secondRevision = rev2;
        this.firstSource = new DiffStreamSource(this.baseFile, this.firstRevision, this.firstRevision);
        this.secondSource = new DiffStreamSource(this.baseFile, this.secondRevision, this.secondRevision);
    }

    public File getBaseFile() {
        return this.baseFile;
    }

    public FileInformation getInfo() {
        return this.info;
    }

    public void setView(DiffController view) {
        this.view = view;
    }

    public DiffController getView() {
        return this.view;
    }

    public StreamSource getFirstSource() {
        return this.firstSource;
    }

    public StreamSource getSecondSource() {
        return this.secondSource;
    }

    DiffNode getNode() {
        return this.node;
    }

    public String toString() {
        return this.title;
    }

    void initSources() throws IOException {
        if (this.firstSource != null) {
            this.firstSource.init();
        }
        if (this.secondSource != null) {
            this.secondSource.init();
        }
    }
}

