/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.ui.commit;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseListener;
import java.util.LinkedList;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;
import javax.swing.text.JTextComponent;
import org.netbeans.modules.git.GitModuleConfig;
import org.netbeans.modules.git.ui.commit.GitCommitParameters;
import org.netbeans.modules.spellchecker.api.Spellchecker;
import org.netbeans.modules.versioning.util.StringSelector;
import org.netbeans.modules.versioning.util.TemplateSelector;
import org.netbeans.modules.versioning.util.UndoRedoSupport;
import org.netbeans.modules.versioning.util.common.CommitMessageMouseAdapter;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class CommitPanel
extends JPanel {
    private final GitCommitParameters parameters;
    private UndoRedoSupport um;
    final JComboBox authorComboBox = new JComboBox();
    final JComboBox commiterComboBox = new JComboBox();
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JScrollPane jScrollPane1;
    private JLabel messageLabel;
    final JTextArea messageTextArea = new JTextArea();
    private JLabel recentLabel;
    private JLabel templatesLabel;

    public CommitPanel(GitCommitParameters parameters, String commitMessage, String user) {
        this.parameters = parameters;
        this.initComponents();
        Mnemonics.setLocalizedText((JLabel)this.messageLabel, (String)this.getMessage("CTL_CommitForm_Message"));
        this.messageTextArea.setColumns(60);
        this.messageTextArea.setLineWrap(true);
        this.messageTextArea.setRows(4);
        this.messageTextArea.setTabSize(4);
        this.messageTextArea.setWrapStyleWord(true);
        this.messageTextArea.setMinimumSize(new Dimension(100, 18));
        this.messageTextArea.getAccessibleContext().setAccessibleName(this.getMessage("ACSN_CommitForm_Message"));
        this.messageTextArea.getAccessibleContext().setAccessibleDescription(this.getMessage("ACSD_CommitForm_Message"));
        this.messageTextArea.addMouseListener((MouseListener)new CommitMessageMouseAdapter());
        this.authorComboBox.setModel(this.prepareUserModel(GitModuleConfig.getDefault().getRecentCommitAuthors(), user));
        this.setCaretPosition(this.authorComboBox);
        this.commiterComboBox.setModel(this.prepareUserModel(GitModuleConfig.getDefault().getRecentCommiters(), user));
        this.setCaretPosition(this.commiterComboBox);
        Spellchecker.register((JTextComponent)this.messageTextArea);
        this.initCommitMessage(commitMessage);
    }

    private void setCaretPosition(JComboBox cbo) {
        Component cmp = cbo.getEditor().getEditorComponent();
        if (cmp instanceof JTextComponent) {
            ((JTextComponent)cmp).setCaretPosition(0);
        }
    }

    private void initCommitMessage(String commitMessage) {
        TemplateSelector ts = new TemplateSelector(this.parameters.getPreferences());
        if (commitMessage != null) {
            this.messageTextArea.setText(commitMessage);
        }
        if (ts.isAutofill()) {
            this.messageTextArea.setText(ts.getTemplate());
        } else {
            List<String> messages;
            String lastCommitMessage = this.parameters.getLastCanceledCommitMessage();
            if (lastCommitMessage.isEmpty() && new StringSelector.RecentMessageSelector(this.parameters.getPreferences()).isAutoFill() && (messages = this.parameters.getCommitMessages()).size() > 0) {
                lastCommitMessage = messages.get(0);
            }
            if (!lastCommitMessage.isEmpty()) {
                this.messageTextArea.setText(lastCommitMessage);
            }
        }
        this.messageTextArea.selectAll();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (this.um == null) {
            this.um = UndoRedoSupport.register((JTextComponent)this.messageTextArea);
        }
    }

    @Override
    public void removeNotify() {
        if (!(this.getParent() != null && this.getParent().isShowing() || this.um == null)) {
            this.um.unregister();
            this.um = null;
        }
        super.removeNotify();
    }

    private void initComponents() {
        this.messageLabel = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.templatesLabel = this.parameters.getMessagesTemplateLink(this.messageTextArea);
        this.recentLabel = this.parameters.getRecentMessagesLink(this.messageTextArea);
        this.messageLabel.setLabelFor(this.messageTextArea);
        this.messageLabel.setText(NbBundle.getMessage(CommitPanel.class, (String)"CommitPanel.messageLabel.text"));
        this.messageTextArea.setColumns(20);
        this.messageTextArea.setRows(5);
        this.jScrollPane1.setViewportView(this.messageTextArea);
        this.jLabel2.setText(NbBundle.getMessage(CommitPanel.class, (String)"CommitPanel.jLabel2.text"));
        this.authorComboBox.setEditable(true);
        this.commiterComboBox.setEditable(true);
        this.jLabel3.setText(NbBundle.getMessage(CommitPanel.class, (String)"CommitPanel.jLabel3.text"));
        this.templatesLabel.setText(NbBundle.getMessage(CommitPanel.class, (String)"CommitPanel.templatesLabel.text"));
        this.recentLabel.setText(NbBundle.getMessage(CommitPanel.class, (String)"CommitPanel.recentLabel.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 585, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.messageLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 465, Short.MAX_VALUE).addComponent(this.recentLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.templatesLabel)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.authorComboBox, 0, 219, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel3).addGap(18, 18, 18).addComponent(this.commiterComboBox, 0, 219, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.messageLabel).addComponent(this.templatesLabel).addComponent(this.recentLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 113, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.jLabel3).addComponent(this.authorComboBox, -2, -1, -2).addComponent(this.commiterComboBox, -2, -1, -2)).addContainerGap()));
    }

    private String getMessage(String msgKey) {
        return NbBundle.getMessage(CommitPanel.class, (String)msgKey);
    }

    private ComboBoxModel prepareUserModel(List<String> authors, String user) {
        if (authors == null) {
            authors = new LinkedList<String>();
        }
        if (!authors.contains(user)) {
            authors.add(user);
        }
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>(authors.toArray(new String[authors.size()]));
        return model;
    }
}

