/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.ui.clone;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.libs.git.GitBranch;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.GitRemoteConfig;
import org.netbeans.libs.git.GitTransportUpdate;
import org.netbeans.libs.git.GitURI;
import org.netbeans.modules.git.Git;
import org.netbeans.modules.git.client.GitClient;
import org.netbeans.modules.git.client.GitClientExceptionHandler;
import org.netbeans.modules.git.client.GitProgressSupport;
import org.netbeans.modules.git.ui.clone.CloneWizard;
import org.netbeans.modules.git.ui.output.OutputLogger;
import org.netbeans.modules.git.utils.GitUtils;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.netbeans.modules.versioning.util.ProjectUtilities;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class CloneAction
implements ActionListener,
HelpCtx.Provider {
    private final VCSContext ctx;

    public CloneAction(VCSContext ctx) {
        this.ctx = ctx;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("org.netbeans.modules.git.ui.clone.CloneAction");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        CloneWizard wiz;
        Set roots;
        String cloneFromPath = null;
        if (this.ctx != null && (roots = this.ctx.getRootFiles()).size() == 1) {
            File file;
            FileObject fo;
            Collection nodes;
            Lookup l = this.ctx.getElements();
            Project project = null;
            if (l != null && (nodes = l.lookupAll(Node.class)) != null && !nodes.isEmpty()) {
                project = (Project)((Node)nodes.iterator().next()).getLookup().lookup(Project.class);
            }
            if (project == null && (fo = FileUtil.toFileObject((File)((File)roots.iterator().next()))) != null && fo.isFolder()) {
                try {
                    project = ProjectManager.getDefault().findProject(fo);
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                catch (IllegalArgumentException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            if (project != null && (file = FileUtil.toFile((FileObject)(fo = project.getProjectDirectory()))) != null && Git.getInstance().isManaged(file)) {
                cloneFromPath = file.getAbsolutePath();
            }
        }
        if ((wiz = new CloneWizard(cloneFromPath)).show()) {
            final GitURI remoteUri = wiz.getRemoteURI();
            final File destination = wiz.getDestination();
            final String remoteName = wiz.getRemoteName();
            List<? extends GitBranch> branches = wiz.getBranches();
            final ArrayList<String> refSpecs = new ArrayList<String>(branches.size());
            for (GitBranch gitBranch : branches) {
                refSpecs.add(GitUtils.getRefSpec(gitBranch, remoteName));
            }
            final GitBranch branch = wiz.getBranch();
            final boolean bl = wiz.scanForProjects();
            GitProgressSupport supp = new GitProgressSupport(){

                @Override
                protected void perform() {
                    try {
                        GitClient client = this.getClient();
                        client.init(this.getProgressMonitor());
                        Map<String, GitTransportUpdate> updates = client.fetch(remoteUri.toPrivateString(), refSpecs, this.getProgressMonitor());
                        this.log(updates);
                        if (this.isCanceled()) {
                            return;
                        }
                        client.setRemote(new CloneRemoteConfig(remoteName, remoteUri, refSpecs).toGitRemote(), this.getProgressMonitor());
                        Utils.logVCSExternalRepository((String)"GIT", (String)remoteUri.toString());
                        client.createBranch(branch.getName(), remoteName + "/" + branch.getName(), this.getProgressMonitor());
                        client.checkoutRevision(branch.getName(), true, this.getProgressMonitor());
                        Git.getInstance().getFileStatusCache().refreshAllRoots(destination);
                        Git.getInstance().versionedFilesChanged();
                        if (bl && !this.isCanceled()) {
                            CloneAction.this.scanForProjects(destination, this);
                        }
                    }
                    catch (GitException ex) {
                        GitClientExceptionHandler.notifyException((Exception)((Object)ex), true);
                    }
                }

                private void log(Map<String, GitTransportUpdate> updates) {
                    OutputLogger logger = this.getLogger();
                    if (updates.isEmpty()) {
                        logger.output(NbBundle.getMessage(CloneAction.class, (String)"MSG_CloneAction.updates.noChange"));
                    } else {
                        for (Map.Entry<String, GitTransportUpdate> e : updates.entrySet()) {
                            GitTransportUpdate update = e.getValue();
                            if (update.getType() == GitTransportUpdate.Type.BRANCH) {
                                logger.output(NbBundle.getMessage(CloneAction.class, (String)"MSG_CloneAction.updates.updateBranch", (Object[])new Object[]{update.getLocalName(), update.getOldObjectId(), update.getNewObjectId(), update.getResult()}));
                                continue;
                            }
                            logger.output(NbBundle.getMessage(CloneAction.class, (String)"MSG_CloneAction.updates.updateTag", (Object[])new Object[]{update.getLocalName(), update.getResult()}));
                        }
                    }
                }
            };
            supp.start(Git.getInstance().getRequestProcessor(destination), destination, NbBundle.getMessage(CloneAction.class, (String)"LBL_CloneAction.progressName"));
        }
    }

    public void scanForProjects(File workingFolder, GitProgressSupport support) {
        HashMap checkedOutProjects = new HashMap();
        checkedOutProjects.put(null, new HashSet());
        File normalizedWorkingFolder = FileUtil.normalizeFile((File)workingFolder);
        FileObject fo = FileUtil.toFileObject((File)normalizedWorkingFolder);
        if (fo == null || !fo.isFolder()) {
            return;
        }
        ProjectUtilities.scanForProjects((FileObject)fo, checkedOutProjects);
        if (support != null && support.isCanceled()) {
            return;
        }
        ProjectUtilities.openClonedOutProjects(checkedOutProjects, (File)workingFolder);
    }

    private static class CloneRemoteConfig {
        private String remoteName;
        private GitURI remoteUri;
        private List<String> refSpecs;

        public CloneRemoteConfig(String remoteName, GitURI remoteUri, List<String> refSpecs) {
            this.remoteName = remoteName;
            this.remoteUri = remoteUri;
            this.refSpecs = refSpecs;
        }

        public String getRemoteName() {
            return this.remoteName;
        }

        public List<String> getUris() {
            return Arrays.asList(this.remoteUri.toPrivateString());
        }

        public List<String> getPushUris() {
            return Collections.emptyList();
        }

        public List<String> getFetchRefSpecs() {
            return this.refSpecs;
        }

        public List<String> getPushRefSpecs() {
            return Collections.emptyList();
        }

        private GitRemoteConfig toGitRemote() {
            return new GitRemoteConfig(this.remoteName, this.getUris(), this.getPushUris(), this.getFetchRefSpecs(), this.getPushRefSpecs());
        }
    }
}

