/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.ui.checkout;

import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.progress.FileListener;
import org.netbeans.libs.git.progress.NotificationListener;
import org.netbeans.modules.git.FileInformation;
import org.netbeans.modules.git.Git;
import org.netbeans.modules.git.client.GitClient;
import org.netbeans.modules.git.client.GitClientExceptionHandler;
import org.netbeans.modules.git.client.GitProgressSupport;
import org.netbeans.modules.git.ui.actions.GitAction;
import org.netbeans.modules.git.ui.actions.SingleRepositoryAction;
import org.netbeans.modules.git.ui.checkout.RevertChanges;
import org.netbeans.modules.git.utils.GitUtils;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.openide.util.NbBundle;

public class RevertChangesAction
extends SingleRepositoryAction {
    private static final Logger LOG = Logger.getLogger(RevertChangesAction.class.getName());

    protected String iconResource() {
        return "org/netbeans/modules/git/resources/icons/get_clean.png";
    }

    @Override
    protected void performAction(final File repository, final File[] roots, VCSContext context) {
        final RevertChanges revert = new RevertChanges(roots);
        if (revert.show()) {
            GitProgressSupport supp = new GitProgressSupport(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                protected void perform() {
                    final HashSet notifiedFiles = new HashSet();
                    File[] actionRoots = GitUtils.listFiles(roots, FileInformation.STATUS_LOCAL_CHANGES);
                    if (actionRoots.length == 0) {
                        return;
                    }
                    try {
                        GitClient client = this.getClient();
                        client.addNotificationListener((NotificationListener)new FileListener(){

                            public void notifyFile(File file, String relativePathToRoot) {
                                notifiedFiles.add(file);
                            }
                        });
                        client.addNotificationListener((NotificationListener)new GitProgressSupport.DefaultFileListener(actionRoots));
                        if (revert.isRevertAll()) {
                            this.logRevert("revert all", actionRoots, repository);
                            client.checkout(actionRoots, "HEAD", true, this.getProgressMonitor());
                        } else if (revert.isRevertIndex()) {
                            this.logRevert("revert index", actionRoots, repository);
                            client.reset(actionRoots, "HEAD", true, this.getProgressMonitor());
                        } else if (revert.isRevertWT()) {
                            this.logRevert("revert wt", actionRoots, repository);
                            client.checkout(actionRoots, null, true, this.getProgressMonitor());
                        }
                        if (revert.isRemove()) {
                            this.logRevert("clean ", actionRoots, repository);
                            client.clean(actionRoots, this.getProgressMonitor());
                        }
                    }
                    catch (GitException ex) {
                        GitClientExceptionHandler.notifyException((Exception)((Object)ex), true);
                    }
                    finally {
                        revert.storeSettings();
                        this.setDisplayName(NbBundle.getMessage(GitAction.class, (String)"LBL_Progress.RefreshingStatuses"));
                        Git.getInstance().getFileStatusCache().refreshAllRoots(Collections.singletonMap(this.getRepositoryRoot(), notifiedFiles));
                    }
                }

                private void logRevert(String msg, File[] roots2, File repository2) {
                    if (LOG.isLoggable(Level.FINE)) {
                        String repopath = repository2.getAbsolutePath();
                        if (!repopath.endsWith("/")) {
                            repopath = repopath + "/";
                        }
                        StringBuilder sb = new StringBuilder();
                        sb.append(msg);
                        sb.append(" [");
                        for (int i = 0; i < roots2.length; ++i) {
                            String path = roots2[i].getAbsolutePath();
                            if (path.startsWith(repopath)) {
                                path = path.substring(repopath.length());
                            }
                            sb.append(path);
                            if (i >= roots2.length - 1) continue;
                            sb.append(",");
                        }
                        sb.append("]");
                        LOG.fine(sb.toString());
                    }
                }
            };
            supp.start(Git.getInstance().getRequestProcessor(repository), repository, NbBundle.getMessage(RevertChangesAction.class, (String)"LBL_CheckoutPaths.progressName"));
        }
    }
}

