/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.ui.blame;

import java.awt.EventQueue;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import org.netbeans.libs.git.GitBlameResult;
import org.netbeans.libs.git.GitException;
import org.netbeans.modules.git.FileInformation;
import org.netbeans.modules.git.FileStatusCache;
import org.netbeans.modules.git.Git;
import org.netbeans.modules.git.client.GitClientExceptionHandler;
import org.netbeans.modules.git.client.GitProgressSupport;
import org.netbeans.modules.git.ui.actions.GitAction;
import org.netbeans.modules.git.ui.blame.AnnotateLine;
import org.netbeans.modules.git.ui.blame.AnnotationBar;
import org.netbeans.modules.git.ui.blame.AnnotationBarManager;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.text.NbDocument;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class AnnotateAction
extends GitAction {
    @Override
    protected boolean enable(Node[] nodes) {
        VCSContext context = this.getCurrentContext(nodes);
        if (context.getRootFiles().size() > 0 && this.activatedEditorCookie(nodes) != null) {
            File file;
            FileStatusCache cache = Git.getInstance().getFileStatusCache();
            FileInformation info = cache.getStatus(file = this.activatedFile(nodes));
            return info != null && !info.containsStatus(EnumSet.of(FileInformation.Status.NOTVERSIONED_EXCLUDED, FileInformation.Status.NOTVERSIONED_NOTMANAGED, FileInformation.Status.NEW_HEAD_WORKING_TREE));
        }
        return false;
    }

    @Override
    public String getName() {
        return NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)(this.visible(TopComponent.getRegistry().getActivatedNodes()) ? "CTL_MenuItem_HideAnnotations" : "CTL_MenuItem_ShowAnnotations"));
    }

    protected String iconResource() {
        return "org/netbeans/modules/git/resources/icons/annotate.png";
    }

    @Override
    protected void performContextAction(Node[] nodes) {
        if (this.visible(nodes)) {
            JEditorPane pane = this.activatedEditorPane(nodes);
            AnnotationBarManager.hideAnnotationBar(pane);
        } else {
            EditorCookie ec = this.activatedEditorCookie(nodes);
            if (ec == null) {
                return;
            }
            File file = this.activatedFile(nodes);
            JEditorPane[] panes = ec.getOpenedPanes();
            if (panes == null) {
                ec.open();
                panes = ec.getOpenedPanes();
            }
            if (panes == null) {
                return;
            }
            JEditorPane currentPane = panes[0];
            this.showAnnotations(currentPane, file, null);
        }
    }

    public void showAnnotations(JEditorPane currentPane, final File file, final String revision) {
        if (currentPane == null || file == null) {
            return;
        }
        TopComponent tc = (TopComponent)SwingUtilities.getAncestorOfClass(TopComponent.class, currentPane);
        tc.requestActive();
        final AnnotationBar ab = AnnotationBarManager.showAnnotationBar(currentPane);
        ab.setAnnotationMessage(NbBundle.getMessage(AnnotateAction.class, (String)"CTL_AnnotationSubstitute"));
        File repository = Git.getInstance().getRepositoryRoot(file);
        if (repository == null) {
            return;
        }
        new GitProgressSupport(){

            @Override
            public void perform() {
                if (revision != null) {
                    ab.setReferencedFile(file);
                }
                GitBlameResult result = null;
                try {
                    result = this.getClient().blame(file, revision, this.getProgressMonitor());
                    if (this.isCanceled()) {
                        ab.setAnnotationMessage(NbBundle.getMessage(AnnotateAction.class, (String)"CTL_AnnotationFailed"));
                        return;
                    }
                    AnnotateLine[] lines = AnnotateAction.toAnnotateLines(result);
                    ab.setAnnotatedRevision(revision);
                    ab.annotationLines(file, Arrays.asList(lines));
                }
                catch (GitException ex) {
                    GitClientExceptionHandler.notifyException((Exception)((Object)ex), true);
                }
            }
        }.start(Git.getInstance().getRequestProcessor(repository), repository, NbBundle.getMessage(AnnotateAction.class, (String)"MSG_Annotation_Progress"));
    }

    private static AnnotateLine[] toAnnotateLines(GitBlameResult result) {
        if (result == null) {
            return new AnnotateLine[0];
        }
        ArrayList<AnnotateLine> lines = new ArrayList<AnnotateLine>(result.getLineCount());
        for (int i = 0; i < result.getLineCount(); ++i) {
            lines.add(new AnnotateLine(result.getLineDetails(i), i + 1));
        }
        return lines.toArray(new AnnotateLine[lines.size()]);
    }

    public boolean visible(Node[] nodes) {
        JEditorPane currentPane = this.activatedEditorPane(nodes);
        return AnnotationBarManager.annotationBarVisible(currentPane);
    }

    private JEditorPane activatedEditorPane(Node[] nodes) {
        EditorCookie ec = this.activatedEditorCookie(nodes);
        if (ec != null && EventQueue.isDispatchThread()) {
            return NbDocument.findRecentEditorPane((EditorCookie)ec);
        }
        return null;
    }

    private EditorCookie activatedEditorCookie(Node[] nodes) {
        if (nodes == null) {
            nodes = WindowManager.getDefault().getRegistry().getActivatedNodes();
        }
        if (nodes.length == 1) {
            Node node = nodes[0];
            return (EditorCookie)node.getCookie(EditorCookie.class);
        }
        return null;
    }

    private File activatedFile(Node[] nodes) {
        Node node;
        DataObject dobj;
        if (nodes.length == 1 && (dobj = (DataObject)(node = nodes[0]).getCookie(DataObject.class)) != null) {
            FileObject fo = dobj.getPrimaryFile();
            return FileUtil.toFile((FileObject)fo);
        }
        return null;
    }
}

