/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.client;

import java.io.File;
import java.text.DateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.JComponent;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.progress.FileListener;
import org.netbeans.libs.git.progress.ProgressMonitor;
import org.netbeans.modules.git.Git;
import org.netbeans.modules.git.client.GitClient;
import org.netbeans.modules.git.ui.output.OutputLogger;
import org.openide.util.Cancellable;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public abstract class GitProgressSupport
implements Runnable,
Cancellable {
    private volatile boolean canceled;
    private static final Logger LOG = Logger.getLogger(GitProgressSupport.class.getName());
    private ProgressHandle progressHandle = null;
    private String displayName = "";
    private String originalDisplayName;
    private File repositoryRoot;
    private RequestProcessor.Task task;
    private GitClient gitClient;
    private OutputLogger logger;
    private final ProgressMonitorImpl progressMonitor = new ProgressMonitorImpl();

    public RequestProcessor.Task start(RequestProcessor rp, File repositoryRoot, String displayName) {
        this.originalDisplayName = displayName;
        this.setDisplayName(displayName);
        this.repositoryRoot = repositoryRoot;
        this.startProgress();
        this.setProgressQueued();
        this.task = rp.post((Runnable)this);
        return this.task;
    }

    @Override
    public void run() {
        this.setProgress();
        this.performIntern();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void performIntern() {
        try {
            LOG.log(Level.FINE, "Start - {0}", this.originalDisplayName);
            if (!this.canceled) {
                this.perform();
            }
        }
        finally {
            LOG.log(Level.FINE, "End - {0}", this.originalDisplayName);
            this.finishProgress();
            this.getLogger().closeLog();
        }
    }

    protected abstract void perform();

    public synchronized boolean isCanceled() {
        return this.canceled;
    }

    public synchronized boolean cancel() {
        if (this.canceled) {
            return false;
        }
        if (this.task != null && this.task.cancel()) {
            this.finishProgress();
        }
        this.canceled = true;
        return true;
    }

    public JComponent getProgressComponent() {
        return ProgressHandleFactory.createProgressComponent((ProgressHandle)this.getProgressHandle());
    }

    public RequestProcessor.Task getTask() {
        return this.task;
    }

    protected String getDisplayName() {
        return this.displayName;
    }

    protected void setDisplayName(String displayName) {
        this.displayName = displayName;
        this.setProgress();
    }

    private void setProgressQueued() {
        if (this.progressHandle != null) {
            this.setProgressMessage(this.progressHandle, NbBundle.getMessage(GitProgressSupport.class, (String)"LBL_Queued", (Object)this.displayName));
        }
    }

    private void setProgress() {
        if (this.progressHandle != null) {
            this.setProgressMessage(this.progressHandle, this.displayName);
        }
    }

    protected ProgressHandle getProgressHandle() {
        if (this.progressHandle == null) {
            Action openAction = this.getLogger().getOpenOutputAction();
            this.progressHandle = openAction == null ? ProgressHandleFactory.createHandle((String)this.displayName, (Cancellable)this) : ProgressHandleFactory.createHandle((String)this.displayName, (Cancellable)this, (Action)openAction);
        }
        return this.progressHandle;
    }

    protected void startProgress() {
        this.getProgressHandle().start();
        this.getLogger().output("==[IDE]== " + DateFormat.getDateTimeInstance().format(new Date()) + " " + this.originalDisplayName);
    }

    protected void finishProgress() {
        this.getProgressHandle().finish();
        if (!this.isCanceled()) {
            this.getLogger().output("==[IDE]== " + DateFormat.getDateTimeInstance().format(new Date()) + " " + this.originalDisplayName + " " + NbBundle.getMessage(GitProgressSupport.class, (String)"MSG_Progress_Finished"));
        } else {
            this.getLogger().output("==[IDE]== " + DateFormat.getDateTimeInstance().format(new Date()) + " " + this.originalDisplayName + " " + NbBundle.getMessage(GitProgressSupport.class, (String)"MSG_Progress_Canceled"));
        }
    }

    protected File getRepositoryRoot() {
        return this.repositoryRoot;
    }

    protected void setProgress(String progressMessage) {
        if (this.progressHandle != null) {
            this.setProgressMessage(this.progressHandle, progressMessage == null ? this.displayName : NbBundle.getMessage(GitProgressSupport.class, (String)"LBL_Progress", (Object[])new Object[]{this.displayName, progressMessage}));
        }
    }

    protected GitClient getClient() throws GitException {
        if (this.gitClient == null) {
            this.gitClient = Git.getInstance().getClient(this.repositoryRoot, this);
        }
        return this.gitClient;
    }

    void setRepositoryStateBlocked(File repository, boolean blocked) {
        if (repository == null) {
            throw new IllegalArgumentException("Trying to block/unblock progress on null repository");
        }
        if (blocked) {
            this.setProgress(NbBundle.getMessage(GitProgressSupport.class, (String)"LBL_RepositoryBlocked", (Object)repository.getName()));
        } else {
            this.setProgress();
        }
    }

    public void outputInRed(String message) {
        LOG.log(Level.FINE, message);
        this.getLogger().outputInRed(message);
    }

    public void output(String message) {
        LOG.log(Level.FINE, message);
        this.getLogger().output(message);
    }

    private void setProgressMessage(ProgressHandle progressHandle, String message) {
        LOG.log(Level.FINER, "New status of progress: {0}", message);
        progressHandle.progress(message);
    }

    public OutputLogger getLogger() {
        if (this.logger == null) {
            this.logger = OutputLogger.getLogger(this.repositoryRoot);
        }
        return this.logger;
    }

    public final ProgressMonitor getProgressMonitor() {
        return this.progressMonitor;
    }

    public class DefaultFileListener
    implements FileListener {
        String lastNotified;
        private final File[] roots;

        public DefaultFileListener(File[] roots) {
            this.roots = roots;
        }

        public void notifyFile(File file, String relativePathToRoot) {
            GitProgressSupport.this.getLogger().outputFile(relativePathToRoot, file, 0);
            String directChildPath = this.getDirectChildPath(file, relativePathToRoot);
            if (!directChildPath.isEmpty() && !directChildPath.equals(this.lastNotified)) {
                GitProgressSupport.this.setProgress(GitProgressSupport.this.repositoryRoot.getName() + "/" + directChildPath);
            }
        }

        private String getDirectChildPath(File file, String relativePath) {
            if (this.roots == null || this.roots.length == 0) {
                return relativePath;
            }
            File directChild = null;
            String directChildPath = relativePath;
            while (directChild == null && !directChildPath.isEmpty()) {
                File root;
                File[] arr$ = this.roots;
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$ && (directChild = this.getDirectChild(file, root = arr$[i$])) == null; ++i$) {
                }
                if (directChild != null) continue;
                file = file.getParentFile();
                int pos = directChildPath.lastIndexOf("/");
                if (pos == -1) {
                    if (LOG.isLoggable(Level.INFO)) {
                        LOG.log(Level.WARNING, "Suspicious notified file: {0} - {1} for {2}", new Object[]{file, relativePath, Arrays.asList(this.roots)});
                        LOG.log(Level.INFO, null, new Exception("Suspicious notify call"));
                    }
                    directChildPath = "";
                    continue;
                }
                directChildPath = directChildPath.substring(0, pos);
            }
            return directChildPath;
        }

        private File getDirectChild(File file, File root) {
            return file.equals(root) || root.equals(file.getParentFile()) ? file : null;
        }
    }

    public static abstract class NoOutputLogging
    extends GitProgressSupport {
        OutputLogger logger;

        @Override
        public final OutputLogger getLogger() {
            if (this.logger == null) {
                this.logger = OutputLogger.getLogger(null);
            }
            return this.logger;
        }
    }

    private final class ProgressMonitorImpl
    extends ProgressMonitor {
        private ProgressMonitorImpl() {
        }

        public boolean isCanceled() {
            return GitProgressSupport.this.isCanceled();
        }

        public void started(String command) {
            LOG.log(Level.FINE, "command started: {0}", command);
            GitProgressSupport.this.getLogger().output(command);
        }

        public void finished() {
            LOG.log(Level.FINE, "command finished");
        }

        public void preparationsFailed(String message) {
            LOG.log(Level.FINE, "command could not start: {0}", message);
            GitProgressSupport.this.getLogger().output("command could not start: " + message);
        }

        public void notifyError(String message) {
            LOG.log(Level.FINE, "error: {0}", message);
            GitProgressSupport.this.getLogger().output("error: " + message);
        }

        public void notifyWarning(String message) {
            LOG.log(Level.FINE, "warning: {0}", message);
            GitProgressSupport.this.getLogger().output("warning: " + message);
        }
    }
}

