/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.client;

import java.io.File;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.libs.git.GitBlameResult;
import org.netbeans.libs.git.GitBranch;
import org.netbeans.libs.git.GitClient;
import org.netbeans.libs.git.GitClientCallback;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.GitMergeResult;
import org.netbeans.libs.git.GitPullResult;
import org.netbeans.libs.git.GitPushResult;
import org.netbeans.libs.git.GitRemoteConfig;
import org.netbeans.libs.git.GitRepository;
import org.netbeans.libs.git.GitRepositoryState;
import org.netbeans.libs.git.GitRevertResult;
import org.netbeans.libs.git.GitRevisionInfo;
import org.netbeans.libs.git.GitStatus;
import org.netbeans.libs.git.GitTag;
import org.netbeans.libs.git.GitTransportUpdate;
import org.netbeans.libs.git.GitUser;
import org.netbeans.libs.git.SearchCriteria;
import org.netbeans.libs.git.progress.NotificationListener;
import org.netbeans.libs.git.progress.ProgressMonitor;
import org.netbeans.modules.git.Git;
import org.netbeans.modules.git.client.GitCanceledException;
import org.netbeans.modules.git.client.GitClientExceptionHandler;
import org.netbeans.modules.git.client.GitProgressSupport;
import org.netbeans.modules.git.ui.repository.RepositoryInfo;
import org.netbeans.modules.versioning.util.IndexingBridge;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.util.NetworkSettings;

public final class GitClient {
    private final org.netbeans.libs.git.GitClient delegate;
    private final GitProgressSupport progressSupport;
    private final boolean handleAuthenticationIssues;
    private static final HashSet<String> PARALLELIZABLE_COMMANDS = new HashSet<String>(Arrays.asList("addNotificationListener", "blame", "catFile", "catIndexEntry", "exportCommit", "exportDiff", "getBranches", "getCommonAncestor", "getConflicts", "getPreviousRevision", "getStatus", "getTags", "getRemote", "getRemotes", "getRepositoryState", "getUser", "listModifiedIndexEntries", "listRemoteBranches", "listRemoteTags", "log", "removeNotificationListener", "removeRemote", "setCallback", "setRemote"));
    private static final HashSet<String> INDEXING_BRIDGE_COMMANDS = new HashSet<String>(Arrays.asList("checkout", "checkout", "checkoutRevision", "merge", "pull", "remove", "reset", "revert", "clean"));
    private static final HashSet<String> WORKING_TREE_READ_ONLY_COMMANDS = new HashSet<String>(Arrays.asList("addNotificationListener", "blame", "catFile", "catIndexEntry", "createBranch", "createTag", "deleteBranch", "deleteTag", "fetch", "exportCommit", "exportDiff", "getBranches", "getCommonAncestor", "getConflicts", "getPreviousRevision", "getStatus", "getRemote", "getRemotes", "getRepositoryState", "getTags", "getUser", "ignore", "listModifiedIndexEntries", "listRemoteBranches", "listRemoteTags", "log", "unignore", "push", "removeNotificationListener", "removeRemote", "setCallback", "setRemote"));
    private static final HashSet<String> NEED_REPOSITORY_REFRESH_COMMANDS = new HashSet<String>(Arrays.asList("add", "checkout", "checkoutRevision", "commit", "createBranch", "createTag", "deleteBranch", "deleteTag", "fetch", "merge", "pull", "remove", "reset", "removeRemote", "revert", "setRemote"));
    private static final HashSet<String> NETWORK_COMMANDS = new HashSet<String>(Arrays.asList("fetch", "listRemoteBranches", "listRemoteTags", "pull", "push"));
    private static final Logger LOG = Logger.getLogger(GitClient.class.getName());
    private final File repositoryRoot;

    public GitClient(File repository, GitProgressSupport progressSupport, boolean handleAuthenticationIssues) throws GitException {
        this.repositoryRoot = repository;
        this.delegate = GitRepository.getInstance((File)repository).createClient();
        this.progressSupport = progressSupport;
        this.handleAuthenticationIssues = handleAuthenticationIssues;
    }

    public void add(final File[] roots, final ProgressMonitor monitor) throws GitException {
        new CommandInvoker().runMethod(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                GitClient.this.delegate.add(roots, monitor);
                return null;
            }
        }, "add", roots);
    }

    public void addNotificationListener(NotificationListener listener) {
        this.delegate.addNotificationListener(listener);
    }

    public GitBlameResult blame(final File file, final String revision, final ProgressMonitor monitor) throws GitException.MissingObjectException, GitException {
        return (GitBlameResult)new CommandInvoker().runMethod(new Callable<GitBlameResult>(){

            @Override
            public GitBlameResult call() throws Exception {
                return GitClient.this.delegate.blame(file, revision, monitor);
            }
        }, "blame");
    }

    public boolean catFile(final File file, final String revision, final OutputStream out, final ProgressMonitor monitor) throws GitException.MissingObjectException, GitException {
        return (Boolean)new CommandInvoker().runMethod(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return GitClient.this.delegate.catFile(file, revision, out, monitor);
            }
        }, "catFile");
    }

    public boolean catIndexEntry(final File file, final int stage, final OutputStream out, final ProgressMonitor monitor) throws GitException {
        return (Boolean)new CommandInvoker().runMethod(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return GitClient.this.delegate.catIndexEntry(file, stage, out, monitor);
            }
        }, "catIndexEntry");
    }

    public void checkout(final File[] roots, final String revision, final boolean recursively, final ProgressMonitor monitor) throws GitException.MissingObjectException, GitException {
        new CommandInvoker().runMethod(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                GitClient.this.delegate.checkout(roots, revision, recursively, monitor);
                return null;
            }
        }, "checkout", roots);
    }

    public void checkoutRevision(final String revision, final boolean failOnConflict, final ProgressMonitor monitor) throws GitException.MissingObjectException, GitException {
        new CommandInvoker().runMethod(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                GitClient.this.delegate.checkoutRevision(revision, failOnConflict, monitor);
                return null;
            }
        }, "checkoutRevision", new File[]{this.repositoryRoot});
    }

    public void clean(final File[] roots, final ProgressMonitor monitor) throws GitException {
        new CommandInvoker().runMethod(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                GitClient.this.delegate.clean(roots, monitor);
                return null;
            }
        }, "clean", roots);
    }

    public GitRevisionInfo commit(final File[] roots, final String commitMessage, final GitUser author, final GitUser commiter, final ProgressMonitor monitor) throws GitException {
        return (GitRevisionInfo)new CommandInvoker().runMethod(new Callable<GitRevisionInfo>(){

            @Override
            public GitRevisionInfo call() throws Exception {
                return GitClient.this.delegate.commit(roots, commitMessage, author, commiter, monitor);
            }
        }, "commit", roots);
    }

    public void copyAfter(final File source, final File target, final ProgressMonitor monitor) throws GitException {
        new CommandInvoker().runMethod(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                GitClient.this.delegate.copyAfter(source, target, monitor);
                return null;
            }
        }, "copyAfter", new File[]{target});
    }

    public GitBranch createBranch(final String branchName, final String revision, final ProgressMonitor monitor) throws GitException {
        return (GitBranch)new CommandInvoker().runMethod(new Callable<GitBranch>(){

            @Override
            public GitBranch call() throws Exception {
                return GitClient.this.delegate.createBranch(branchName, revision, monitor);
            }
        }, "createBranch");
    }

    public GitTag createTag(final String tagName, final String taggedObject, final String message, final boolean signed, final boolean forceUpdate, final ProgressMonitor monitor) throws GitException {
        return (GitTag)new CommandInvoker().runMethod(new Callable<GitTag>(){

            @Override
            public GitTag call() throws Exception {
                return GitClient.this.delegate.createTag(tagName, taggedObject, message, signed, forceUpdate, monitor);
            }
        }, "createTag");
    }

    public void deleteBranch(final String branchName, final boolean forceDeleteUnmerged, final ProgressMonitor monitor) throws GitException.NotMergedException, GitException {
        new CommandInvoker().runMethod(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                GitClient.this.delegate.deleteBranch(branchName, forceDeleteUnmerged, monitor);
                return null;
            }
        }, "deleteBranch");
    }

    public void deleteTag(final String tagName, final ProgressMonitor monitor) throws GitException {
        new CommandInvoker().runMethod(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                GitClient.this.delegate.deleteTag(tagName, monitor);
                return null;
            }
        }, "deleteTag");
    }

    public void exportCommit(final String commit, final OutputStream out, final ProgressMonitor monitor) throws GitException {
        new CommandInvoker().runMethod(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                GitClient.this.delegate.exportCommit(commit, out, monitor);
                return null;
            }
        }, "exportCommit");
    }

    public void exportDiff(final File[] roots, final GitClient.DiffMode mode, final OutputStream out, final ProgressMonitor monitor) throws GitException {
        new CommandInvoker().runMethod(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                GitClient.this.delegate.exportDiff(roots, mode, out, monitor);
                return null;
            }
        }, "exportDiff", roots);
    }

    public Map<String, GitTransportUpdate> fetch(final String remote, final ProgressMonitor monitor) throws GitException.AuthorizationException, GitException {
        return (Map)new CommandInvoker().runMethod(new Callable<Map<String, GitTransportUpdate>>(){

            @Override
            public Map<String, GitTransportUpdate> call() throws Exception {
                return GitClient.this.delegate.fetch(remote, monitor);
            }
        }, "fetch");
    }

    public Map<String, GitTransportUpdate> fetch(final String remote, final List<String> fetchRefSpecifications, final ProgressMonitor monitor) throws GitException.AuthorizationException, GitException {
        return (Map)new CommandInvoker().runMethod(new Callable<Map<String, GitTransportUpdate>>(){

            @Override
            public Map<String, GitTransportUpdate> call() throws Exception {
                return GitClient.this.delegate.fetch(remote, fetchRefSpecifications, monitor);
            }
        }, "fetch");
    }

    public Map<String, GitBranch> getBranches(final boolean all, final ProgressMonitor monitor) throws GitException {
        return (Map)new CommandInvoker().runMethod(new Callable<Map<String, GitBranch>>(){

            @Override
            public Map<String, GitBranch> call() throws Exception {
                return GitClient.this.delegate.getBranches(all, monitor);
            }
        }, "getBranches");
    }

    public Map<String, GitTag> getTags(final ProgressMonitor monitor, final boolean allTags) throws GitException {
        return (Map)new CommandInvoker().runMethod(new Callable<Map<String, GitTag>>(){

            @Override
            public Map<String, GitTag> call() throws Exception {
                return GitClient.this.delegate.getTags(monitor, allTags);
            }
        }, "getTags");
    }

    public GitRevisionInfo getCommonAncestor(final String[] revisions, final ProgressMonitor monitor) throws GitException {
        return (GitRevisionInfo)new CommandInvoker().runMethod(new Callable<GitRevisionInfo>(){

            @Override
            public GitRevisionInfo call() throws Exception {
                return GitClient.this.delegate.getCommonAncestor(revisions, monitor);
            }
        }, "getCommonAncestor");
    }

    public GitRevisionInfo getPreviousRevision(final File file, final String revision, final ProgressMonitor monitor) throws GitException {
        return (GitRevisionInfo)new CommandInvoker().runMethod(new Callable<GitRevisionInfo>(){

            @Override
            public GitRevisionInfo call() throws Exception {
                return GitClient.this.delegate.getPreviousRevision(file, revision, monitor);
            }
        }, "getPreviousRevision");
    }

    public Map<File, GitStatus> getConflicts(final File[] roots, final ProgressMonitor monitor) throws GitException {
        return (Map)new CommandInvoker().runMethod(new Callable<Map<File, GitStatus>>(){

            @Override
            public Map<File, GitStatus> call() throws Exception {
                return GitClient.this.delegate.getConflicts(roots, monitor);
            }
        }, "getConflicts", roots);
    }

    public Map<File, GitStatus> getStatus(final File[] roots, final ProgressMonitor monitor) throws GitException {
        return (Map)new CommandInvoker().runMethod(new Callable<Map<File, GitStatus>>(){

            @Override
            public Map<File, GitStatus> call() throws Exception {
                return GitClient.this.delegate.getStatus(roots, monitor);
            }
        }, "getStatus", roots);
    }

    public GitRemoteConfig getRemote(final String remoteName, final ProgressMonitor monitor) throws GitException {
        return (GitRemoteConfig)new CommandInvoker().runMethod(new Callable<GitRemoteConfig>(){

            @Override
            public GitRemoteConfig call() throws Exception {
                return GitClient.this.delegate.getRemote(remoteName, monitor);
            }
        }, "getRemote");
    }

    public Map<String, GitRemoteConfig> getRemotes(final ProgressMonitor monitor) throws GitException {
        return (Map)new CommandInvoker().runMethod(new Callable<Map<String, GitRemoteConfig>>(){

            @Override
            public Map<String, GitRemoteConfig> call() throws Exception {
                return GitClient.this.delegate.getRemotes(monitor);
            }
        }, "getRemotes");
    }

    public GitRepositoryState getRepositoryState(final ProgressMonitor monitor) throws GitException {
        return (GitRepositoryState)new CommandInvoker().runMethod(new Callable<GitRepositoryState>(){

            @Override
            public GitRepositoryState call() throws Exception {
                return GitClient.this.delegate.getRepositoryState(monitor);
            }
        }, "getRepositoryState");
    }

    public GitUser getUser() throws GitException {
        return (GitUser)new CommandInvoker().runMethod(new Callable<GitUser>(){

            @Override
            public GitUser call() throws Exception {
                return GitClient.this.delegate.getUser();
            }
        }, "getUser");
    }

    public File[] ignore(final File[] files, final ProgressMonitor monitor) throws GitException {
        return (File[])new CommandInvoker().runMethod(new Callable<File[]>(){

            @Override
            public File[] call() throws Exception {
                return GitClient.this.delegate.ignore(files, monitor);
            }
        }, "ignore", files);
    }

    public void init(final ProgressMonitor monitor) throws GitException {
        new CommandInvoker().runMethod(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                GitClient.this.delegate.init(monitor);
                return null;
            }
        }, "init");
    }

    public File[] listModifiedIndexEntries(final File[] roots, final ProgressMonitor monitor) throws GitException {
        return (File[])new CommandInvoker().runMethod(new Callable<File[]>(){

            @Override
            public File[] call() throws Exception {
                return GitClient.this.delegate.listModifiedIndexEntries(roots, monitor);
            }
        }, "listModifiedIndexEntries", roots);
    }

    public Map<String, GitBranch> listRemoteBranches(final String remoteRepositoryUrl, final ProgressMonitor monitor) throws GitException.AuthorizationException, GitException {
        return (Map)new CommandInvoker().runMethod(new Callable<Map<String, GitBranch>>(){

            @Override
            public Map<String, GitBranch> call() throws Exception {
                return GitClient.this.delegate.listRemoteBranches(remoteRepositoryUrl, monitor);
            }
        }, "listRemoteBranches");
    }

    public Map<String, String> listRemoteTags(final String remoteRepositoryUrl, final ProgressMonitor monitor) throws GitException.AuthorizationException, GitException {
        return (Map)new CommandInvoker().runMethod(new Callable<Map<String, String>>(){

            @Override
            public Map<String, String> call() throws Exception {
                return GitClient.this.delegate.listRemoteTags(remoteRepositoryUrl, monitor);
            }
        }, "listRemoteTags");
    }

    public GitRevisionInfo log(final String revision, final ProgressMonitor monitor) throws GitException.MissingObjectException, GitException {
        return (GitRevisionInfo)new CommandInvoker().runMethod(new Callable<GitRevisionInfo>(){

            @Override
            public GitRevisionInfo call() throws Exception {
                return GitClient.this.delegate.log(revision, monitor);
            }
        }, "log");
    }

    public GitRevisionInfo[] log(final SearchCriteria searchCriteria, final ProgressMonitor monitor) throws GitException.MissingObjectException, GitException {
        return (GitRevisionInfo[])new CommandInvoker().runMethod(new Callable<GitRevisionInfo[]>(){

            @Override
            public GitRevisionInfo[] call() throws Exception {
                return GitClient.this.delegate.log(searchCriteria, monitor);
            }
        }, "log");
    }

    public GitMergeResult merge(final String revision, final ProgressMonitor monitor) throws GitException.CheckoutConflictException, GitException {
        return (GitMergeResult)new CommandInvoker().runMethod(new Callable<GitMergeResult>(){

            @Override
            public GitMergeResult call() throws Exception {
                return GitClient.this.delegate.merge(revision, monitor);
            }
        }, "merge");
    }

    public GitPullResult pull(final String remote, final List<String> fetchRefSpecifications, final String branchToMerge, final ProgressMonitor monitor) throws GitException.AuthorizationException, GitException.CheckoutConflictException, GitException.MissingObjectException, GitException {
        return (GitPullResult)new CommandInvoker().runMethod(new Callable<GitPullResult>(){

            @Override
            public GitPullResult call() throws Exception {
                return GitClient.this.delegate.pull(remote, fetchRefSpecifications, branchToMerge, monitor);
            }
        }, "pull");
    }

    public GitPushResult push(final String remote, final List<String> pushRefSpecifications, final List<String> fetchRefSpecifications, final ProgressMonitor monitor) throws GitException.AuthorizationException, GitException {
        return (GitPushResult)new CommandInvoker().runMethod(new Callable<GitPushResult>(){

            @Override
            public GitPushResult call() throws Exception {
                return GitClient.this.delegate.push(remote, pushRefSpecifications, fetchRefSpecifications, monitor);
            }
        }, "push");
    }

    public void remove(final File[] roots, final boolean cached, final ProgressMonitor monitor) throws GitException {
        new CommandInvoker().runMethod(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                GitClient.this.delegate.remove(roots, cached, monitor);
                return null;
            }
        }, "remove", roots);
    }

    public void removeNotificationListener(NotificationListener listener) {
        this.delegate.removeNotificationListener(listener);
    }

    public void removeRemote(final String remote, final ProgressMonitor monitor) throws GitException {
        new CommandInvoker().runMethod(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                GitClient.this.delegate.removeRemote(remote, monitor);
                return null;
            }
        }, "removeRemote");
    }

    public void rename(final File source, final File target, final boolean after, final ProgressMonitor monitor) throws GitException {
        new CommandInvoker().runMethod(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                GitClient.this.delegate.rename(source, target, after, monitor);
                return null;
            }
        }, "rename", new File[]{source, target});
    }

    public void reset(final File[] roots, final String revision, final boolean recursively, final ProgressMonitor monitor) throws GitException.MissingObjectException, GitException {
        new CommandInvoker().runMethod(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                GitClient.this.delegate.reset(roots, revision, recursively, monitor);
                return null;
            }
        }, "reset", roots);
    }

    public void reset(final String revision, final GitClient.ResetType resetType, final ProgressMonitor monitor) throws GitException.MissingObjectException, GitException {
        new CommandInvoker().runMethod(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                GitClient.this.delegate.reset(revision, resetType, monitor);
                return null;
            }
        }, "reset");
    }

    public GitRevertResult revert(final String revision, final String commitMessage, final boolean commit, final ProgressMonitor monitor) throws GitException.MissingObjectException, GitException.CheckoutConflictException, GitException {
        return (GitRevertResult)new CommandInvoker().runMethod(new Callable<GitRevertResult>(){

            @Override
            public GitRevertResult call() throws Exception {
                return GitClient.this.delegate.revert(revision, commitMessage, commit, monitor);
            }
        }, "revert");
    }

    public void setCallback(GitClientCallback callback) {
        this.delegate.setCallback(callback);
    }

    public void setRemote(final GitRemoteConfig remoteConfig, final ProgressMonitor monitor) throws GitException {
        new CommandInvoker().runMethod(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                GitClient.this.delegate.setRemote(remoteConfig, monitor);
                return null;
            }
        }, "setRemote");
    }

    public File[] unignore(final File[] files, final ProgressMonitor monitor) throws GitException {
        return (File[])new CommandInvoker().runMethod(new Callable<File[]>(){

            @Override
            public File[] call() throws Exception {
                return GitClient.this.delegate.unignore(files, monitor);
            }
        }, "unignore");
    }

    private static boolean isExclusiveRepositoryAccess(String commandName) {
        return !PARALLELIZABLE_COMMANDS.contains(commandName);
    }

    private static boolean runsWithBlockedIndexing(String commandName) {
        return INDEXING_BRIDGE_COMMANDS.contains(commandName);
    }

    private static boolean modifiesWorkingTree(String commandName) {
        return !WORKING_TREE_READ_ONLY_COMMANDS.contains(commandName);
    }

    private static boolean withoutAuthenticator(String commandName) {
        return NETWORK_COMMANDS.contains(commandName);
    }

    private final class CommandInvoker {
        private CommandInvoker() {
        }

        private <T> T runMethod(Callable<T> callable, String methodName) throws GitException {
            return this.runMethod(callable, methodName, new File[0]);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private <T> T runMethod(Callable<T> callable, String methodName, File[] roots) throws GitException {
            try {
                if (GitClient.isExclusiveRepositoryAccess(methodName)) {
                    LOG.log(Level.FINER, "Running an exclusive command: {0} on {1}", new Object[]{methodName, GitClient.this.repositoryRoot});
                    if (GitClient.this.progressSupport != null) {
                        GitClient.this.progressSupport.setRepositoryStateBlocked(GitClient.this.repositoryRoot, true);
                    }
                    File file = GitClient.this.repositoryRoot;
                    synchronized (file) {
                        if (Thread.interrupted()) {
                            throw new InterruptedException();
                        }
                        if (GitClient.this.progressSupport != null) {
                            LOG.log(Level.FINEST, "Repository unblocked: {0}", GitClient.this.repositoryRoot);
                            GitClient.this.progressSupport.setRepositoryStateBlocked(GitClient.this.repositoryRoot, false);
                        }
                        return this.runMethodIntern(callable, methodName, roots);
                    }
                }
                LOG.log(Level.FINER, "Running a parallelizable command: {0} on {1}", new Object[]{methodName, GitClient.this.repositoryRoot.getAbsolutePath()});
                return this.runMethodIntern(callable, methodName, roots);
            }
            catch (InterruptedException ex) {
                throw new GitCanceledException(ex);
            }
            catch (GitException ex) {
                throw ex;
            }
            catch (Throwable ex) {
                if (ex instanceof RuntimeException) {
                    throw (RuntimeException)ex;
                }
                if (ex.getCause() != null) {
                    throw new GitException(ex.getCause());
                }
                throw new GitException(ex);
            }
        }

        private <T> T runMethodIntern(final Callable<T> toRun, final String methodName, File[] roots) throws Throwable {
            try {
                Utils.logVCSClientEvent((String)"GIT", (String)"JAVALIB");
                Callable callable = new Callable<T>(){

                    @Override
                    public T call() throws Exception {
                        Object v;
                        boolean repositoryInfoRefreshNeeded;
                        boolean refreshIndexTimestamp;
                        block18: {
                            long t;
                            block16: {
                                Object object;
                                block17: {
                                    refreshIndexTimestamp = GitClient.modifiesWorkingTree(methodName);
                                    repositoryInfoRefreshNeeded = NEED_REPOSITORY_REFRESH_COMMANDS.contains(methodName);
                                    t = 0L;
                                    if (LOG.isLoggable(Level.FINE)) {
                                        t = System.currentTimeMillis();
                                        LOG.log(Level.FINE, "Starting a git command: [{0}] on repository [{1}]", new Object[]{methodName, GitClient.this.repositoryRoot.getAbsolutePath()});
                                    }
                                    if (!GitClient.withoutAuthenticator(methodName)) break block16;
                                    object = NetworkSettings.suppressAuthenticationDialog((Callable)toRun);
                                    if (!LOG.isLoggable(Level.FINE)) break block17;
                                    LOG.log(Level.FINE, "Git command finished: [{0}] on repository [{1}], lasted {2} ms", new Object[]{methodName, GitClient.this.repositoryRoot.getAbsolutePath(), System.currentTimeMillis() - t});
                                }
                                if (refreshIndexTimestamp) {
                                    LOG.log(Level.FINER, "Refreshing index timestamp after: {0} on {1}", new Object[]{methodName, GitClient.this.repositoryRoot.getAbsolutePath()});
                                    Git.getInstance().refreshWorkingCopyTimestamp(GitClient.this.repositoryRoot);
                                }
                                if (repositoryInfoRefreshNeeded) {
                                    LOG.log(Level.FINER, "Refreshing repository info after: {0} on {1}", new Object[]{methodName, GitClient.this.repositoryRoot.getAbsolutePath()});
                                    RepositoryInfo.refreshAsync(GitClient.this.repositoryRoot);
                                }
                                return object;
                            }
                            try {
                                v = toRun.call();
                                if (!LOG.isLoggable(Level.FINE)) break block18;
                            }
                            catch (Exception ex) {
                                block19: {
                                    Object t2;
                                    block20: {
                                        try {
                                            if (GitClient.this.progressSupport != null && GitClient.this.progressSupport.isCanceled() || !new GitClientExceptionHandler(GitClient.this, GitClient.this.handleAuthenticationIssues).handleException(ex)) break block19;
                                            t2 = this.call();
                                            if (!LOG.isLoggable(Level.FINE)) break block20;
                                        }
                                        catch (Throwable throwable) {
                                            if (LOG.isLoggable(Level.FINE)) {
                                                LOG.log(Level.FINE, "Git command finished: [{0}] on repository [{1}], lasted {2} ms", new Object[]{methodName, GitClient.this.repositoryRoot.getAbsolutePath(), System.currentTimeMillis() - t});
                                            }
                                            if (refreshIndexTimestamp) {
                                                LOG.log(Level.FINER, "Refreshing index timestamp after: {0} on {1}", new Object[]{methodName, GitClient.this.repositoryRoot.getAbsolutePath()});
                                                Git.getInstance().refreshWorkingCopyTimestamp(GitClient.this.repositoryRoot);
                                            }
                                            if (repositoryInfoRefreshNeeded) {
                                                LOG.log(Level.FINER, "Refreshing repository info after: {0} on {1}", new Object[]{methodName, GitClient.this.repositoryRoot.getAbsolutePath()});
                                                RepositoryInfo.refreshAsync(GitClient.this.repositoryRoot);
                                            }
                                            throw throwable;
                                        }
                                        LOG.log(Level.FINE, "Git command finished: [{0}] on repository [{1}], lasted {2} ms", new Object[]{methodName, GitClient.this.repositoryRoot.getAbsolutePath(), System.currentTimeMillis() - t});
                                    }
                                    if (refreshIndexTimestamp) {
                                        LOG.log(Level.FINER, "Refreshing index timestamp after: {0} on {1}", new Object[]{methodName, GitClient.this.repositoryRoot.getAbsolutePath()});
                                        Git.getInstance().refreshWorkingCopyTimestamp(GitClient.this.repositoryRoot);
                                    }
                                    if (repositoryInfoRefreshNeeded) {
                                        LOG.log(Level.FINER, "Refreshing repository info after: {0} on {1}", new Object[]{methodName, GitClient.this.repositoryRoot.getAbsolutePath()});
                                        RepositoryInfo.refreshAsync(GitClient.this.repositoryRoot);
                                    }
                                    return t2;
                                }
                                throw ex;
                            }
                            LOG.log(Level.FINE, "Git command finished: [{0}] on repository [{1}], lasted {2} ms", new Object[]{methodName, GitClient.this.repositoryRoot.getAbsolutePath(), System.currentTimeMillis() - t});
                        }
                        if (refreshIndexTimestamp) {
                            LOG.log(Level.FINER, "Refreshing index timestamp after: {0} on {1}", new Object[]{methodName, GitClient.this.repositoryRoot.getAbsolutePath()});
                            Git.getInstance().refreshWorkingCopyTimestamp(GitClient.this.repositoryRoot);
                        }
                        if (repositoryInfoRefreshNeeded) {
                            LOG.log(Level.FINER, "Refreshing repository info after: {0} on {1}", new Object[]{methodName, GitClient.this.repositoryRoot.getAbsolutePath()});
                            RepositoryInfo.refreshAsync(GitClient.this.repositoryRoot);
                        }
                        return v;
                    }
                };
                if (GitClient.runsWithBlockedIndexing(methodName)) {
                    File[] fileArray;
                    LOG.log(Level.FINER, "Running command in indexing bridge: {0} on {1}", new Object[]{methodName, GitClient.this.repositoryRoot.getAbsolutePath()});
                    IndexingBridge indexingBridge = IndexingBridge.getInstance();
                    if (roots.length > 0) {
                        fileArray = roots;
                    } else {
                        File[] fileArray2 = new File[1];
                        fileArray = fileArray2;
                        fileArray2[0] = GitClient.this.repositoryRoot;
                    }
                    return (T)indexingBridge.runWithoutIndexing(callable, fileArray);
                }
                return (T)callable.call();
            }
            catch (InvocationTargetException ex) {
                if (ex.getCause() != null) {
                    throw ex.getCause();
                }
                throw ex;
            }
        }
    }
}

