/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.GitRevisionInfo;
import org.netbeans.libs.git.SearchCriteria;
import org.netbeans.libs.git.progress.ProgressMonitor;
import org.netbeans.modules.git.Git;
import org.netbeans.modules.git.client.GitClient;
import org.netbeans.modules.git.client.GitProgressSupport;
import org.netbeans.modules.git.utils.GitUtils;
import org.openide.util.NbBundle;

public class HistoryRegistry {
    private static HistoryRegistry instance;
    private static final Logger LOG;
    private Map<File, List<GitRevisionInfo>> logs = new HashMap<File, List<GitRevisionInfo>>();
    private Map<File, Map<String, List<GitRevisionInfo.GitFileInfo>>> changesets = new HashMap<File, Map<String, List<GitRevisionInfo.GitFileInfo>>>();

    private HistoryRegistry() {
    }

    public static synchronized HistoryRegistry getInstance() {
        if (instance == null) {
            instance = new HistoryRegistry();
        }
        return instance;
    }

    public GitRevisionInfo[] getLogs(File repository, File[] files, Date from, Date to, ProgressMonitor pm) throws GitException {
        GitClient client = Git.getInstance().getClient(repository);
        SearchCriteria crit = new SearchCriteria();
        crit.setFrom(from);
        crit.setTo(to);
        crit.setFiles(files);
        crit.setFollowRenames(true);
        crit.setIncludeMerges(false);
        GitRevisionInfo[] history = client.log(crit, pm);
        if (!pm.isCanceled() && history.length > 0) {
            for (File f : files) {
                this.logs.put(f, Arrays.asList(history));
            }
        }
        return history;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized File getHistoryFile(final File repository, final File originalFile, final String revision, final boolean dryTry) {
        File file;
        block8: {
            String originalPath;
            long t;
            block6: {
                block7: {
                    t = System.currentTimeMillis();
                    originalPath = GitUtils.getRelativePath(repository, originalFile);
                    try {
                        final List<GitRevisionInfo> history = this.logs.get(originalFile);
                        final String path = originalPath;
                        Map<String, List<GitRevisionInfo.GitFileInfo>> fileChangesets = this.changesets.get(originalFile);
                        if (fileChangesets == null) {
                            fileChangesets = new HashMap<String, List<GitRevisionInfo.GitFileInfo>>();
                            this.changesets.put(originalFile, fileChangesets);
                        }
                        final Map<String, List<GitRevisionInfo.GitFileInfo>> fcs = fileChangesets;
                        final String[] ret = new String[]{null};
                        if (history != null) {
                            GitProgressSupport support = new GitProgressSupport(){

                                @Override
                                protected void perform() {
                                    ret[0] = HistoryRegistry.this.getRepositoryPathIntern(history, revision, fcs, repository, originalFile, path, dryTry, this.getProgressHandle(), this.getProgressMonitor());
                                }
                            };
                            support.start(Git.getInstance().getRequestProcessor(repository), repository, NbBundle.getMessage(HistoryRegistry.class, (String)"LBL_LookingUp")).waitFinished();
                        }
                        if (ret[0] == null || ret[0].equals(originalPath)) break block6;
                        file = new File(repository, ret[0]);
                        if (!LOG.isLoggable(Level.FINE)) break block7;
                    }
                    catch (Throwable throwable) {
                        if (LOG.isLoggable(Level.FINE)) {
                            LOG.log(Level.FINE, " resolving historyFile for {0} took {1}", new Object[]{originalPath, System.currentTimeMillis() - t});
                        }
                        throw throwable;
                    }
                    LOG.log(Level.FINE, " resolving historyFile for {0} took {1}", new Object[]{originalPath, System.currentTimeMillis() - t});
                }
                return file;
            }
            file = null;
            if (!LOG.isLoggable(Level.FINE)) break block8;
            LOG.log(Level.FINE, " resolving historyFile for {0} took {1}", new Object[]{originalPath, System.currentTimeMillis() - t});
        }
        return file;
    }

    private String getRepositoryPathIntern(List<GitRevisionInfo> history, String revision, Map<String, List<GitRevisionInfo.GitFileInfo>> fileChangesets, File repository, File originalFile, String path, boolean dryTry, ProgressHandle progressHandle, ProgressMonitor pm) {
        GitRevisionInfo lm;
        String historyRevision;
        int count = 0;
        String historyPath = path;
        Iterator<GitRevisionInfo> it = history.iterator();
        while (it.hasNext() && !revision.equals(it.next().getRevision())) {
            ++count;
        }
        progressHandle.switchToDeterminate(count);
        block3: for (int i = 0; i < history.size() && !pm.isCanceled() && !(historyRevision = (lm = history.get(i)).getRevision()).equals(revision); ++i) {
            progressHandle.progress(NbBundle.getMessage(HistoryRegistry.class, (String)"LBL_LookingUpAtRevision", (Object)originalFile.getName(), (Object)historyRevision), i);
            List<Object> changePaths = fileChangesets.get(historyRevision);
            if (changePaths == null && !dryTry) {
                long t1 = System.currentTimeMillis();
                Map cps = null;
                try {
                    GitClient client = Git.getInstance().getClient(repository);
                    GitRevisionInfo lms = client.log(historyRevision, pm);
                    assert (lms != null);
                    cps = lms.getModifiedFiles();
                }
                catch (GitException ex) {
                    LOG.log(Level.INFO, null, ex);
                }
                changePaths = cps == null ? Collections.emptyList() : new ArrayList(cps.values());
                fileChangesets.put(historyRevision, changePaths);
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.log(Level.FINE, " loading changePaths for {0} took {1}", new Object[]{historyRevision, System.currentTimeMillis() - t1});
                }
            }
            if (changePaths == null) continue;
            for (GitRevisionInfo.GitFileInfo cp : changePaths) {
                String copy = cp.getOriginalPath();
                if (copy == null || !historyPath.equals(cp.getRelativePath())) continue;
                historyPath = copy;
                continue block3;
            }
        }
        return pm.isCanceled() ? path : historyPath;
    }

    static {
        LOG = Logger.getLogger("org.netbeans.modules.mercurial.HistoryRegistry");
    }
}

