/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.libs.git.GitException;
import org.netbeans.modules.git.Annotator;
import org.netbeans.modules.git.FileStatusCache;
import org.netbeans.modules.git.FilesystemInterceptor;
import org.netbeans.modules.git.GitVCS;
import org.netbeans.modules.git.HistoryProvider;
import org.netbeans.modules.git.ModuleLifecycleManager;
import org.netbeans.modules.git.client.CredentialsCallback;
import org.netbeans.modules.git.client.GitClient;
import org.netbeans.modules.git.client.GitProgressSupport;
import org.netbeans.modules.git.utils.GitUtils;
import org.netbeans.modules.versioning.spi.VCSAnnotator;
import org.netbeans.modules.versioning.spi.VersioningSupport;
import org.netbeans.modules.versioning.util.RootsToFile;
import org.netbeans.modules.versioning.util.Utils;
import org.netbeans.modules.versioning.util.VCSHyperlinkProvider;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;

public final class Git {
    private static Git instance;
    private Annotator annotator;
    private FilesystemInterceptor interceptor;
    public static final Logger LOG;
    public static final Logger STATUS_LOG;
    private final PropertyChangeSupport support = new PropertyChangeSupport(this);
    private FileStatusCache fileStatusCache;
    private HashMap<File, RequestProcessor> processorsToUrl;
    public static final String PROP_ANNOTATIONS_CHANGED = "annotationsChanged";
    static final String PROP_VERSIONED_FILES_CHANGED = "versionedFilesChanged";
    private RootsToFile rootsToFile;
    private GitVCS gitVCS;
    private Lookup.Result<? extends VCSHyperlinkProvider> hpResult;
    private HistoryProvider historyProvider;
    private Set<File> knownRoots = Collections.synchronizedSet(new HashSet());
    private final Set<File> unversionedParents = Collections.synchronizedSet(new HashSet(20));

    private Git() {
    }

    public static synchronized Git getInstance() {
        if (instance == null) {
            instance = new Git();
            instance.init();
        }
        return instance;
    }

    private void init() {
        int statisticsFrequency;
        this.fileStatusCache = new FileStatusCache();
        this.annotator = new Annotator();
        this.interceptor = new FilesystemInterceptor();
        String s = System.getProperty("git.root.stat.frequency", "0");
        try {
            statisticsFrequency = Integer.parseInt(s);
        }
        catch (NumberFormatException ex) {
            statisticsFrequency = 0;
        }
        this.rootsToFile = new RootsToFile(new RootsToFile.Callback(){

            public boolean repositoryExistsFor(File file) {
                return GitUtils.repositoryExistsFor(file);
            }

            public File getTopmostManagedAncestor(File file) {
                return Git.this.getTopmostManagedAncestor(file);
            }
        }, Logger.getLogger("org.netbeans.modules.git.RootsToFile"), statisticsFrequency);
        ModuleLifecycleManager.getInstance().disableOtherModules();
    }

    void registerGitVCS(GitVCS gitVCS) {
        this.gitVCS = gitVCS;
        this.fileStatusCache.addPropertyChangeListener(gitVCS);
        this.addPropertyChangeListener(gitVCS);
    }

    public VCSAnnotator getVCSAnnotator() {
        return this.annotator;
    }

    FilesystemInterceptor getVCSInterceptor() {
        return this.interceptor;
    }

    void getOriginalFile(File workingCopy, File originalFile) {
        File repository = this.getRepositoryRoot(workingCopy);
        if (repository != null) {
            try {
                GitClient client = this.getClient(repository);
                if (!client.catFile(workingCopy, "HEAD", new FileOutputStream(originalFile), GitUtils.NULL_PROGRESS_MONITOR)) {
                    originalFile.delete();
                }
            }
            catch (FileNotFoundException ex) {
                LOG.log(Level.SEVERE, "Parent folder [{0}] does not exist", originalFile.getParentFile());
                LOG.log(Level.SEVERE, null, ex);
            }
            catch (GitException.MissingObjectException ex) {
                LOG.log(Level.FINE, null, ex);
                originalFile.delete();
            }
            catch (GitException ex) {
                LOG.log(Level.INFO, "Error retrieving file", ex);
                originalFile.delete();
            }
        }
    }

    public boolean isManaged(File file) {
        return VersioningSupport.getOwner((File)file) instanceof GitVCS && !GitUtils.isPartOfGitMetadata(file);
    }

    public FileStatusCache getFileStatusCache() {
        return this.fileStatusCache;
    }

    public File getRepositoryRoot(File file) {
        return this.rootsToFile.getRepositoryRoot(file);
    }

    public GitClient getClient(File repository) throws GitException {
        return this.getClient(repository, null);
    }

    public GitClient getClient(File repository, GitProgressSupport progressSupport) throws GitException {
        return this.getClient(repository, progressSupport, true);
    }

    public GitClient getClient(File repository, GitProgressSupport progressSupport, boolean handleAuthenticationIssues) throws GitException {
        File repositoryFolder = this.getRepositoryRoot(repository);
        if (repositoryFolder != null) {
            repository = repositoryFolder;
        }
        GitClient client = new GitClient(repository, progressSupport, handleAuthenticationIssues);
        client.setCallback(new CredentialsCallback());
        return client;
    }

    public RequestProcessor getRequestProcessor() {
        return this.getRequestProcessor(null);
    }

    public RequestProcessor getRequestProcessor(File repositoryRoot) {
        RequestProcessor rp;
        if (this.processorsToUrl == null) {
            this.processorsToUrl = new HashMap();
        }
        if ((rp = this.processorsToUrl.get(repositoryRoot)) == null) {
            if (repositoryRoot == null) {
                String rpName = "Git - ANY_KEY";
                rp = new RequestProcessor(rpName, 50, true);
            } else {
                String rpName = "Git - " + repositoryRoot.toString();
                rp = new RequestProcessor(rpName, 1, true);
            }
            this.processorsToUrl.put(repositoryRoot, rp);
        }
        return rp;
    }

    public void refreshAllAnnotations() {
        this.support.firePropertyChange(PROP_ANNOTATIONS_CHANGED, null, null);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }

    public void headChanged(Set<File> files) {
        assert (this.gitVCS != null);
        this.gitVCS.refreshStatus(files);
    }

    public void versionedFilesChanged() {
        this.rootsToFile.clear();
        this.clearAncestorCaches();
        this.support.firePropertyChange(PROP_VERSIONED_FILES_CHANGED, null, null);
    }

    public void refreshWorkingCopyTimestamp(File repository) {
        this.getVCSInterceptor().refreshMetadataTimestamp(repository);
    }

    public Set<File> getSeenRoots(File repositoryRoot) {
        return this.getVCSInterceptor().getSeenRoots(repositoryRoot);
    }

    public File getTopmostManagedAncestor(File file) {
        long t = System.currentTimeMillis();
        LOG.log(Level.FINE, "getTopmostManagedParent {0}", new Object[]{file});
        if (this.unversionedParents.contains(file)) {
            LOG.fine(" cached as unversioned");
            return null;
        }
        LOG.log(Level.FINE, "getTopmostManagedParent {0}", new Object[]{file});
        File parent = this.getKnownParent(file);
        if (parent != null) {
            LOG.log(Level.FINE, "  getTopmostManagedParent returning known parent {0}", parent);
            return parent;
        }
        if (GitUtils.isPartOfGitMetadata(file)) {
            while (file != null) {
                if (GitUtils.isAdministrative(file)) {
                    file = file.getParentFile();
                    break;
                }
                file = file.getParentFile();
            }
        }
        HashSet<File> done = new HashSet<File>();
        File topmost = null;
        while (file != null) {
            if (this.unversionedParents.contains(file)) {
                LOG.log(Level.FINE, " already known as unversioned {0}", new Object[]{file});
                break;
            }
            if (VersioningSupport.isExcluded((File)file)) break;
            if (GitUtils.repositoryExistsFor(file)) {
                LOG.log(Level.FINE, " found managed parent {0}", new Object[]{file});
                done.clear();
                topmost = file;
            } else {
                LOG.log(Level.FINE, " found unversioned {0}", new Object[]{file});
                if (file.exists()) {
                    done.add(file);
                }
            }
            file = file.getParentFile();
        }
        if (done.size() > 0) {
            LOG.log(Level.FINE, " storing unversioned");
            this.unversionedParents.addAll(done);
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, " getTopmostManagedParent returns {0} after {1} millis", new Object[]{topmost, System.currentTimeMillis() - t});
        }
        if (topmost != null) {
            this.knownRoots.add(topmost);
        }
        return topmost;
    }

    private File getKnownParent(File file) {
        File[] roots = this.knownRoots.toArray(new File[this.knownRoots.size()]);
        File knownParent = null;
        for (File r : roots) {
            if (VersioningSupport.isExcluded((File)file) || !Utils.isAncestorOrEqual((File)r, (File)file) || knownParent != null && !Utils.isAncestorOrEqual((File)knownParent, (File)r)) continue;
            knownParent = r;
        }
        return knownParent;
    }

    public void clearAncestorCaches() {
        this.unversionedParents.clear();
        this.knownRoots.clear();
    }

    public List<VCSHyperlinkProvider> getHyperlinkProviders() {
        if (this.hpResult == null) {
            this.hpResult = Lookup.getDefault().lookupResult(VCSHyperlinkProvider.class);
        }
        if (this.hpResult == null) {
            return Collections.emptyList();
        }
        Collection providersCol = this.hpResult.allInstances();
        ArrayList providersList = new ArrayList(providersCol.size());
        providersList.addAll(providersCol);
        return Collections.unmodifiableList(providersList);
    }

    public Collection<File> getCreatedFolders() {
        return this.getVCSInterceptor().getCreatedFolders();
    }

    public HistoryProvider getHistoryProvider() {
        if (this.historyProvider == null) {
            this.historyProvider = new HistoryProvider();
        }
        return this.historyProvider;
    }

    static {
        LOG = Logger.getLogger("org.netbeans.modules.git");
        STATUS_LOG = Logger.getLogger("org.netbeans.modules.git.status");
    }
}

