/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.GitStatus;
import org.netbeans.libs.git.progress.ProgressMonitor;
import org.netbeans.modules.git.FileInformation;
import org.netbeans.modules.git.Git;
import org.netbeans.modules.git.GitModuleConfig;
import org.netbeans.modules.git.utils.GitUtils;
import org.netbeans.modules.turbo.CacheIndex;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.netbeans.modules.versioning.spi.VersioningSupport;
import org.openide.filesystems.FileUtil;
import org.openide.util.RequestProcessor;

public class FileStatusCache {
    public static final String PROP_FILE_STATUS_CHANGED = "status.changed";
    private final CacheIndex conflictedFiles;
    private final CacheIndex modifiedFiles;
    private final CacheIndex ignoredFiles;
    private static final Logger LOG = Logger.getLogger("org.netbeans.modules.git.status.cache");
    private int MAX_COUNT_UPTODATE_FILES = 1024;
    private static final int CACHE_SIZE_WARNING_THRESHOLD = 50000;
    private boolean hugeCacheWarningLogged;
    int upToDateAccess = 0;
    private static final int UTD_NOTIFY_NUMBER = 100;
    private final Map<File, FileInformation> cachedFiles;
    private final LinkedHashSet<File> upToDateFiles = new LinkedHashSet(this.MAX_COUNT_UPTODATE_FILES);
    private final RequestProcessor rp = new RequestProcessor("Git.cache", 1, true);
    private final HashSet<File> nestedRepositories = new HashSet(2);
    private PropertyChangeSupport listenerSupport = new PropertyChangeSupport(this);
    private static final FileInformation FILE_INFORMATION_UPTODATE = new FileInformation(EnumSet.of(FileInformation.Status.UPTODATE), false);
    private static final FileInformation FILE_INFORMATION_NOTMANAGED = new FileInformation(EnumSet.of(FileInformation.Status.NOTVERSIONED_NOTMANAGED), false);
    private static final FileInformation FILE_INFORMATION_EXCLUDED = new FileInformation(EnumSet.of(FileInformation.Status.NOTVERSIONED_EXCLUDED), false);
    private static final FileInformation FILE_INFORMATION_NEWLOCALLY = new FileInformation(EnumSet.of(FileInformation.Status.NEW_INDEX_WORKING_TREE, FileInformation.Status.NEW_HEAD_WORKING_TREE), false);
    private static final FileInformation FILE_INFORMATION_UNKNOWN = new FileInformation(EnumSet.of(FileInformation.Status.UNKNOWN), false);
    private static final Map<File, File> SYNC_REPOSITORIES = new WeakHashMap<File, File>(5);

    public FileStatusCache() {
        this.cachedFiles = new HashMap<File, FileInformation>();
        this.conflictedFiles = FileStatusCache.createCacheIndex();
        this.modifiedFiles = FileStatusCache.createCacheIndex();
        this.ignoredFiles = FileStatusCache.createCacheIndex();
    }

    public FileInformation getStatus(File file) {
        return this.getStatus(file, true);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.listenerSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.listenerSupport.removePropertyChangeListener(listener);
    }

    public void refreshAllRoots(File ... roots) {
        this.refreshAllRoots(Arrays.asList(roots));
    }

    public void refreshAllRoots(Collection<File> files) {
        long startTime = 0L;
        if (LOG.isLoggable(Level.FINE)) {
            startTime = System.currentTimeMillis();
            LOG.fine("refreshAll: starting for " + files.size() + " files.");
        }
        if (files.isEmpty()) {
            return;
        }
        HashMap<File, Collection<File>> rootFiles = new HashMap<File, Collection<File>>(5);
        for (File file : files) {
            file = FileUtil.normalizeFile((File)file);
            File repository = Git.getInstance().getRepositoryRoot(file);
            if (repository == null) continue;
            Collection<File> filesUnderRoot = rootFiles.get(repository);
            if (filesUnderRoot == null) {
                filesUnderRoot = new HashSet<File>();
                rootFiles.put(repository, filesUnderRoot);
            }
            GitUtils.prepareRootFiles(repository, filesUnderRoot, file);
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("refreshAll: starting status scan for " + rootFiles.values() + " after " + (System.currentTimeMillis() - startTime));
            startTime = System.currentTimeMillis();
        }
        if (!rootFiles.isEmpty()) {
            this.refreshAllRoots(rootFiles);
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("refreshAll: finishes status scan after " + (System.currentTimeMillis() - startTime));
        }
    }

    public void refreshAllRoots(Map<File, Collection<File>> rootFiles) {
        this.refreshAllRoots(rootFiles, GitUtils.NULL_PROGRESS_MONITOR);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    public void refreshAllRoots(Map<File, Collection<File>> rootFiles, ProgressMonitor pm) {
        for (Map.Entry<File, Collection<File>> refreshEntry : rootFiles.entrySet()) {
            if (pm.isCanceled()) {
                return;
            }
            repository = refreshEntry.getKey();
            if (repository == null) continue;
            var7_7 = syncRepo = FileStatusCache.getSyncRepository(repository);
            synchronized (var7_7) {
                block23: {
                    block24: {
                        if (FileStatusCache.LOG.isLoggable(Level.FINE)) {
                            FileStatusCache.LOG.log(Level.FINE, "refreshAllRoots() roots: {0}, repositoryRoot: {1} ", new Object[]{refreshEntry.getValue(), repository.getAbsolutePath()});
                        }
                        interestingFiles = Git.getInstance().getClient(repository).getStatus(refreshEntry.getValue().toArray(new File[refreshEntry.getValue().size()]), pm);
                        if (!pm.isCanceled()) break block23;
                        if (!FileStatusCache.LOG.isLoggable(Level.FINE)) break block24;
                        FileStatusCache.LOG.log(Level.FINE, "refreshAllRoots() roots: finished repositoryRoot: {0} ", new Object[]{repository.getAbsolutePath()});
                    }
                    return;
                }
                try {
                    for (File root : refreshEntry.getValue()) {
                        for (File file : this.listFiles(Collections.singleton(root), EnumSet.complementOf(EnumSet.of(FileInformation.Status.UPTODATE)))) {
                            fi = this.getInfo(file);
                            if (fi == null || fi.containsStatus(FileInformation.Status.UPTODATE)) {
                                FileStatusCache.LOG.log(Level.WARNING, "refreshAllRoots(): possibly concurrent refresh: {0}:{1}", new Object[]{file, fi});
                                fi = new FileInformation(EnumSet.of(FileInformation.Status.UPTODATE), file.isDirectory());
                                ea = false;
                                if (!FileStatusCache.$assertionsDisabled) {
                                    ea = true;
                                    if (!true) {
                                        throw new AssertionError();
                                    }
                                }
                                if (!ea) continue;
                                try {
                                    Thread.sleep(100L);
                                }
                                catch (InterruptedException ex) {
                                    // empty catch block
                                }
                                if (!new HashSet<File>(Arrays.asList(this.listFiles(Collections.singleton(file.getParentFile()), EnumSet.complementOf(EnumSet.of(FileInformation.Status.UPTODATE))))).contains(file)) continue;
                                FileStatusCache.LOG.log(Level.WARNING, "refreshAllRoots(): now we have a problem, index seems to be broken", new Object[]{file});
                                continue;
                            }
                            exists = file.exists();
                            filesOwner = null;
                            correctRepository = true;
                            if (!interestingFiles.containsKey(file) && (fi.containsStatus(FileInformation.Status.NOTVERSIONED_EXCLUDED) && (!exists || fi.isDirectory() && !GitUtils.isIgnored(file, true)) || !fi.isDirectory() && !fi.containsStatus(FileInformation.Status.NOTVERSIONED_EXCLUDED)) && (correctRepository = repository.equals(filesOwner = Git.getInstance().getRepositoryRoot(file)))) {
                                FileStatusCache.LOG.log(Level.FINE, "refreshAllRoots() uninteresting file: {0} {1}", new Object[]{file, fi});
                                this.refreshFileStatus(file, FileStatusCache.FILE_INFORMATION_UNKNOWN);
                            }
                            if (correctRepository || !this.nestedRepositories.add(filesOwner)) continue;
                            FileStatusCache.LOG.log(Level.INFO, "refreshAllRoots: nested repository found: {0} contains {1}", new File[]{repository, filesOwner});
                        }
                    }
                    for (Map.Entry interestingEntry : interestingFiles.entrySet()) {
                        file = (File)interestingEntry.getKey();
                        fi = new FileInformation((GitStatus)interestingEntry.getValue());
                        FileStatusCache.LOG.log(Level.FINE, "refreshAllRoots() file status: {0} {1}", new Object[]{file.getAbsolutePath(), fi});
                        this.refreshFileStatus(file, fi);
                    }
                    ** if (!FileStatusCache.LOG.isLoggable((Level)Level.FINE)) goto lbl-1000
                }
                catch (GitException ex) {
                    try {
                        FileStatusCache.LOG.log(Level.INFO, "refreshAllRoots() file: {0} {1} {2} ", new Object[]{repository.getAbsolutePath(), refreshEntry.getValue(), ex.toString()});
                        ** if (!FileStatusCache.LOG.isLoggable((Level)Level.FINE)) goto lbl-1000
                    }
                    catch (Throwable var19_22) {
                        if (FileStatusCache.LOG.isLoggable(Level.FINE)) {
                            FileStatusCache.LOG.log(Level.FINE, "refreshAllRoots() roots: finished repositoryRoot: {0} ", new Object[]{repository.getAbsolutePath()});
                        }
                        throw var19_22;
                    }
lbl-1000:
                    // 1 sources

                    {
                        FileStatusCache.LOG.log(Level.FINE, "refreshAllRoots() roots: finished repositoryRoot: {0} ", new Object[]{repository.getAbsolutePath()});
                    }
lbl-1000:
                    // 2 sources

                    {
                    }
                }
lbl-1000:
                // 1 sources

                {
                    FileStatusCache.LOG.log(Level.FINE, "refreshAllRoots() roots: finished repositoryRoot: {0} ", new Object[]{repository.getAbsolutePath()});
                }
lbl-1000:
                // 2 sources

                {
                }
            }
        }
    }

    public boolean containsFiles(VCSContext context, Set<FileInformation.Status> includeStatus, boolean addExcluded) {
        Set roots = context.getRootFiles();
        return this.containsFiles(roots, includeStatus, addExcluded);
    }

    public boolean containsFiles(Set<File> roots, Set<FileInformation.Status> includeStatus, boolean addExcluded) {
        for (File root : roots) {
            if (!this.containsFilesIntern(this.getIndexValues(root, includeStatus), includeStatus, !VersioningSupport.isFlat((File)root), addExcluded)) continue;
            return true;
        }
        return this.containsFilesIntern(roots, includeStatus, false, addExcluded);
    }

    public File[] listFiles(File ... roots) {
        return this.listFiles(Arrays.asList(roots), FileInformation.STATUS_ALL);
    }

    public File[] listFiles(File[] roots, EnumSet<FileInformation.Status> includeStatus) {
        return this.listFiles(Arrays.asList(roots), includeStatus);
    }

    public File[] listFiles(Collection<File> roots, EnumSet<FileInformation.Status> includeStatus) {
        HashSet<File> set = new HashSet<File>();
        for (File root : roots) {
            set.addAll(this.listFilesIntern(this.getIndexValues(root, includeStatus), includeStatus, !VersioningSupport.isFlat((File)root)));
        }
        set.addAll(this.listFilesIntern(roots, includeStatus, false));
        return set.toArray(new File[set.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileInformation getInfo(File file) {
        FileInformation info = null;
        Map<File, FileInformation> map = this.cachedFiles;
        synchronized (map) {
            info = this.cachedFiles.get(file);
            LinkedHashSet<File> linkedHashSet = this.upToDateFiles;
            synchronized (linkedHashSet) {
                if (info == null && this.upToDateFiles.contains(file)) {
                    this.addUpToDate(file);
                    info = FILE_INFORMATION_UPTODATE;
                }
            }
        }
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setInfo(File file, FileInformation info) {
        Map<File, FileInformation> map = this.cachedFiles;
        synchronized (map) {
            this.cachedFiles.put(file, info);
            if (!this.hugeCacheWarningLogged && this.cachedFiles.size() > 50000) {
                LOG.log(Level.WARNING, "Cache contains too many entries: {0}", this.cachedFiles.size());
                this.hugeCacheWarningLogged = true;
            }
            this.removeUpToDate(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeInfo(File file) {
        Map<File, FileInformation> map = this.cachedFiles;
        synchronized (map) {
            this.cachedFiles.remove(file);
            this.removeUpToDate(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addUpToDate(File file) {
        LinkedHashSet<File> linkedHashSet = this.upToDateFiles;
        synchronized (linkedHashSet) {
            this.upToDateFiles.remove(file);
            this.upToDateFiles.add(file);
            if (this.upToDateFiles.size() >= this.MAX_COUNT_UPTODATE_FILES) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.log(Level.WARNING, "Cache of uptodate files grows too quickly: {0}", this.upToDateFiles.size());
                    this.MAX_COUNT_UPTODATE_FILES <<= 1;
                    assert (false);
                } else {
                    Iterator it = this.upToDateFiles.iterator();
                    int toDelete = this.MAX_COUNT_UPTODATE_FILES >> 3;
                    for (int i = 0; i < toDelete && it.hasNext(); ++i) {
                        it.next();
                        it.remove();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeUpToDate(File file) {
        LinkedHashSet<File> linkedHashSet = this.upToDateFiles;
        synchronized (linkedHashSet) {
            return this.upToDateFiles.remove(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileInformation getStatus(final File file, boolean seenInUI) {
        FileInformation info = this.getInfo(file);
        LOG.log(Level.FINER, "getCachedStatus for file {0}: {1}", new Object[]{file, info});
        boolean triggerGitScan = false;
        boolean addAsExcluded = false;
        if (info == null) {
            if (Git.getInstance().isManaged(file)) {
                triggerGitScan = seenInUI;
                info = this.checkForIgnoredFile(file);
                if (info == null) {
                    info = this.getInfo(file);
                }
                if (file.isDirectory()) {
                    info = info != null && info.containsStatus(FileInformation.Status.NOTVERSIONED_EXCLUDED) ? new FileInformation(EnumSet.of(FileInformation.Status.NOTVERSIONED_EXCLUDED), true) : new FileInformation(EnumSet.of(FileInformation.Status.UPTODATE), true);
                    this.setInfo(file, info);
                } else if (info == null || info.containsStatus(FileInformation.Status.UPTODATE)) {
                    info = FILE_INFORMATION_UPTODATE;
                    this.addUpToDate(file);
                    if (++this.upToDateAccess > 100) {
                        this.upToDateAccess = 0;
                        if (LOG.isLoggable(Level.FINE)) {
                            LinkedHashSet<File> linkedHashSet = this.upToDateFiles;
                            synchronized (linkedHashSet) {
                                LOG.log(Level.FINE, "Another {0} U2D files added: {1}", new Object[]{new Integer(100), this.upToDateFiles});
                            }
                        }
                    }
                } else if (info.containsStatus(FileInformation.Status.NOTVERSIONED_EXCLUDED)) {
                    addAsExcluded = true;
                }
            } else {
                info = file.isDirectory() ? new FileInformation(EnumSet.of(FileInformation.Status.NOTVERSIONED_NOTMANAGED), true) : FILE_INFORMATION_NOTMANAGED;
            }
            LOG.log(Level.FINER, "getCachedStatus: default for file {0}: {1}", new Object[]{file, info});
        } else {
            if (info.containsStatus(FileInformation.Status.UPTODATE) && this.checkForIgnoredFile(file) != null) {
                info = FILE_INFORMATION_EXCLUDED;
                addAsExcluded = true;
            }
            boolean bl = triggerGitScan = seenInUI && !info.seenInUI();
        }
        if (addAsExcluded) {
            this.rp.post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    FileStatusCache fileStatusCache = FileStatusCache.this;
                    synchronized (fileStatusCache) {
                        FileInformation info = FileStatusCache.this.getInfo(file);
                        if (info == null || info.containsStatus(FileInformation.Status.UPTODATE)) {
                            FileStatusCache.this.refreshFileStatus(file, FILE_INFORMATION_EXCLUDED);
                        }
                    }
                }
            });
        }
        if (triggerGitScan) {
            info.setSeenInUI(true);
            Git.getInstance().getVCSInterceptor().pingRepositoryRootFor(file);
        }
        return info;
    }

    private void fireFileStatusChanged(File file, FileInformation oldInfo, FileInformation newInfo) {
        this.listenerSupport.firePropertyChange(PROP_FILE_STATUS_CHANGED, null, new ChangedEvent(file, oldInfo, newInfo));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshFileStatus(File file, FileInformation fi) {
        FileInformation current;
        if (file == null || fi == null) {
            return;
        }
        FileStatusCache fileStatusCache = this;
        synchronized (fileStatusCache) {
            file = FileUtil.normalizeFile((File)file);
            current = this.getInfo(file);
            if ((FileStatusCache.equivalent(FILE_INFORMATION_NEWLOCALLY, fi) || current != null && fi.getStatus().contains((Object)FileInformation.Status.UPTODATE) && current.getStatus().contains((Object)FileInformation.Status.NOTVERSIONED_EXCLUDED)) && (GitUtils.isIgnored(file, true) || this.getStatus(file.getParentFile(), false).containsStatus(FileInformation.Status.NOTVERSIONED_EXCLUDED))) {
                LOG.log(Level.FINE, "refreshFileStatus() file: {0} was LocallyNew but is NotSharable", file.getAbsolutePath());
                FileInformation fileInformation = fi = file.isDirectory() ? new FileInformation(EnumSet.of(FileInformation.Status.NOTVERSIONED_EXCLUDED), true) : FILE_INFORMATION_EXCLUDED;
            }
            if (FileStatusCache.equivalent(fi, current)) {
                return;
            }
            boolean addToIndex = false;
            if (((Object)fi.getStatus()).equals(EnumSet.of(FileInformation.Status.UNKNOWN))) {
                this.removeInfo(file);
            } else if (((Object)fi.getStatus()).equals(EnumSet.of(FileInformation.Status.UPTODATE)) && file.isFile()) {
                this.removeInfo(file);
                this.addUpToDate(file);
            } else {
                this.setInfo(file, fi);
                addToIndex = true;
            }
            this.updateIndex(file, fi, addToIndex);
        }
        this.fireFileStatusChanged(file, current, fi);
    }

    private static boolean equivalent(FileInformation main, FileInformation other) {
        boolean retval = other != null && ((Object)main.getStatus()).equals(other.getStatus()) && main.isDirectory() == other.isDirectory() ? main.getStatusText().equals(other.getStatusText()) : false;
        return retval;
    }

    private boolean containsFilesIntern(Set<File> indexRoots, Set<FileInformation.Status> includeStatus, boolean recursively, boolean addExcluded) {
        if (indexRoots == null || indexRoots.isEmpty()) {
            return false;
        }
        for (File root : indexRoots) {
            Set<File> indexValues = this.getIndexValues(root, includeStatus);
            if (!recursively || !this.containsFilesIntern(indexValues, includeStatus, recursively, addExcluded)) continue;
            return true;
        }
        for (File root : indexRoots) {
            FileInformation fi = this.getInfo(root);
            if (fi == null || !fi.containsStatus(includeStatus) || !addExcluded && GitModuleConfig.getDefault().isExcludedFromCommit(root.getAbsolutePath())) continue;
            return true;
        }
        return false;
    }

    private Set<File> listFilesIntern(Collection<File> roots, EnumSet<FileInformation.Status> includeStatus, boolean recursively) {
        if (roots == null || roots.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<File> ret = new HashSet<File>();
        for (File root : roots) {
            FileInformation fi;
            if (recursively) {
                ret.addAll(this.listFilesIntern(this.getIndexValues(root, includeStatus), includeStatus, recursively));
            }
            if ((fi = this.getInfo(root)) == null || !fi.containsStatus(includeStatus)) continue;
            ret.add(root);
        }
        return ret;
    }

    private static CacheIndex createCacheIndex() {
        return new CacheIndex(){

            protected boolean isManaged(File file) {
                return Git.getInstance().isManaged(file);
            }
        };
    }

    private Set<File> getIndexValues(File root, Set<FileInformation.Status> includeStatus) {
        File[] modified = new File[]{};
        File[] ignored = new File[]{};
        if (includeStatus.contains((Object)FileInformation.Status.NOTVERSIONED_EXCLUDED)) {
            ignored = this.ignoredFiles.get(root);
        }
        if (((AbstractSet)FileInformation.STATUS_LOCAL_CHANGES.clone()).removeAll(includeStatus)) {
            modified = ((Object)includeStatus).equals(EnumSet.of(FileInformation.Status.IN_CONFLICT)) ? this.conflictedFiles.get(root) : this.modifiedFiles.get(root);
        }
        HashSet<File> values = new HashSet<File>(Arrays.asList(ignored));
        values.addAll(Arrays.asList(modified));
        return values;
    }

    private void updateIndex(File file, FileInformation fi, boolean addToIndex) {
        File parent = file.getParentFile();
        if (parent != null) {
            HashSet<File> conflicted = new HashSet<File>(Arrays.asList(this.conflictedFiles.get(parent)));
            HashSet<File> modified = new HashSet<File>(Arrays.asList(this.modifiedFiles.get(parent)));
            HashSet<File> ignored = new HashSet<File>(Arrays.asList(this.ignoredFiles.get(parent)));
            modified.remove(file);
            conflicted.remove(file);
            ignored.remove(file);
            if (addToIndex) {
                if (fi.containsStatus(FileInformation.Status.NOTVERSIONED_EXCLUDED)) {
                    ignored.add(file);
                } else {
                    modified.add(file);
                    if (fi.containsStatus(FileInformation.Status.IN_CONFLICT)) {
                        conflicted.add(file);
                    }
                }
            }
            this.modifiedFiles.add(parent, modified);
            this.conflictedFiles.add(parent, conflicted);
            this.ignoredFiles.add(parent, ignored);
        }
    }

    private FileInformation checkForIgnoredFile(File file) {
        FileInformation fi = null;
        if (file.getParentFile() != null && this.getStatus(file.getParentFile(), false).containsStatus(FileInformation.Status.NOTVERSIONED_EXCLUDED)) {
            fi = FILE_INFORMATION_EXCLUDED;
        } else {
            this.handleIgnoredFiles(Collections.singleton(file));
        }
        return fi;
    }

    private void handleIgnoredFiles(final Set<File> files) {
        Runnable async = new Runnable(){

            @Override
            public void run() {
                for (File f : files) {
                    if (!GitUtils.isIgnored(f, true)) continue;
                    boolean isDirectory = f.isDirectory();
                    boolean exists = f.exists();
                    if (!exists) {
                        FileStatusCache.this.refreshFileStatus(f, FILE_INFORMATION_UNKNOWN);
                        continue;
                    }
                    FileStatusCache.this.refreshFileStatus(f, isDirectory ? new FileInformation(EnumSet.of(FileInformation.Status.NOTVERSIONED_EXCLUDED), true) : FILE_INFORMATION_EXCLUDED);
                }
            }
        };
        this.rp.post(async);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File getSyncRepository(File repository) {
        File cachedRepository = Git.getInstance().getRepositoryRoot(repository);
        if (repository.equals(cachedRepository)) {
            repository = cachedRepository;
        }
        Map<File, File> map = SYNC_REPOSITORIES;
        synchronized (map) {
            cachedRepository = SYNC_REPOSITORIES.get(repository);
            if (cachedRepository == null) {
                cachedRepository = new File(repository.getParentFile(), repository.getName());
                SYNC_REPOSITORIES.put(cachedRepository, cachedRepository);
            }
        }
        return cachedRepository;
    }

    public static class ChangedEvent {
        private File file;
        private FileInformation oldInfo;
        private FileInformation newInfo;

        public ChangedEvent(File file, FileInformation oldInfo, FileInformation newInfo) {
            this.file = file;
            this.oldInfo = oldInfo;
            this.newInfo = newInfo;
        }

        public File getFile() {
            return this.file;
        }

        public FileInformation getOldInfo() {
            return this.oldInfo;
        }

        public FileInformation getNewInfo() {
            return this.newInfo;
        }
    }
}

