/*
 * Decompiled with CFR 0.152.
 */
package org.nbheaven.sqe.core.ui.actions;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.openide.awt.Actions;
import org.openide.awt.Mnemonics;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActionUtils {
    private final FileObject fo;

    public static ActionUtils getProjectUtils() {
        return new ActionUtils("SQE/Projects/Actions");
    }

    public static ActionUtils getPackageUtils() {
        return new ActionUtils("SQE/Packages/Actions");
    }

    private ActionUtils(String folder) {
        this.fo = FileUtil.getConfigFile((String)folder);
    }

    public final Collection<JMenuItem> getMenuItems() {
        return this.fo != null ? ActionUtils.createMenuList(this.fo) : Collections.emptySet();
    }

    private static Collection<JMenuItem> createMenuList(FileObject fo) {
        ArrayList<JMenuItem> myMenus = new ArrayList<JMenuItem>();
        for (FileObject actionsFileObject : fo.getChildren()) {
            try {
                if (actionsFileObject.isFolder()) {
                    JMenu myMenu = new JMenu(actionsFileObject.getName());
                    myMenu.setIcon(null);
                    Mnemonics.setLocalizedText((AbstractButton)myMenu, (String)myMenu.getText());
                    ActionUtils.addActionsToSubMenu(actionsFileObject, myMenu);
                    myMenus.add(myMenu);
                    continue;
                }
                DataObject dob = DataObject.find((FileObject)actionsFileObject);
                InstanceCookie cookie = (InstanceCookie)dob.getCookie(InstanceCookie.class);
                if (null == cookie) continue;
                JMenuItem item = new JMenuItem();
                Action action = (Action)cookie.instanceCreate();
                Actions.connect((JMenuItem)item, (Action)action, (boolean)true);
                myMenus.add(item);
            }
            catch (DataObjectNotFoundException donfe) {
            }
            catch (IOException ioex) {
            }
            catch (ClassNotFoundException cnfe) {
                // empty catch block
            }
        }
        return myMenus;
    }

    private static void addActionsToSubMenu(FileObject fo, JMenu menu) {
        List<Object> children = new ArrayList<FileObject>(Arrays.asList(fo.getChildren()));
        children = FileUtil.getOrder(children, (boolean)true);
        for (FileObject fileObject : children) {
            try {
                DataObject dob;
                InstanceCookie cookie;
                if (fileObject.isFolder() || null == (cookie = (InstanceCookie)(dob = DataObject.find((FileObject)fileObject)).getCookie(InstanceCookie.class))) continue;
                Object instance = cookie.instanceCreate();
                if (instance instanceof Action) {
                    JMenuItem item = new JMenuItem();
                    Actions.connect((JMenuItem)item, (Action)((Action)instance), (boolean)true);
                    menu.add(item);
                    continue;
                }
                if (!(instance instanceof JComponent)) continue;
                menu.add((JComponent)instance);
            }
            catch (DataObjectNotFoundException donfe) {
            }
            catch (IOException ioex) {
            }
            catch (ClassNotFoundException cnfe) {}
        }
    }
}

