/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.jpa.verification.rules.entity;

import java.util.Arrays;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.modules.j2ee.jpa.verification.JPAClassRule;
import org.netbeans.modules.j2ee.jpa.verification.common.ProblemContext;
import org.netbeans.modules.j2ee.jpa.verification.fixes.ImplementSerializable;
import org.netbeans.modules.j2ee.jpa.verification.rules.entity.IdDefinedInHierarchy;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Severity;
import org.openide.util.NbBundle;

public class SerializableClass
extends JPAClassRule {
    public SerializableClass() {
        this.setClassContraints(Arrays.asList(JPAClassRule.ClassConstraints.ENTITY, JPAClassRule.ClassConstraints.EMBEDDABLE, JPAClassRule.ClassConstraints.IDCLASS));
    }

    @Override
    public ErrorDescription[] apply(TypeElement subject, ProblemContext ctx) {
        if (this.extendsFromSerializable(subject)) {
            return null;
        }
        TypeMirror superCls = subject.getSuperclass();
        while (superCls != null && superCls instanceof DeclaredType) {
            TypeElement superElem = (TypeElement)((DeclaredType)superCls).asElement();
            if (this.extendsFromSerializable(superElem)) {
                return null;
            }
            superCls = superElem.getSuperclass();
        }
        ImplementSerializable fix = new ImplementSerializable(ctx.getFileObject(), (ElementHandle<TypeElement>)ElementHandle.create((Element)subject));
        return new ErrorDescription[]{SerializableClass.createProblem((Element)subject, ctx, NbBundle.getMessage(IdDefinedInHierarchy.class, (String)"MSG_NonSerializableClass"), Severity.WARNING, fix)};
    }

    private boolean extendsFromSerializable(TypeElement subject) {
        for (TypeMirror typeMirror : subject.getInterfaces()) {
            DeclaredType iType;
            if ("java.io.Serializable".equals(((Object)typeMirror).toString())) {
                return true;
            }
            if (!(typeMirror instanceof DeclaredType) || !this.extendsFromSerializable((TypeElement)(iType = (DeclaredType)typeMirror).asElement())) continue;
            return true;
        }
        return false;
    }
}

