/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.jpa.verification.rules.entity;

import java.util.Collections;
import java.util.HashSet;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.netbeans.modules.j2ee.jpa.model.ModelUtils;
import org.netbeans.modules.j2ee.jpa.verification.JPAClassRule;
import org.netbeans.modules.j2ee.jpa.verification.JPAProblemContext;
import org.netbeans.modules.j2ee.jpa.verification.common.ProblemContext;
import org.netbeans.modules.j2ee.jpa.verification.rules.entity.IdDefinedInHierarchy;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.Entity;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.Id;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.openide.util.NbBundle;

public class NoIdClassOnEntitySubclass
extends JPAClassRule {
    public NoIdClassOnEntitySubclass() {
        this.setClassContraints(Collections.singleton(JPAClassRule.ClassConstraints.ENTITY));
    }

    @Override
    public ErrorDescription[] apply(TypeElement subject, ProblemContext ctx) {
        TypeMirror superClassType;
        Entity entity = (Entity)ctx.getModelElement();
        if (entity.getIdClass() == null && (superClassType = subject.getSuperclass()).getKind() == TypeKind.DECLARED) {
            TypeElement superClassElem = (TypeElement)((DeclaredType)superClassType).asElement();
            Entity parentEntity = ModelUtils.getEntity(((JPAProblemContext)ctx).getMetaData(), superClassElem);
            if (parentEntity != null) {
                HashSet<String> parentEntityIds = new HashSet<String>(1);
                for (Id id : parentEntity.getAttributes().getId()) {
                    parentEntityIds.add(id.getName());
                }
                for (Id id : entity.getAttributes().getId()) {
                    if (parentEntityIds.contains(id.getName())) continue;
                    return new ErrorDescription[]{NoIdClassOnEntitySubclass.createProblem(subject, ctx, NbBundle.getMessage(IdDefinedInHierarchy.class, (String)"MSG_EntitySubclassHasIdClass"))};
                }
            }
        }
        return null;
    }
}

