/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.jpa.verification.rules.entity;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ListResourceBundle;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import org.eclipse.persistence.jpa.internal.jpql.JPQLQueryProblemResourceBundle;
import org.eclipse.persistence.jpa.jpql.JPQLQueryHelper;
import org.eclipse.persistence.jpa.jpql.JPQLQueryProblem;
import org.eclipse.persistence.jpa.jpql.spi.IManagedTypeProvider;
import org.eclipse.persistence.jpa.jpql.spi.IQuery;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.jpa.verification.CancelListener;
import org.netbeans.modules.j2ee.jpa.verification.JPAClassRule;
import org.netbeans.modules.j2ee.jpa.verification.JPAProblemContext;
import org.netbeans.modules.j2ee.jpa.verification.JPAProblemFinder;
import org.netbeans.modules.j2ee.jpa.verification.common.ProblemContext;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.Entity;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.NamedQuery;
import org.netbeans.modules.j2ee.persistence.spi.jpql.ManagedTypeProvider;
import org.netbeans.modules.j2ee.persistence.spi.jpql.Query;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Severity;
import org.openide.filesystems.FileObject;

public class JPQLValidation
extends JPAClassRule
implements CancelListener {
    private ManagedTypeProvider mtp;
    private JPQLQueryHelper helper;

    public JPQLValidation() {
        this.setClassContraints(Arrays.asList(JPAClassRule.ClassConstraints.ENTITY, JPAClassRule.ClassConstraints.EMBEDDABLE, JPAClassRule.ClassConstraints.MAPPED_SUPERCLASS));
    }

    @Override
    public ErrorDescription[] apply(TypeElement subject, ProblemContext ctx) {
        JPAProblemContext jpaCtx = (JPAProblemContext)ctx;
        jpaCtx.addCancelListener(this);
        Object modEl = ctx.getModelElement();
        Entity entity = (Entity)(modEl instanceof Entity ? modEl : null);
        this.helper = new JPQLQueryHelper();
        Project project = FileOwnerQuery.getOwner((FileObject)ctx.getFileObject());
        ArrayList problems = new ArrayList();
        this.mtp = new ManagedTypeProvider(project, jpaCtx.getMetaData(), jpaCtx.getCompilationInfo().getElements());
        if (entity != null) {
            for (NamedQuery nq : entity.getNamedQuery()) {
                if (nq == null || nq.getQuery() == null) continue;
                this.helper.setQuery((IQuery)new Query(nq, nq.getQuery(), (IManagedTypeProvider)this.mtp));
                List tmp = null;
                try {
                    tmp = this.helper.validate();
                }
                catch (UnsupportedOperationException ex) {
                    JPAProblemFinder.LOG.log(Level.INFO, "Unsupported jpql validation case: " + ex.getMessage(), ex);
                }
                catch (NullPointerException ex) {
                    JPAProblemFinder.LOG.log(Level.INFO, "NPE in jpql validation: " + ex.getMessage(), ex);
                }
                if (tmp != null && tmp.size() > 0) {
                    problems.addAll(tmp);
                }
                this.helper.dispose();
            }
        }
        ErrorDescription[] ret = null;
        if (!ctx.isCancelled() && problems != null && problems.size() > 0) {
            ret = new ErrorDescription[problems.size()];
            for (int i = 0; i < ret.length; ++i) {
                ListResourceBundle msgBundle = null;
                try {
                    msgBundle = (ListResourceBundle)ResourceBundle.getBundle(JPQLQueryProblemResourceBundle.class.getName());
                }
                catch (MissingResourceException ex) {
                    msgBundle = (ListResourceBundle)ResourceBundle.getBundle(JPQLQueryProblemResourceBundle.class.getName(), Locale.ENGLISH);
                }
                String message = MessageFormat.format(msgBundle.getString(((JPQLQueryProblem)problems.get(i)).getMessageKey()), ((JPQLQueryProblem)problems.get(i)).getMessageArguments());
                String pos = "[" + ((JPQLQueryProblem)problems.get(i)).getStartPosition() + ";" + ((JPQLQueryProblem)problems.get(i)).getEndPosition() + "]";
                Query q = (Query)((JPQLQueryProblem)problems.get(i)).getQuery();
                if (q.getNamedQuery() != null && q.getNamedQuery().getName() != null) {
                    pos = q.getNamedQuery().getName() + pos;
                }
                ret[i] = JPQLValidation.createProblem((Element)subject, ctx, pos + ": " + message, Severity.WARNING);
            }
        }
        jpaCtx.removeCancelListener(this);
        this.mtp = null;
        this.helper = null;
        return ret;
    }

    @Override
    protected boolean isApplicable(TypeElement subject, ProblemContext ctx) {
        JPAProblemContext jpaCtx = (JPAProblemContext)ctx;
        return jpaCtx.isEntity() || jpaCtx.isMappedSuperClass();
    }

    @Override
    public void cancelled() {
        if (this.mtp != null) {
            this.mtp.invalidate();
        }
    }
}

