/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.jpa.verification;

import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.EventListener;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;
import javax.swing.text.Document;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.jpa.model.JPAHelper;
import org.netbeans.modules.j2ee.jpa.model.ModelUtils;
import org.netbeans.modules.j2ee.jpa.verification.JPAProblemContext;
import org.netbeans.modules.j2ee.jpa.verification.JPARulesEngine;
import org.netbeans.modules.j2ee.jpa.verification.common.Utilities;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModel;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelAction;
import org.netbeans.modules.j2ee.persistence.api.PersistenceScope;
import org.netbeans.modules.j2ee.persistence.api.PersistenceScopes;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.Entity;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.EntityMappingsMetadata;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.IdClass;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.MappedSuperclass;
import org.netbeans.modules.j2ee.persistence.dd.PersistenceUtils;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.HintsController;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.util.WeakListeners;

public abstract class JPAProblemFinder {
    private boolean cancelled = false;
    private FileObject file = null;
    private Object cancellationLock = new Object();
    private JPAProblemContext context = null;
    private List<ErrorDescription> problemsFound = new ArrayList<ErrorDescription>();
    public static final Logger LOG = Logger.getLogger(JPAProblemFinder.class.getName());
    private static final String PERSISTENCE_SCOPES_LISTENER = "jpa.verification.scopes_listener";
    private static final Object singleInstanceLock = new Object();
    private static JPAProblemFinder runningInstance = null;
    private static boolean usgLogged;

    public JPAProblemFinder(FileObject file) {
        assert (file != null);
        this.file = file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(final CompilationInfo info) throws Exception {
        if (!"text/x-java".equals(this.file.getMIMEType())) {
            return;
        }
        if (runningInstance != null) {
            runningInstance.cancel();
        }
        Object object = singleInstanceLock;
        synchronized (object) {
            runningInstance = this;
            this.cancelled = false;
            this.problemsFound.clear();
            this.createPersistenceScopesListener(this.file, info.getDocument());
            MetadataModel<EntityMappingsMetadata> emModel = ModelUtils.getModel(this.file);
            if (emModel == null) {
                return;
            }
            emModel.runReadActionWhenReady((MetadataModelAction)new MetadataModelAction<EntityMappingsMetadata, Void>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Void run(EntityMappingsMetadata metadata) {
                    for (Tree tree : info.getCompilationUnit().getTypeDecls()) {
                        if (JPAProblemFinder.this.isCancelled()) break;
                        if (!TreeUtilities.CLASS_TREE_KINDS.contains((Object)tree.getKind())) continue;
                        TreePath path = info.getTrees().getPath(info.getCompilationUnit(), tree);
                        TypeElement javaClass = (TypeElement)info.getTrees().getElement(path);
                        JPAProblemFinder.this.processClass(info, metadata, javaClass);
                        for (TypeElement innerClass : ElementFilter.typesIn(javaClass.getEnclosedElements())) {
                            JPAProblemFinder.this.processClass(info, metadata, innerClass);
                        }
                        Object object = JPAProblemFinder.this.cancellationLock;
                        synchronized (object) {
                            JPAProblemFinder.this.context = null;
                        }
                    }
                    return null;
                }
            });
            HintsController.setErrors((FileObject)this.file, (String)"JPA Verification", this.problemsFound);
            runningInstance = null;
        }
    }

    private void processClass(CompilationInfo info, EntityMappingsMetadata metadata, TypeElement javaClass) {
        long startTime = Calendar.getInstance().getTimeInMillis();
        this.context = this.findProblemContext(info, javaClass, metadata, false);
        JPARulesEngine rulesEngine = new JPARulesEngine();
        rulesEngine.visitTypeAsClass(javaClass, this.context);
        this.problemsFound.addAll(rulesEngine.getProblemsFound());
        this.problemsFound.addAll(this.processIdClass(info, javaClass, metadata, this.context.getModelElement()));
        if (LOG.isLoggable(Level.FINE)) {
            long timeElapsed = Calendar.getInstance().getTimeInMillis() - startTime;
            LOG.log(Level.FINE, "processed class {0} in {1} ms", new Object[]{javaClass.getSimpleName(), timeElapsed});
        }
    }

    private List<ErrorDescription> processIdClass(CompilationInfo info, TypeElement javaClass, EntityMappingsMetadata metadata, Object modelElement) {
        TypeElement idClass;
        String idClassName;
        IdClass idClassElem = null;
        if (modelElement instanceof Entity) {
            idClassElem = ((Entity)modelElement).getIdClass();
        } else if (modelElement instanceof MappedSuperclass) {
            idClassElem = ((MappedSuperclass)modelElement).getIdClass();
        }
        if (idClassElem != null && (idClassName = idClassElem.getClass2()) != null && (idClass = info.getElements().getTypeElement(idClassName)) != null) {
            JPAProblemContext context = this.findProblemContext(info, idClass, metadata, true);
            AnnotationMirror annIdClass = Utilities.findAnnotation(javaClass, "javax.persistence.IdClass");
            Tree treeToAnnotate = annIdClass != null ? info.getTrees().getTree(javaClass, annIdClass) : info.getTrees().getTree(javaClass);
            context.setElementToAnnotate(treeToAnnotate);
            JPARulesEngine rulesEngine = new JPARulesEngine();
            rulesEngine.visitTypeAsClass(idClass, context);
            return rulesEngine.getProblemsFound();
        }
        return Collections.emptyList();
    }

    private JPAProblemContext findProblemContext(CompilationInfo info, TypeElement javaClass, EntityMappingsMetadata metadata, boolean idClass) {
        JPAProblemContext context = new JPAProblemContext();
        context.setMetaData(metadata);
        context.setJavaClass(javaClass);
        if (!idClass) {
            Entity modelElement = ModelUtils.getEntity(metadata, javaClass);
            if (modelElement != null) {
                context.setEntity(true);
            } else {
                modelElement = ModelUtils.getEmbeddable(metadata, javaClass);
                if (modelElement != null) {
                    context.setEmbeddable(true);
                } else {
                    modelElement = ModelUtils.getMappedSuperclass(metadata, javaClass);
                    if (modelElement != null) {
                        context.setMappedSuperClass(true);
                    }
                }
            }
            context.setModelElement(modelElement);
        }
        context.setIdClass(idClass);
        context.setFileObject(this.file);
        context.setCompilationInfo(info);
        if (context.isJPAClass()) {
            context.setAccessType(JPAHelper.findAccessType(javaClass, context.getModelElement()));
            if (!usgLogged) {
                usgLogged = true;
                PersistenceUtils.logUsage(JPAProblemFinder.class, (String)"USG_PERSISTENCE_DETECTED", (Object[])new String[]{"CLASS"});
            }
        }
        return context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        LOG.fine("Cancelling JPAProblemFinder task");
        this.cancelled = true;
        Object object = this.cancellationLock;
        synchronized (object) {
            if (this.context != null) {
                this.context.setCancelled(true);
            }
        }
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public List<? extends ErrorDescription> getProblemsFound() {
        return this.problemsFound;
    }

    private void createPersistenceScopesListener(FileObject file, Document doc) {
        PersistenceScopes scopes;
        if (doc == null) {
            return;
        }
        LOG.fine("Creating PersistenceScopesListener on " + file.getName());
        Project project = FileOwnerQuery.getOwner((FileObject)file);
        if (project != null && (scopes = PersistenceScopes.getPersistenceScopes((Project)project)) != null) {
            PersistenceScopesListener listener = (PersistenceScopesListener)doc.getProperty(PERSISTENCE_SCOPES_LISTENER);
            if (listener == null) {
                listener = new PersistenceScopesListener(file);
                PropertyChangeListener weakListener = (PropertyChangeListener)WeakListeners.create(PropertyChangeListener.class, (EventListener)listener, null);
                scopes.addPropertyChangeListener(weakListener);
                doc.putProperty(PERSISTENCE_SCOPES_LISTENER, listener);
            }
            ArrayList<PersistenceXMLListener> pxmlListeners = new ArrayList<PersistenceXMLListener>();
            for (PersistenceScope scope : scopes.getPersistenceScopes()) {
                FileObject persistenceXML = scope.getPersistenceXml();
                if (persistenceXML == null) continue;
                PersistenceXMLListener pxmlListener = new PersistenceXMLListener(file);
                FileChangeListener weakPXMLListener = (FileChangeListener)WeakListeners.create(FileChangeListener.class, (EventListener)((Object)pxmlListener), null);
                persistenceXML.addFileChangeListener(weakPXMLListener);
                pxmlListeners.add(pxmlListener);
                LOG.fine("Added PersistenceXMLListener to " + persistenceXML.getName());
            }
            listener.setPXMLListeners(pxmlListeners);
        }
    }

    private class PersistenceScopesListener
    extends RescanTrigger
    implements PropertyChangeListener {
        List<PersistenceXMLListener> pxmlListeners;

        PersistenceScopesListener(FileObject file) {
            super(file);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            LOG.fine("Received a change event from PersistenceScopes");
            this.rescan();
        }

        void setPXMLListeners(List<PersistenceXMLListener> pxmlListeners) {
            this.pxmlListeners = pxmlListeners;
        }
    }

    private class PersistenceXMLListener
    extends RescanTrigger
    implements FileChangeListener {
        PersistenceXMLListener(FileObject file) {
            super(file);
        }

        public void fileChanged(FileEvent fe) {
            LOG.fine("Received a change event from persistence.xml");
            this.rescan();
        }

        public void fileFolderCreated(FileEvent fe) {
        }

        public void fileDataCreated(FileEvent fe) {
        }

        public void fileDeleted(FileEvent fe) {
        }

        public void fileRenamed(FileRenameEvent fe) {
        }

        public void fileAttributeChanged(FileAttributeEvent fe) {
        }
    }

    public static class ProblemFinderCompControl
    extends JPAProblemFinder
    implements CancellableTask<CompilationController> {
        public ProblemFinderCompControl(FileObject file) {
            super(file);
        }

        public void run(CompilationController controller) throws Exception {
            controller.toPhase(JavaSource.Phase.RESOLVED);
            super.run((CompilationInfo)controller);
        }
    }

    public static class ProblemFinderCompInfo
    extends JPAProblemFinder
    implements CancellableTask<CompilationInfo> {
        public ProblemFinderCompInfo(FileObject file) {
            super(file);
        }
    }

    private abstract class RescanTrigger {
        private FileObject file;

        RescanTrigger(FileObject file) {
            this.file = file;
        }

        void rescan() {
            JavaSource javaSrc = JavaSource.forFileObject((FileObject)this.file);
            if (javaSrc != null) {
                try {
                    javaSrc.runUserActionTask((Task)new ProblemFinderCompControl(this.file), true);
                }
                catch (IOException e) {
                    LOG.log(Level.FINE, e.getMessage(), e);
                }
            }
        }
    }
}

