/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.jpa.model;

import java.util.Collection;
import java.util.List;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;
import org.netbeans.modules.j2ee.jpa.model.AccessType;
import org.netbeans.modules.j2ee.jpa.model.JPAAnnotations;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.Attributes;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.Entity;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.MappedSuperclass;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.Table;

public class JPAHelper {
    public static boolean isAnyMemberAnnotatedAsIdOrEmbeddedId(Object modelObject) {
        Attributes attrs = null;
        if (modelObject instanceof Entity) {
            attrs = ((Entity)modelObject).getAttributes();
        } else if (modelObject instanceof MappedSuperclass) {
            attrs = ((MappedSuperclass)modelObject).getAttributes();
        }
        if (attrs != null) {
            if (attrs.getEmbeddedId() != null) {
                return true;
            }
            if (attrs.getId().length > 0) {
                return true;
            }
        }
        return false;
    }

    public static String getPrimaryTableName(Entity entity) {
        Table table = entity.getTable();
        return table != null ? table.getName() : null;
    }

    public static AnnotationMirror getFirstAnnotationFromGivenSet(Element element, Collection<String> searchedAnnotations) {
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            String annType = annotationMirror.getAnnotationType().toString();
            if (!searchedAnnotations.contains(annType)) continue;
            return annotationMirror;
        }
        return null;
    }

    public static AccessType findAccessType(TypeElement entityClass, Object modelElement) {
        AccessType accessType = AccessType.INDETERMINED;
        if (modelElement instanceof Entity) {
            String accessDef = ((Entity)modelElement).getAccess();
            if ("FIELD".equals(accessDef)) {
                accessType = AccessType.FIELD;
            } else if ("PROPERTY".equals(accessDef)) {
                accessType = AccessType.PROPERTY;
            }
        }
        for (Element element : entityClass.getEnclosedElements()) {
            AnnotationMirror ann;
            if (element.getKind() != ElementKind.FIELD && element.getKind() != ElementKind.METHOD || (ann = JPAHelper.getFirstAnnotationFromGivenSet(element, JPAAnnotations.MEMBER_LEVEL)) == null) continue;
            accessType = element.getKind() == ElementKind.FIELD ? AccessType.FIELD : AccessType.PROPERTY;
            break;
        }
        if (accessType.isDetermined()) {
            List<Element> otherElems = null;
            otherElems = accessType == AccessType.FIELD ? ElementFilter.methodsIn(entityClass.getEnclosedElements()) : ElementFilter.fieldsIn(entityClass.getEnclosedElements());
            for (Element element : otherElems) {
                AnnotationMirror ann = JPAHelper.getFirstAnnotationFromGivenSet(element, JPAAnnotations.MEMBER_LEVEL);
                if (ann == null) continue;
                accessType = AccessType.INCONSISTENT;
                break;
            }
        }
        return accessType;
    }
}

