/*
 * Decompiled with CFR 0.152.
 */
package org.nbheaven.sqe.codedefects.history.util;

import java.util.ArrayList;
import java.util.Date;
import org.nbheaven.sqe.codedefects.core.api.CodeDefectSeverity;
import org.nbheaven.sqe.codedefects.core.api.QualityProvider;
import org.nbheaven.sqe.codedefects.core.api.QualityResult;
import org.nbheaven.sqe.codedefects.core.api.QualityResultStatistic;
import org.nbheaven.sqe.codedefects.core.api.QualitySession;
import org.nbheaven.sqe.codedefects.core.util.SQECodedefectProperties;
import org.nbheaven.sqe.codedefects.history.History;
import org.netbeans.api.project.Project;

public final class CodeDefectHistoryPersistence {
    public static void addSnapshot(Project project) {
        History.Entry entry = new History.Entry(new Date(), CodeDefectHistoryPersistence.createSnapshot(project));
        History.getHistory(project).appendEntry(entry);
    }

    private static History.QualityProviderStatisticSnapshot[] createSnapshot(Project project) {
        ArrayList<History.QualityProviderStatisticSnapshot> snapshots = new ArrayList<History.QualityProviderStatisticSnapshot>();
        for (QualitySession session : project.getLookup().lookupAll(QualitySession.class)) {
            QualityResult result;
            if (!SQECodedefectProperties.isQualityProviderActive((Project)project, (QualityProvider)session.getProvider()) || null == (result = session.getResult())) continue;
            QualityResultStatistic statistic = (QualityResultStatistic)result.getLookup().lookup(QualityResultStatistic.class);
            long errors = statistic.getCodeDefectCount(CodeDefectSeverity.ERROR);
            long warns = statistic.getCodeDefectCount(CodeDefectSeverity.WARNING);
            long infos = statistic.getCodeDefectCount(CodeDefectSeverity.INFO);
            snapshots.add(new History.QualityProviderStatisticSnapshot(session.getProvider(), errors, warns, infos));
        }
        return snapshots.toArray(new History.QualityProviderStatisticSnapshot[snapshots.size()]);
    }
}

