/*
 * Decompiled with CFR 0.152.
 */
package org.nbheaven.sqe.codedefects.history.controlcenter.panels;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Paint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.HashSet;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import org.jdesktop.layout.GroupLayout;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.LogarithmicAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.StackedXYAreaRenderer2;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.xy.DefaultTableXYDataset;
import org.jfree.data.xy.TableXYDataset;
import org.jfree.data.xy.XYDataItem;
import org.jfree.data.xy.XYSeries;
import org.nbheaven.sqe.codedefects.core.api.CodeDefectSeverity;
import org.nbheaven.sqe.codedefects.core.api.QualityProvider;
import org.nbheaven.sqe.codedefects.core.api.QualityResultStatistic;
import org.nbheaven.sqe.codedefects.core.spi.SQEUtilities;
import org.nbheaven.sqe.codedefects.history.History;
import org.nbheaven.sqe.core.api.SQEManager;
import org.netbeans.api.project.Project;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public class SQEHistoryPanel
extends JPanel
implements PropertyChangeListener {
    private History activeHistory;
    private final DefaultTableXYDataset perProjectDataSet = new DefaultTableXYDataset();
    private JFreeChart historyChart;
    private JButton clearHistoryButton;
    private String[] providers = new String[0];
    private JPanel historyView;

    public SQEHistoryPanel() {
        this.historyChart = ChartFactory.createStackedXYAreaChart(null, (String)"Snapshot", (String)"CodeDefects", (TableXYDataset)this.perProjectDataSet, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)true, (boolean)false);
        this.historyChart.setBackgroundPaint((Paint)Color.WHITE);
        this.historyChart.getXYPlot().setRangeGridlinePaint((Paint)Color.BLACK);
        this.historyChart.getXYPlot().setDomainGridlinePaint((Paint)Color.BLACK);
        this.historyChart.getXYPlot().setBackgroundPaint((Paint)Color.WHITE);
        XYPlot plot = this.historyChart.getXYPlot();
        plot.setForegroundAlpha(0.7f);
        NumberAxis domainAxis = (NumberAxis)plot.getDomainAxis();
        domainAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        LogarithmicAxis rangeAxis = new LogarithmicAxis("CodeDefects");
        rangeAxis.setStrictValuesFlag(false);
        rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        plot.setRangeAxis((ValueAxis)rangeAxis);
        StackedXYAreaRenderer2 categoryItemRenderer = new StackedXYAreaRenderer2();
        categoryItemRenderer.setSeriesPaint(0, (Paint)Color.RED);
        categoryItemRenderer.setSeriesPaint(1, (Paint)Color.ORANGE);
        categoryItemRenderer.setSeriesPaint(2, (Paint)Color.YELLOW);
        plot.setRenderer((XYItemRenderer)categoryItemRenderer);
        ChartPanel historyChartPanel = new ChartPanel(this.historyChart);
        historyChartPanel.setBorder(null);
        historyChartPanel.setPreferredSize(new Dimension(150, 200));
        historyChartPanel.setBackground(Color.WHITE);
        this.initComponents();
        this.historyView.setLayout(new BorderLayout());
        this.historyView.add((Component)historyChartPanel, "Center");
        JPanel selectorPanel = new JPanel();
        selectorPanel.setOpaque(false);
        GroupLayout layout = new GroupLayout((Container)selectorPanel);
        selectorPanel.setLayout((LayoutManager)layout);
        layout.setAutocreateGaps(true);
        layout.setAutocreateContainerGaps(true);
        GroupLayout.ParallelGroup horizontalParallelGroup = layout.createParallelGroup(1);
        GroupLayout.SequentialGroup verticalSequentialGroup = layout.createSequentialGroup();
        layout.setHorizontalGroup((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)horizontalParallelGroup));
        layout.setVerticalGroup((GroupLayout.Group)verticalSequentialGroup);
        this.clearHistoryButton = new JButton();
        this.clearHistoryButton.setEnabled(false);
        this.clearHistoryButton.setIcon(ImageUtilities.image2Icon((Image)ImageUtilities.loadImage((String)"org/nbheaven/sqe/codedefects/history/resources/trash.png")));
        this.clearHistoryButton.setOpaque(false);
        this.clearHistoryButton.setFocusPainted(false);
        this.clearHistoryButton.setToolTipText(NbBundle.getBundle((String)"org/nbheaven/sqe/codedefects/history/controlcenter/panels/Bundle").getString("HINT_clear_button"));
        horizontalParallelGroup.add((Component)this.clearHistoryButton);
        verticalSequentialGroup.add((Component)this.clearHistoryButton);
        this.clearHistoryButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (null != SQEHistoryPanel.this.activeHistory) {
                    SQEHistoryPanel.this.activeHistory.clear();
                }
            }
        });
        Component createVerticalStrut = Box.createVerticalStrut(10);
        horizontalParallelGroup.add(createVerticalStrut);
        verticalSequentialGroup.add(createVerticalStrut);
        for (final QualityProvider provider : SQEUtilities.getProviders()) {
            final JToggleButton providerButton = new JToggleButton();
            providerButton.setIcon(provider.getIcon());
            providerButton.setOpaque(false);
            providerButton.setFocusPainted(false);
            horizontalParallelGroup.add((Component)providerButton);
            verticalSequentialGroup.add((Component)providerButton);
            ActionListener listener = new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (providerButton.isSelected()) {
                        SQEHistoryPanel.this.addSelectedProvider(provider);
                    } else {
                        SQEHistoryPanel.this.removeSelectedProvider(provider);
                    }
                    SQEHistoryPanel.this.updateView();
                }
            };
            providerButton.addActionListener(listener);
            this.addSelectedProvider(provider);
            providerButton.setSelected(true);
        }
        this.historyView.add((Component)selectorPanel, "East");
    }

    private String[] getSelectedProviders() {
        return this.providers;
    }

    private void setSelectedProviders(String[] providers) {
        this.providers = providers;
    }

    private void addSelectedProvider(QualityProvider provider) {
        HashSet<String> l = new HashSet<String>(Arrays.asList(this.getSelectedProviders()));
        l.add(provider.getId());
        this.setSelectedProviders(l.toArray(new String[l.size()]));
    }

    private void removeSelectedProvider(QualityProvider provider) {
        HashSet<String> l = new HashSet<String>(Arrays.asList(this.getSelectedProviders()));
        l.remove(provider.getId());
        this.setSelectedProviders(l.toArray(new String[l.size()]));
    }

    private void updateView() {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    SQEHistoryPanel.this.updateView();
                }
            });
            return;
        }
        assert (SwingUtilities.isEventDispatchThread());
        this.perProjectDataSet.removeAllSeries();
        XYSeries error = new XYSeries((Comparable)((Object)"Error"), true, false);
        XYSeries warning = new XYSeries((Comparable)((Object)"Warning"), true, false);
        XYSeries info = new XYSeries((Comparable)((Object)"Info"), true, false);
        if (null != this.activeHistory) {
            int i = 1;
            for (History.Entry entry : this.activeHistory) {
                QualityResultStatistic result = entry.get(this.getSelectedProviders());
                error.add(new XYDataItem((double)i, (double)result.getCodeDefectCount(CodeDefectSeverity.ERROR)));
                warning.add(new XYDataItem((double)i, (double)result.getCodeDefectCount(CodeDefectSeverity.WARNING)));
                info.add(new XYDataItem((double)i, (double)result.getCodeDefectCount(CodeDefectSeverity.INFO)));
                ++i;
            }
            this.clearHistoryButton.setEnabled(!this.activeHistory.isEmpty());
        }
        this.perProjectDataSet.addSeries(error);
        this.perProjectDataSet.addSeries(warning);
        this.perProjectDataSet.addSeries(info);
        this.invalidate();
        this.revalidate();
        this.repaint();
    }

    private void setActiveProject(Project project) {
        if (null != this.activeHistory) {
            this.activeHistory.removePropertyChangeListener(History.PROP_HISTORY_CHANGED, this);
        }
        if (null != project) {
            this.activeHistory = History.getHistory(project);
            this.activeHistory.addPropertyChangeListener(History.PROP_HISTORY_CHANGED, this);
        } else {
            this.activeHistory = null;
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if ("PropActiveProject".equals(evt.getPropertyName())) {
            this.setActiveProject((Project)evt.getNewValue());
        }
        this.updateView();
    }

    public void addNotify() {
        super.addNotify();
        this.setActiveProject(SQEManager.getDefault().getActiveProject());
        SQEManager.getDefault().addPropertyChangeListener("PropActiveProject", (PropertyChangeListener)this);
        this.updateView();
    }

    public void removeNotify() {
        SQEManager.getDefault().removePropertyChangeListener("PropActiveProject", (PropertyChangeListener)this);
        this.setActiveProject(null);
        super.removeNotify();
    }

    private void initComponents() {
        this.historyView = new JPanel();
        this.setBackground(new Color(255, 255, 255));
        this.historyView.setBorder(null);
        this.historyView.setOpaque(false);
        GroupLayout historyViewLayout = new GroupLayout((Container)this.historyView);
        this.historyView.setLayout((LayoutManager)historyViewLayout);
        historyViewLayout.setHorizontalGroup((GroupLayout.Group)historyViewLayout.createParallelGroup(1).add(0, 305, Short.MAX_VALUE));
        historyViewLayout.setVerticalGroup((GroupLayout.Group)historyViewLayout.createParallelGroup(1).add(0, 108, Short.MAX_VALUE));
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.historyView, -1, -1, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.historyView, -1, -1, Short.MAX_VALUE).addContainerGap()));
    }
}

