/*
 * Decompiled with CFR 0.152.
 */
package org.nbheaven.sqe.codedefects.history.action;

import java.awt.EventQueue;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.util.Collection;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.nbheaven.sqe.codedefects.core.api.QualitySession;
import org.nbheaven.sqe.codedefects.history.util.CodeDefectHistoryPersistence;
import org.netbeans.api.project.Project;
import org.openide.util.ContextAwareAction;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class SnapshotAction
extends AbstractAction
implements LookupListener,
ContextAwareAction {
    private Lookup context;
    private Lookup.Result<Project> lkpInfo;

    public SnapshotAction() {
        this(Utilities.actionsGlobalContext());
    }

    public SnapshotAction(Lookup context) {
        this.putValue("noIconInMenu", Boolean.TRUE);
        this.putValue("ShortDescription", NbBundle.getMessage(SnapshotAction.class, (String)"HINT_Action"));
        this.putValue("SmallIcon", ImageUtilities.image2Icon((Image)ImageUtilities.loadImage((String)"org/nbheaven/sqe/codedefects/history/resources/camera.png")));
        this.context = context;
        Lookup.Template tpl = new Lookup.Template(Project.class);
        this.lkpInfo = context.lookup(tpl);
        this.lkpInfo.addLookupListener((LookupListener)this);
        this.resultChanged(null);
    }

    public Action createContextAwareInstance(Lookup context) {
        return new SnapshotAction(context);
    }

    public void resultChanged(LookupEvent ev) {
        this.updateEnableState();
    }

    public String getName() {
        return NbBundle.getMessage(SnapshotAction.class, (String)"LBL_Action");
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (null != this.getActiveProject()) {
            Project project = this.getActiveProject();
            CodeDefectHistoryPersistence.addSnapshot(project);
        }
    }

    private void updateEnableState() {
        if (!EventQueue.isDispatchThread()) {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    SnapshotAction.this.updateEnableState();
                }
            });
            return;
        }
        Project project = this.getActiveProject();
        this.setEnabled(null != project && null != project.getLookup().lookup(QualitySession.class));
    }

    private Project getActiveProject() {
        Collection projects = this.lkpInfo.allInstances();
        if (projects.size() == 1) {
            Project project = (Project)projects.iterator().next();
            return project;
        }
        return null;
    }
}

