/*
 * Decompiled with CFR 0.152.
 */
package org.nbheaven.sqe.codedefects.history;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.prefs.Preferences;
import org.nbheaven.sqe.codedefects.core.api.CodeDefectSeverity;
import org.nbheaven.sqe.codedefects.core.api.QualityProvider;
import org.nbheaven.sqe.codedefects.core.api.QualityResultStatistic;
import org.netbeans.api.project.Project;
import org.openide.filesystems.FileAlreadyLockedException;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.util.Exceptions;
import org.openide.util.NbCollections;
import org.openide.util.NbPreferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class History
implements Iterable<Entry> {
    public static String PROP_HISTORY_CHANGED = "prop_history_changed";
    private final LinkedList<Entry> entries;
    private final Project project;
    private final PropertyChangeSupport propertyChangeSupport;
    private static Map<Project, WeakReference<History>> historyCache = new HashMap<Project, WeakReference<History>>();

    private History(Project project, LinkedList<Entry> entries) {
        this.entries = entries;
        this.project = project;
        this.propertyChangeSupport = new PropertyChangeSupport(this);
    }

    public Project getProject() {
        return this.project;
    }

    public void appendEntry(Entry entry) {
        this.entries.add(entry);
        this.flush();
        this.fireHistoryChanged();
    }

    @Override
    public Iterator<Entry> iterator() {
        return this.entries.iterator();
    }

    public void addPropertyChangeListener(String property, PropertyChangeListener pcl) {
        this.propertyChangeSupport.addPropertyChangeListener(property, pcl);
    }

    public void removePropertyChangeListener(String property, PropertyChangeListener pcl) {
        this.propertyChangeSupport.removePropertyChangeListener(property, pcl);
    }

    private void fireHistoryChanged() {
        this.propertyChangeSupport.firePropertyChange(PROP_HISTORY_CHANGED, null, this.entries);
    }

    public String toString() {
        return this.entries.toString();
    }

    public void clear() {
        this.entries.clear();
        this.flush();
        this.fireHistoryChanged();
    }

    public boolean isEmpty() {
        return this.entries.isEmpty();
    }

    private void flush() {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            ObjectOutputStream stream = new ObjectOutputStream(os);
            stream.writeObject(this.entries);
            stream.close();
            Preferences historyPrefs = NbPreferences.forModule(History.class);
            historyPrefs.putByteArray(this.project.getProjectDirectory().getURL().toString(), os.toByteArray());
        }
        catch (FileAlreadyLockedException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static LinkedList<Entry> read(byte[] historyData) {
        ByteArrayInputStream is = null;
        LinkedList<Entry> entries = new LinkedList<Entry>();
        if (null != historyData && historyData.length > 0) {
            try {
                is = new ByteArrayInputStream(historyData);
                ObjectInputStream stream = new ObjectInputStream(is);
                entries.addAll(NbCollections.checkedListByCopy((List)((LinkedList)stream.readObject()), Entry.class, (boolean)true));
                stream.close();
            }
            catch (ClassNotFoundException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            finally {
                try {
                    ((InputStream)is).close();
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
        return entries;
    }

    public static synchronized History getHistory(Project project) {
        byte[] historyData;
        History history;
        WeakReference<History> historyRef = historyCache.get(project);
        if (null != historyRef && null != (history = (History)historyRef.get())) {
            return history;
        }
        Preferences historyPrefs = NbPreferences.forModule(History.class);
        try {
            historyData = historyPrefs.getByteArray(project.getProjectDirectory().getURL().toString(), new byte[0]);
        }
        catch (FileStateInvalidException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            historyData = null;
        }
        History history2 = new History(project, History.read(historyData));
        historyCache.put(project, new WeakReference<History>(history2));
        return history2;
    }

    public static final class Entry
    implements Serializable {
        static final long serialVersionUID = 42L;
        private final QualityProviderStatisticSnapshot[] snapshots;
        private final Date date;

        public Entry(Date date, QualityProviderStatisticSnapshot ... snapshots) {
            this.date = date;
            this.snapshots = null == snapshots ? new QualityProviderStatisticSnapshot[]{} : snapshots;
        }

        public Date getDate() {
            return this.date;
        }

        public QualityProviderStatisticSnapshot[] getSnapshots() {
            return this.snapshots;
        }

        public QualityResultStatistic get(String ... providerIds) {
            long errors = 0L;
            long warnings = 0L;
            long infos = 0L;
            for (QualityProviderStatisticSnapshot snapshot : this.getSnapshotsForProviders(providerIds)) {
                errors += snapshot.getErrors();
                warnings += snapshot.getWarnings();
                infos += snapshot.getInfos();
            }
            return new QualityResultStatisticEntry(errors, warnings, infos);
        }

        private QualityProviderStatisticSnapshot[] getSnapshotsForProviders(String ... ids) {
            ArrayList<QualityProviderStatisticSnapshot> selectedSnapshots = new ArrayList<QualityProviderStatisticSnapshot>();
            for (String id : ids) {
                for (QualityProviderStatisticSnapshot snapshot : this.snapshots) {
                    if (!snapshot.providerId.equals(id)) continue;
                    selectedSnapshots.add(snapshot);
                }
            }
            return selectedSnapshots.toArray(new QualityProviderStatisticSnapshot[selectedSnapshots.size()]);
        }

        public String toString() {
            return this.date + ": " + Arrays.toString(this.snapshots);
        }

        private static class QualityResultStatisticEntry
        implements QualityResultStatistic {
            private final long errors;
            private final long warnings;
            private final long infos;
            private final long sum;

            public QualityResultStatisticEntry(long errors, long warnings, long infos) {
                this.errors = errors;
                this.warnings = warnings;
                this.infos = infos;
                this.sum = infos + warnings + errors;
            }

            public long getCodeDefectCountSum() {
                return this.sum;
            }

            public long getCodeDefectCount(CodeDefectSeverity severity) {
                switch (severity) {
                    case ERROR: {
                        return this.errors;
                    }
                    case WARNING: {
                        return this.warnings;
                    }
                    case INFO: {
                        return this.infos;
                    }
                }
                return 0L;
            }
        }
    }

    public static final class QualityProviderStatisticSnapshot
    implements Serializable {
        static final long serialVersionUID = 42L;
        private final long errors;
        private final long warnings;
        private final long infos;
        private final String providerId;

        public QualityProviderStatisticSnapshot(QualityProvider provider, long errors, long warnings, long infos) {
            this.errors = errors;
            this.warnings = warnings;
            this.infos = infos;
            this.providerId = provider.getId();
        }

        public String getProviderId() {
            return this.providerId;
        }

        public long getErrors() {
            return this.errors;
        }

        public long getInfos() {
            return this.infos;
        }

        public long getWarnings() {
            return this.warnings;
        }

        public String toString() {
            return this.providerId + ": E(" + this.errors + ") W(" + this.warnings + ") I(" + this.infos + ")";
        }
    }
}

