/*
 * Decompiled with CFR 0.152.
 */
package org.nbheaven.sqe.tools.findbugs.codedefects.projects.freeform;

import edu.umd.cs.findbugs.config.UserPreferences;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.prefs.Preferences;
import org.nbheaven.sqe.core.ant.AntUtilities;
import org.nbheaven.sqe.tools.findbugs.codedefects.core.settings.FindBugsSettings;
import org.nbheaven.sqe.tools.findbugs.codedefects.core.settings.FindBugsSettingsProvider;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.openide.util.Exceptions;

public class FindBugsSettingsProviderImpl
extends FindBugsSettingsProvider {
    private static final String FINDBUGS_SETTINGS_FILE = "findbugs.settings.file";
    private static final String FINDBUGS_INCLUDE_FILTER = "findbugs.include.filter";
    private static final String FINDBUGS_EXCLUDE_FILTER = "findbugs.exclude.filter";
    private static final String FINDBUGS_SETTINGS_DEFAULT = "nbproject/findbugs.settings";
    private Project project;

    public FindBugsSettingsProviderImpl(Project project) {
        this.project = project;
    }

    private File getFindBugsSettingsFile() {
        String settingsFile = AntUtilities.evaluate((String)this.prefs().get(FINDBUGS_SETTINGS_FILE, FINDBUGS_SETTINGS_DEFAULT), (Project)this.project);
        return AntUtilities.resolveFile((String)settingsFile, (Project)this.project);
    }

    public UserPreferences getFindBugsSettings() {
        File findBugsSettingsFile = this.getFindBugsSettingsFile();
        if (findBugsSettingsFile.isFile()) {
            UserPreferences prefs = UserPreferences.createDefaultUserPreferences();
            try {
                prefs.read((InputStream)new FileInputStream(findBugsSettingsFile));
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            return prefs;
        }
        UserPreferences globalDefaultPreferences = FindBugsSettings.getUserPreferences();
        this.presetPreferences(globalDefaultPreferences);
        return globalDefaultPreferences;
    }

    public void setFindBugsSettings(UserPreferences userPreferences) {
        File findBugsSettingsFile = this.getFindBugsSettingsFile();
        findBugsSettingsFile.getParentFile().mkdirs();
        try {
            userPreferences.write((OutputStream)new FileOutputStream(findBugsSettingsFile));
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public String getExcludeFilter() {
        String excludeFile = AntUtilities.evaluate((String)this.prefs().get(FINDBUGS_EXCLUDE_FILTER, null), (Project)this.project);
        if (null == excludeFile) {
            return null;
        }
        return AntUtilities.resolveFile((String)excludeFile, (Project)this.project).getAbsolutePath();
    }

    public String getIncludeFilter() {
        String includeFile = AntUtilities.evaluate((String)this.prefs().get(FINDBUGS_INCLUDE_FILTER, null), (Project)this.project);
        if (null == includeFile) {
            return null;
        }
        return AntUtilities.resolveFile((String)includeFile, (Project)this.project).getAbsolutePath();
    }

    private Preferences prefs() {
        return ProjectUtils.getPreferences((Project)this.project, FindBugsSettingsProviderImpl.class, (boolean)true);
    }
}

