/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.suggestions;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import java.awt.Toolkit;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.EditorRegistry;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.GeneratorUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.ModificationResult;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.java.source.support.CaretAwareJavaSourceTaskFactory;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.java.editor.codegen.ConstructorGenerator;
import org.netbeans.modules.java.editor.codegen.GeneratorUtils;
import org.netbeans.modules.java.hints.suggestions.NameAndPackagePanel;
import org.netbeans.modules.parsing.impl.indexing.friendapi.IndexingController;
import org.netbeans.spi.editor.codegen.CodeGenerator;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.java.hints.ErrorDescriptionFactory;
import org.netbeans.spi.java.hints.HintContext;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.lookup.Lookups;

public class CreateSubclass {
    public static ErrorDescription check(HintContext context) {
        TreePath tp = context.getPath();
        ClassTree cls = (ClassTree)tp.getLeaf();
        CompilationInfo info = context.getInfo();
        SourcePositions sourcePositions = info.getTrees().getSourcePositions();
        int startPos = (int)sourcePositions.getStartPosition(tp.getCompilationUnit(), cls);
        int caret = CaretAwareJavaSourceTaskFactory.getLastPosition((FileObject)context.getInfo().getFileObject());
        String code = context.getInfo().getText();
        if (startPos < 0 || caret < 0 || caret < startPos || caret >= code.length()) {
            return null;
        }
        String headerText = code.substring(startPos, caret);
        int idx = headerText.indexOf(123);
        if (idx >= 0) {
            return null;
        }
        TypeElement typeElement = (TypeElement)info.getTrees().getElement(tp);
        if (typeElement.getModifiers().contains((Object)Modifier.FINAL)) {
            return null;
        }
        ClassPath cp = info.getClasspathInfo().getClassPath(ClasspathInfo.PathKind.SOURCE);
        FileObject root = cp.findOwnerRoot(info.getFileObject());
        if (root == null) {
            return null;
        }
        PackageElement packageElement = (PackageElement)info.getElementUtilities().outermostTypeElement((Element)typeElement).getEnclosingElement();
        CreateSubclassFix fix = new CreateSubclassFix(info, root, packageElement.getQualifiedName().toString(), typeElement.getSimpleName().toString() + "Impl", typeElement);
        return ErrorDescriptionFactory.forTree((HintContext)context, (TreePath)context.getPath(), (String)NbBundle.getMessage(CreateSubclass.class, (String)(typeElement.getKind() == ElementKind.CLASS ? (typeElement.getModifiers().contains((Object)Modifier.ABSTRACT) ? "ERR_ImplementAbstractClass" : "ERR_CreateSubclass") : "ERR_ImplementInterface")), (Fix[])new Fix[]{fix});
    }

    private static final class CreateSubclassFix
    implements Fix,
    PropertyChangeListener {
        private FileObject targetSourceRoot;
        private String packageName;
        private String simpleName;
        private ElementHandle<TypeElement> superType;
        private boolean isAbstract;
        private boolean hasNonDefaultConstructor = false;
        private FileObject target = null;

        public CreateSubclassFix(CompilationInfo info, FileObject targetSourceRoot, String packageName, String simpleName, TypeElement typeElement) {
            this.targetSourceRoot = targetSourceRoot;
            this.packageName = packageName;
            this.simpleName = simpleName;
            this.isAbstract = typeElement.getModifiers().contains((Object)Modifier.ABSTRACT);
            this.superType = ElementHandle.create((Element)typeElement);
        }

        public String getText() {
            return NbBundle.getMessage(CreateSubclass.class, (String)(this.superType.getKind() == ElementKind.CLASS ? (this.isAbstract ? "FIX_ImplementAbstractClass" : "FIX_CreateSubclass") : "FIX_ImplementInterface"));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ChangeInfo implement() throws Exception {
            IndexingController.getDefault().enterProtectedMode();
            try {
                final NameAndPackagePanel panel = new NameAndPackagePanel(this.simpleName, this.packageName);
                final DialogDescriptor desc = new DialogDescriptor((Object)panel, this.getText());
                panel.addPropertyChangeListener(new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent evt) {
                        if ("NameAndPackagePanel.isValidData".equals(evt.getPropertyName())) {
                            desc.setValid(panel.isValidData());
                        }
                    }
                });
                desc.setValid(panel.isValidData());
                if (DialogDisplayer.getDefault().notify((NotifyDescriptor)desc) != DialogDescriptor.OK_OPTION) {
                    ChangeInfo changeInfo = null;
                    return changeInfo;
                }
                this.simpleName = panel.getClassName();
                this.packageName = panel.getPackageName();
                EditorRegistry.addPropertyChangeListener((PropertyChangeListener)this);
                final String path = this.packageName.replace('.', '/') + '/' + this.simpleName + ".java";
                this.target = this.targetSourceRoot.getFileObject(path);
                JavaSource js = this.target != null ? JavaSource.forFileObject((FileObject)this.target) : JavaSource.create((ClasspathInfo)ClasspathInfo.create((FileObject)this.targetSourceRoot), (FileObject[])new FileObject[0]);
                ModificationResult result = js.runModificationTask((Task)new Task<WorkingCopy>(){

                    public void run(WorkingCopy parameter) throws Exception {
                        parameter.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                        TypeElement superTypeElement = (TypeElement)CreateSubclassFix.this.superType.resolve((CompilationInfo)parameter);
                        if (superTypeElement != null) {
                            TreeMaker make = parameter.getTreeMaker();
                            CompilationUnitTree cut = parameter.getFileObject() != null ? parameter.getCompilationUnit() : GeneratorUtilities.get((WorkingCopy)parameter).createFromTemplate(CreateSubclassFix.this.targetSourceRoot, path, ElementKind.CLASS);
                            ClassTree source = (ClassTree)cut.getTypeDecls().get(0);
                            if (superTypeElement.getKind() == ElementKind.CLASS) {
                                Element el = parameter.getTrees().getElement(TreePath.getPath(cut, (Tree)source));
                                if (el instanceof TypeElement) {
                                    TypeMirror sup = ((TypeElement)el).getSuperclass();
                                    if (!parameter.getTypes().isSubtype(superTypeElement.asType(), sup)) {
                                        StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(CreateSubclass.class, (String)"ERR_IncompatibleSupertype", (Object)el.getSimpleName()));
                                        Toolkit.getDefaultToolkit().beep();
                                        return;
                                    }
                                }
                                parameter.rewrite((Tree)source, (Tree)make.Class(source.getModifiers(), (CharSequence)CreateSubclassFix.this.simpleName, source.getTypeParameters(), make.Type(superTypeElement.asType()), source.getImplementsClause(), source.getMembers()));
                                for (ExecutableElement ctor : ElementFilter.constructorsIn(superTypeElement.getEnclosedElements())) {
                                    if (ctor.getParameters().isEmpty()) continue;
                                    CreateSubclassFix.this.hasNonDefaultConstructor = true;
                                    break;
                                }
                            } else {
                                List<? extends Tree> impls = source.getImplementsClause();
                                ArrayList<? extends Tree> newImpls = new ArrayList<Tree>(impls.size() + 1);
                                newImpls.addAll(impls);
                                newImpls.add(make.Type(superTypeElement.asType()));
                                parameter.rewrite((Tree)source, (Tree)make.Class(source.getModifiers(), (CharSequence)source.getSimpleName(), source.getTypeParameters(), source.getExtendsClause(), newImpls, source.getMembers()));
                            }
                            if (parameter.getFileObject() == null) {
                                parameter.rewrite(null, (Tree)cut);
                            }
                        }
                    }
                });
                result.commit();
                if (!this.hasNonDefaultConstructor && !this.isAbstract) {
                    EditorRegistry.removePropertyChangeListener((PropertyChangeListener)this);
                }
                if (this.target == null) {
                    Iterator it = result.getNewFiles().iterator();
                    this.target = it.hasNext() ? FileUtil.toFileObject((File)((File)it.next())) : null;
                }
                ChangeInfo changeInfo = this.target != null ? new ChangeInfo(this.target, null, null) : null;
                return changeInfo;
            }
            finally {
                IndexingController.getDefault().exitProtectedMode(null);
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            FileObject fo;
            final JTextComponent component = EditorRegistry.focusedComponent();
            FileObject fileObject = fo = component != null ? NbEditorUtilities.getFileObject((Document)component.getDocument()) : null;
            if (this.target == null || this.target != fo) {
                return;
            }
            EditorRegistry.removePropertyChangeListener((PropertyChangeListener)this);
            RequestProcessor.getDefault().post(new Runnable(){

                @Override
                public void run() {
                    try {
                        JavaSource js = JavaSource.forDocument((Document)component.getDocument());
                        js.runModificationTask((Task)new Task<WorkingCopy>(){

                            public void run(WorkingCopy parameter) throws Exception {
                                parameter.toPhase(JavaSource.Phase.RESOLVED);
                                CompilationUnitTree cut = parameter.getCompilationUnit();
                                TreePath path = TreePath.getPath(cut, cut.getTypeDecls().get(0));
                                if (CreateSubclassFix.this.isAbstract) {
                                    GeneratorUtils.generateAllAbstractMethodImplementations((WorkingCopy)parameter, (TreePath)path);
                                }
                                if (CreateSubclassFix.this.hasNonDefaultConstructor) {
                                    ConstructorGenerator.Factory factory = new ConstructorGenerator.Factory();
                                    Iterator generators = factory.create(Lookups.fixed((Object[])new Object[]{component, parameter, path})).iterator();
                                    if (generators.hasNext()) {
                                        ((CodeGenerator)generators.next()).invoke();
                                    }
                                }
                            }
                        }).commit();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            });
        }
    }
}

