/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.perf;

import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.ParameterizedTypeTree;
import com.sun.source.tree.ParenthesizedTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Set;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.java.hints.errors.Utilities;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.java.hints.ErrorDescriptionFactory;
import org.netbeans.spi.java.hints.HintContext;
import org.netbeans.spi.java.hints.JavaFix;
import org.netbeans.spi.java.hints.JavaFixUtilities;
import org.netbeans.spi.java.hints.MatcherUtilities;
import org.openide.util.NbBundle;

public class Tiny {
    static final boolean SC_IGNORE_SUBSTRING_DEFAULT = true;
    static final String SC_IGNORE_SUBSTRING = "ignore.substring";
    private static final Set<Tree.Kind> KEEP_PARENTHESIS = EnumSet.of(Tree.Kind.MEMBER_SELECT);

    public static ErrorDescription stringConstructor(HintContext ctx) {
        TreePath original = (TreePath)ctx.getVariables().get("$original");
        if (ctx.getPreferences().getBoolean(SC_IGNORE_SUBSTRING, true) && (MatcherUtilities.matches((HintContext)ctx, (TreePath)original, (String)"$str1.substring($s)", (boolean)true) || MatcherUtilities.matches((HintContext)ctx, (TreePath)original, (String)"$str2.substring($s, $e)", (boolean)true))) {
            TypeElement te;
            TreePath str;
            TreePath treePath = str = ctx.getVariables().get("$str1") != null ? (TreePath)ctx.getVariables().get("$str1") : (TreePath)ctx.getVariables().get("$str2");
            assert (str != null);
            TypeMirror type = ctx.getInfo().getTrees().getTypeMirror(str);
            if (type != null && type.getKind() == TypeKind.DECLARED && (te = (TypeElement)((DeclaredType)type).asElement()).getQualifiedName().contentEquals("java.lang.String")) {
                return null;
            }
        }
        String fixDisplayName = NbBundle.getMessage(Tiny.class, (String)"FIX_StringConstructor");
        Fix f = JavaFixUtilities.rewriteFix((HintContext)ctx, (String)fixDisplayName, (TreePath)ctx.getPath(), (String)"$original");
        String displayName = NbBundle.getMessage(Tiny.class, (String)"ERR_StringConstructor");
        return ErrorDescriptionFactory.forTree((HintContext)ctx, (TreePath)ctx.getPath(), (String)displayName, (Fix[])new Fix[]{f});
    }

    public static ErrorDescription stringEqualsEmpty(HintContext ctx) {
        Fix f;
        if (ctx.getInfo().getSourceVersion().compareTo(SourceVersion.RELEASE_6) >= 0) {
            String fixDisplayName = NbBundle.getMessage(Tiny.class, (String)"FIX_StringEqualsEmpty16");
            f = JavaFixUtilities.rewriteFix((HintContext)ctx, (String)fixDisplayName, (TreePath)ctx.getPath(), (String)"$string.isEmpty()");
        } else {
            boolean not = ctx.getPath().getParentPath().getLeaf().getKind() == Tree.Kind.LOGICAL_COMPLEMENT;
            String fixDisplayName = NbBundle.getMessage(Tiny.class, (String)(not ? "FIX_StringEqualsEmptyNeg" : "FIX_StringEqualsEmpty"));
            f = JavaFixUtilities.rewriteFix((HintContext)ctx, (String)fixDisplayName, (TreePath)(not ? ctx.getPath().getParentPath() : ctx.getPath()), (String)(not ? "$string.length() != 0" : "$string.length() == 0"));
        }
        String displayName = NbBundle.getMessage(Tiny.class, (String)"ERR_StringEqualsEmpty");
        return ErrorDescriptionFactory.forTree((HintContext)ctx, (TreePath)ctx.getPath(), (String)displayName, (Fix[])new Fix[]{f});
    }

    public static ErrorDescription lengthOneStringIndexOf(HintContext ctx) {
        TreePath toSearch = (TreePath)ctx.getVariables().get("$toSearch");
        if (toSearch.getLeaf().getKind() != Tree.Kind.STRING_LITERAL) {
            return null;
        }
        LiteralTree lt = (LiteralTree)toSearch.getLeaf();
        final String data = (String)lt.getValue();
        if (data.length() != 1) {
            return null;
        }
        int start = (int)ctx.getInfo().getTrees().getSourcePositions().getStartPosition(ctx.getInfo().getCompilationUnit(), toSearch.getLeaf());
        int end = (int)ctx.getInfo().getTrees().getSourcePositions().getEndPosition(ctx.getInfo().getCompilationUnit(), toSearch.getLeaf());
        final String literal = ctx.getInfo().getText().substring(start, end);
        Fix f = new JavaFix(ctx.getInfo(), toSearch){

            protected String getText() {
                return NbBundle.getMessage(Tiny.class, (String)"FIX_LengthOneStringIndexOf");
            }

            protected void performRewrite(JavaFix.TransformationContext ctx) {
                String content;
                WorkingCopy wc = ctx.getWorkingCopy();
                TreePath tp = ctx.getPath();
                if ("'".equals(data)) {
                    content = "\\'";
                } else if ("\"".equals(data)) {
                    content = "\"";
                } else {
                    content = literal;
                    if (content.length() > 0 && content.charAt(0) == '\"') {
                        content = content.substring(1);
                    }
                    if (content.length() > 0 && content.charAt(content.length() - 1) == '\"') {
                        content = content.substring(0, content.length() - 1);
                    }
                }
                wc.rewrite(tp.getLeaf(), (Tree)wc.getTreeMaker().Identifier((CharSequence)("'" + content + "'")));
            }
        }.toEditorFix();
        String displayName = NbBundle.getMessage(Tiny.class, (String)"ERR_LengthOneStringIndexOf", (Object)literal);
        return ErrorDescriptionFactory.forTree((HintContext)ctx, (TreePath)toSearch, (String)displayName, (Fix[])new Fix[]{f});
    }

    public static ErrorDescription getClassInsteadOfDotClass(HintContext ctx) {
        TreePath O = (TreePath)ctx.getVariables().get("$O");
        if (O.getLeaf().getKind() == Tree.Kind.PARAMETERIZED_TYPE) {
            O = new TreePath(O, ((ParameterizedTypeTree)O.getLeaf()).getType());
        }
        ctx.getVariables().put("$OO", O);
        String fixDisplayName = NbBundle.getMessage(Tiny.class, (String)"FIX_GetClassInsteadOfDotClass");
        Fix f = JavaFixUtilities.rewriteFix((HintContext)ctx, (String)fixDisplayName, (TreePath)ctx.getPath(), (String)"$OO.class");
        String displayName = NbBundle.getMessage(Tiny.class, (String)"ERR_GetClassInsteadOfDotClass");
        return ErrorDescriptionFactory.forTree((HintContext)ctx, (TreePath)ctx.getPath(), (String)displayName, (Fix[])new Fix[]{f});
    }

    public static ErrorDescription constantIntern(HintContext ctx) {
        String target;
        TreePath str = (TreePath)ctx.getVariables().get("$str");
        TreePath constant = str.getLeaf().getKind() == Tree.Kind.PARENTHESIZED ? new TreePath(str, ((ParenthesizedTree)str.getLeaf()).getExpression()) : str;
        if (!Utilities.isConstantString(ctx.getInfo(), constant)) {
            return null;
        }
        String fixDisplayName = NbBundle.getMessage(Tiny.class, (String)"FIX_ConstantIntern");
        if (constant != str && KEEP_PARENTHESIS.contains((Object)ctx.getPath().getParentPath().getLeaf().getKind())) {
            target = "$str";
        } else {
            target = "$constant";
            ctx.getVariables().put("$constant", constant);
        }
        Fix f = JavaFixUtilities.rewriteFix((HintContext)ctx, (String)fixDisplayName, (TreePath)ctx.getPath(), (String)target);
        String displayName = NbBundle.getMessage(Tiny.class, (String)"ERR_ConstantIntern");
        return ErrorDescriptionFactory.forTree((HintContext)ctx, (TreePath)ctx.getPath(), (String)displayName, (Fix[])new Fix[]{f});
    }

    public static ErrorDescription enumSet(HintContext ctx) {
        return Tiny.enumHint(ctx, "java.util.Set", null, "ERR_Tiny_enumSet", new Fix[0]);
    }

    public static ErrorDescription enumMap(HintContext ctx) {
        Fix[] fixes;
        Collection mvars = (Collection)ctx.getMultiVariables().get("$params$");
        if (mvars != null && mvars.isEmpty()) {
            String displayName = NbBundle.getMessage(Tiny.class, (String)"FIX_Tiny_enumMap");
            fixes = new Fix[]{JavaFixUtilities.rewriteFix((HintContext)ctx, (String)displayName, (TreePath)ctx.getPath(), (String)"new java.util.EnumMap<$param, $to>($param.class)")};
        } else {
            fixes = new Fix[]{};
        }
        return Tiny.enumHint(ctx, "java.util.Map", "java.util.EnumMap", "ERR_Tiny_enumMap", fixes);
    }

    private static ErrorDescription enumHint(HintContext ctx, String baseName, String targetTypeName, String key, Fix ... fixes) {
        Element type = ctx.getInfo().getTrees().getElement((TreePath)ctx.getVariables().get("$param"));
        if (type == null || type.getKind() != ElementKind.ENUM) {
            return null;
        }
        Element coll = ctx.getInfo().getTrees().getElement((TreePath)ctx.getVariables().get("$coll"));
        if (coll == null || coll.getKind() != ElementKind.CLASS) {
            return null;
        }
        TypeElement base = ctx.getInfo().getElements().getTypeElement(baseName);
        if (base == null) {
            return null;
        }
        Types t = ctx.getInfo().getTypes();
        if (!t.isSubtype(t.erasure(coll.asType()), t.erasure(base.asType()))) {
            return null;
        }
        if (targetTypeName != null) {
            TypeElement target = ctx.getInfo().getElements().getTypeElement(targetTypeName);
            if (target == null) {
                return null;
            }
            if (t.isSubtype(t.erasure(coll.asType()), t.erasure(target.asType()))) {
                return null;
            }
        }
        String displayName = NbBundle.getMessage(Tiny.class, (String)key);
        return ErrorDescriptionFactory.forName((HintContext)ctx, (TreePath)ctx.getPath(), (String)displayName, (Fix[])fixes);
    }

    public static ErrorDescription collectionsToArray(HintContext ctx) {
        Fix[] fixes;
        boolean pureMemberSelect = true;
        TreePath tp = (TreePath)ctx.getVariables().get("$collection");
        if (tp == null) {
            return null;
        }
        Tree msTest = tp.getLeaf();
        block4: while (true) {
            switch (msTest.getKind()) {
                case IDENTIFIER: {
                    break block4;
                }
                case MEMBER_SELECT: {
                    msTest = ((MemberSelectTree)msTest).getExpression();
                    continue block4;
                }
                default: {
                    pureMemberSelect = false;
                    break block4;
                }
            }
            break;
        }
        if (pureMemberSelect) {
            String fixDisplayName = NbBundle.getMessage(Tiny.class, (String)"FIX_Tiny_collectionsToArray");
            fixes = new Fix[]{JavaFixUtilities.rewriteFix((HintContext)ctx, (String)fixDisplayName, (TreePath)ctx.getPath(), (String)"$collection.toArray(new $clazz[$collection.size()])")};
        } else {
            fixes = new Fix[]{};
        }
        String displayName = NbBundle.getMessage(Tiny.class, (String)"ERR_Tiny_collectionsToArray");
        return ErrorDescriptionFactory.forName((HintContext)ctx, (TreePath)ctx.getPath(), (String)displayName, (Fix[])fixes);
    }
}

