/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.jdk;

import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.ParameterizedTypeTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.prefs.Preferences;
import javax.swing.JComponent;
import javax.tools.Diagnostic;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.java.hints.jdk.ConvertToDiamondBulkHintPanel;
import org.netbeans.modules.java.hints.providers.spi.HintMetadata;
import org.netbeans.modules.java.hints.spiimpl.RulesManager;
import org.netbeans.modules.java.hints.spiimpl.options.HintsSettings;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.ErrorDescriptionFactory;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.editor.hints.Severity;
import org.netbeans.spi.java.hints.CustomizerProvider;
import org.netbeans.spi.java.hints.HintContext;
import org.netbeans.spi.java.hints.JavaFix;
import org.netbeans.spi.java.hints.MatcherUtilities;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class ConvertToDiamondBulkHint {
    public static final String ID = "Javac_canUseDiamond";
    public static final Set<String> CODES = new HashSet<String>(Arrays.asList("compiler.warn.diamond.redundant.args", "compiler.warn.diamond.redundant.args.1"));
    private static final Map<String, Collection<String>> key2Pattern = new LinkedHashMap<String, Collection<String>>();
    static final String KEY = "enabledVariants";
    static final String ALL = "initializer,assignment,return,argument,other";

    public static boolean isHintEnabled() {
        for (HintMetadata hm : RulesManager.getInstance().readHints(null, null, null).keySet()) {
            if (!ID.equals(hm.id)) continue;
            return HintsSettings.isEnabled((HintMetadata)hm);
        }
        return true;
    }

    public static ErrorDescription compute(HintContext ctx) {
        if (((Collection)ctx.getMultiVariables().get("$tparams$")).isEmpty()) {
            return null;
        }
        TreePath clazz = (TreePath)ctx.getVariables().get("$clazz");
        long start = ctx.getInfo().getTrees().getSourcePositions().getStartPosition(clazz.getCompilationUnit(), clazz.getLeaf());
        ctx.getVariables().put("$init", ctx.getPath());
        block0: for (Diagnostic d : ctx.getInfo().getDiagnostics()) {
            if (start != d.getStartPosition() || !CODES.contains(d.getCode())) continue;
            for (Map.Entry<String, Collection<String>> e : key2Pattern.entrySet()) {
                for (String p : e.getValue()) {
                    if (p != null && !MatcherUtilities.matches((HintContext)ctx, (TreePath)ctx.getPath().getParentPath(), (String)p)) continue;
                    boolean enabled = ConvertToDiamondBulkHint.isEnabled(ctx, e.getKey());
                    if (!enabled) continue block0;
                }
            }
            List<Fix> fixes = Arrays.asList(new FixImpl(ctx.getInfo(), ctx.getPath()).toEditorFix());
            return ErrorDescriptionFactory.createErrorDescription((Severity)ctx.getSeverity(), (String)d.getMessage(null), fixes, (FileObject)ctx.getInfo().getFileObject(), (int)((int)d.getStartPosition()), (int)((int)d.getEndPosition()));
        }
        return null;
    }

    static String getConfiguration(Preferences p) {
        return p.get(KEY, ALL);
    }

    static void putConfiguration(Preferences p, String configuration) {
        p.put(KEY, configuration);
    }

    private static boolean isEnabled(HintContext ctx, String key) {
        return ConvertToDiamondBulkHint.isEnabled(ctx.getPreferences(), key);
    }

    static boolean isEnabled(Preferences p, String key) {
        return ("," + ConvertToDiamondBulkHint.getConfiguration(p) + ",").contains("," + key + ",");
    }

    static {
        key2Pattern.put("initializer", Arrays.asList("$mods$ $type $name = $init;"));
        key2Pattern.put("assignment", Arrays.asList("$var = $init"));
        key2Pattern.put("return", Arrays.asList("return $init;"));
        key2Pattern.put("argument", Arrays.asList("$site.<$T$>$name($p$, $init, $s$)", "$name($p$, $init, $s$)", "new $type<$T$>($p$, $init, $s$)", "new $type($p$, $init, $s$)"));
        key2Pattern.put("other", Arrays.asList(new String[]{null}));
    }

    public static final class CustomizerProviderImpl
    implements CustomizerProvider {
        public JComponent getCustomizer(Preferences prefs) {
            return new ConvertToDiamondBulkHintPanel(prefs);
        }
    }

    private static final class FixImpl
    extends JavaFix {
        public FixImpl(CompilationInfo info, TreePath path) {
            super(info, path);
        }

        public String getText() {
            return NbBundle.getMessage(ConvertToDiamondBulkHint.class, (String)"FIX_ConvertToDiamond");
        }

        protected void performRewrite(JavaFix.TransformationContext ctx) {
            WorkingCopy copy = ctx.getWorkingCopy();
            TreePath tp = ctx.getPath();
            if (tp.getLeaf().getKind() != Tree.Kind.NEW_CLASS) {
                return;
            }
            NewClassTree nct = (NewClassTree)tp.getLeaf();
            if (nct.getIdentifier().getKind() != Tree.Kind.PARAMETERIZED_TYPE) {
                return;
            }
            TreeMaker make = copy.getTreeMaker();
            ParameterizedTypeTree ptt = (ParameterizedTypeTree)((Object)nct.getIdentifier());
            ParameterizedTypeTree nue = make.ParameterizedType(ptt.getType(), Collections.emptyList());
            copy.rewrite((Tree)ptt, (Tree)nue);
        }
    }
}

