/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.introduce;

import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ArrayAccessTree;
import com.sun.source.tree.ArrayTypeTree;
import com.sun.source.tree.AssertTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.BreakTree;
import com.sun.source.tree.CaseTree;
import com.sun.source.tree.CatchTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.ConditionalExpressionTree;
import com.sun.source.tree.ContinueTree;
import com.sun.source.tree.DoWhileLoopTree;
import com.sun.source.tree.EmptyStatementTree;
import com.sun.source.tree.EnhancedForLoopTree;
import com.sun.source.tree.ErroneousTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ForLoopTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.IfTree;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.InstanceOfTree;
import com.sun.source.tree.LabeledStatementTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.ParameterizedTypeTree;
import com.sun.source.tree.ParenthesizedTree;
import com.sun.source.tree.PrimitiveTypeTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.SwitchTree;
import com.sun.source.tree.SynchronizedTree;
import com.sun.source.tree.ThrowTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TryTree;
import com.sun.source.tree.TypeCastTree;
import com.sun.source.tree.TypeParameterTree;
import com.sun.source.tree.UnaryTree;
import com.sun.source.tree.UnionTypeTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.tree.WhileLoopTree;
import com.sun.source.tree.WildcardTree;
import com.sun.source.util.TreePath;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.support.CancellableTreePathScanner;

public class Flow {
    private static final Set<ElementKind> LOCAL_VARIABLES = EnumSet.of(ElementKind.EXCEPTION_PARAMETER, ElementKind.LOCAL_VARIABLE, ElementKind.PARAMETER);

    public static FlowResult assignmentsForUse(CompilationInfo info, AtomicBoolean cancel) {
        return Flow.assignmentsForUse(info, new TreePath(info.getCompilationUnit()), cancel);
    }

    public static FlowResult assignmentsForUse(CompilationInfo info, TreePath from, AtomicBoolean cancel) {
        return Flow.assignmentsForUse(info, from, new AtomicBooleanCancel(cancel));
    }

    public static FlowResult assignmentsForUse(CompilationInfo info, TreePath from, Cancel cancel) {
        HashMap result = new HashMap();
        VisitorImpl v = new VisitorImpl(info, cancel);
        v.scan(from, null);
        if (cancel.isCanceled()) {
            return null;
        }
        for (Map.Entry e : v.use2Values.entrySet()) {
            result.put(e.getKey(), e.getValue() != null ? ((State)e.getValue()).assignments : Collections.emptyList());
        }
        v.deadBranches.remove(null);
        return new FlowResult(Collections.unmodifiableMap(result), Collections.unmodifiableSet(v.deadBranches));
    }

    public static boolean definitellyAssigned(CompilationInfo info, VariableElement var, Iterable<? extends TreePath> trees, AtomicBoolean cancel) {
        return Flow.definitellyAssigned(info, var, trees, new AtomicBooleanCancel(cancel));
    }

    public static boolean definitellyAssigned(CompilationInfo info, VariableElement var, Iterable<? extends TreePath> trees, Cancel cancel) {
        VisitorImpl v = new VisitorImpl(info, cancel);
        v.variable2State.put(var, State.create(null));
        for (TreePath treePath : trees) {
            if (cancel.isCanceled()) {
                return false;
            }
            v.scan(treePath, null);
            if (((State)v.variable2State.get(var)).assignments.contains(null)) continue;
            return true;
        }
        return false;
    }

    public static final class AtomicBooleanCancel
    implements Cancel {
        private final AtomicBoolean cancel;

        public AtomicBooleanCancel(AtomicBoolean cancel) {
            this.cancel = cancel;
        }

        @Override
        public boolean isCanceled() {
            return this.cancel.get();
        }
    }

    public static interface Cancel {
        public boolean isCanceled();
    }

    public static final class FlowResult {
        private final Map<Tree, Iterable<? extends TreePath>> assignmentsForUse;
        private final Set<? extends Tree> deadBranches;

        private FlowResult(Map<Tree, Iterable<? extends TreePath>> assignmentsForUse, Set<Tree> deadBranches) {
            this.assignmentsForUse = assignmentsForUse;
            this.deadBranches = deadBranches;
        }

        public Map<Tree, Iterable<? extends TreePath>> getAssignmentsForUse() {
            return this.assignmentsForUse;
        }

        public Set<? extends Tree> getDeadBranches() {
            return this.deadBranches;
        }
    }

    static class State {
        private final Set<TreePath> assignments;

        private State(Set<TreePath> assignments) {
            this.assignments = assignments;
        }

        public static State create(TreePath assignment) {
            return new State(Collections.singleton(assignment));
        }

        public State merge(State value) {
            HashSet<TreePath> assignments = new HashSet<TreePath>(this.assignments);
            assignments.addAll(value.assignments);
            return new State(assignments);
        }
    }

    private static final class VisitorImpl
    extends CancellableTreePathScanner<Boolean, Void> {
        private final CompilationInfo info;
        private Map<VariableElement, State> variable2State = new HashMap<VariableElement, State>();
        private Map<Tree, State> use2Values = new IdentityHashMap<Tree, State>();
        private Map<Tree, Collection<Map<VariableElement, State>>> resumeBefore = new IdentityHashMap<Tree, Collection<Map<VariableElement, State>>>();
        private Map<Tree, Collection<Map<VariableElement, State>>> resumeAfter = new IdentityHashMap<Tree, Collection<Map<VariableElement, State>>>();
        private Map<TypeMirror, Collection<Map<VariableElement, State>>> resumeOnExceptionHandler = new IdentityHashMap<TypeMirror, Collection<Map<VariableElement, State>>>();
        private boolean inParameters;
        private Tree nearestMethod;
        private Set<VariableElement> currentMethodVariables = Collections.newSetFromMap(new IdentityHashMap());
        private final Set<Tree> deadBranches = new HashSet<Tree>();
        private final List<TreePath> pendingFinally = new LinkedList<TreePath>();
        private final Cancel cancel;

        public VisitorImpl(CompilationInfo info, Cancel cancel) {
            this.info = info;
            this.cancel = cancel;
        }

        protected boolean isCanceled() {
            return this.cancel.isCanceled();
        }

        public Boolean scan(Tree tree, Void p) {
            this.resume(tree, this.resumeBefore);
            Boolean result = (Boolean)super.scan(tree, (Object)p);
            this.resume(tree, this.resumeAfter);
            return result;
        }

        private void resume(Tree tree, Map<Tree, Collection<Map<VariableElement, State>>> resume) {
            Collection<Map<VariableElement, State>> toResume = resume.remove(tree);
            if (toResume != null) {
                for (Map<VariableElement, State> s : toResume) {
                    this.variable2State = this.mergeOr(this.variable2State, s);
                }
            }
        }

        public Boolean visitAssignment(AssignmentTree node, Void p) {
            switch (node.getVariable().getKind()) {
                case MEMBER_SELECT: {
                    this.scan((Tree)((MemberSelectTree)node.getVariable()).getExpression(), null);
                    break;
                }
                case ARRAY_ACCESS: {
                    this.scan((Tree)node.getVariable(), null);
                    break;
                }
                case IDENTIFIER: {
                    break;
                }
            }
            this.scan((Tree)node.getExpression(), p);
            Element e = this.info.getTrees().getElement(new TreePath(this.getCurrentPath(), node.getVariable()));
            if (e != null && LOCAL_VARIABLES.contains((Object)e.getKind())) {
                this.variable2State.put((VariableElement)e, State.create(new TreePath(this.getCurrentPath(), node.getExpression())));
            }
            return null;
        }

        public Boolean visitCompoundAssignment(CompoundAssignmentTree node, Void p) {
            switch (node.getVariable().getKind()) {
                case MEMBER_SELECT: {
                    this.scan((Tree)((MemberSelectTree)node.getVariable()).getExpression(), null);
                    break;
                }
                case ARRAY_ACCESS: {
                    this.scan((Tree)node.getVariable(), null);
                    break;
                }
                case IDENTIFIER: {
                    break;
                }
            }
            this.scan((Tree)node.getExpression(), p);
            Element e = this.info.getTrees().getElement(new TreePath(this.getCurrentPath(), node.getVariable()));
            if (e != null && LOCAL_VARIABLES.contains((Object)e.getKind())) {
                this.use2Values.put(node.getVariable(), this.variable2State.get((VariableElement)e));
                this.variable2State.put((VariableElement)e, State.create(this.getCurrentPath()));
            }
            return null;
        }

        public Boolean visitVariable(VariableTree node, Void p) {
            super.visitVariable(node, (Object)p);
            Element e = this.info.getTrees().getElement(this.getCurrentPath());
            if (e != null && LOCAL_VARIABLES.contains((Object)e.getKind())) {
                this.variable2State.put((VariableElement)e, State.create(node.getInitializer() != null ? new TreePath(this.getCurrentPath(), node.getInitializer()) : (this.inParameters ? this.getCurrentPath() : null)));
                this.currentMethodVariables.add((VariableElement)e);
            }
            return null;
        }

        public Boolean visitMemberSelect(MemberSelectTree node, Void p) {
            super.visitMemberSelect(node, (Object)p);
            Element e = this.info.getTrees().getElement(this.getCurrentPath());
            if (e != null && LOCAL_VARIABLES.contains((Object)e.getKind())) {
                this.use2Values.put(node, this.variable2State.get((VariableElement)e));
            }
            return null;
        }

        public Boolean visitLiteral(LiteralTree node, Void p) {
            Object val = node.getValue();
            if (val instanceof Boolean) {
                return (Boolean)val;
            }
            return null;
        }

        public Boolean visitIf(IfTree node, Void p) {
            Boolean result = this.scan((Tree)node.getCondition(), p);
            if (result != null) {
                if (result.booleanValue()) {
                    this.scan((Tree)node.getThenStatement(), null);
                    this.deadBranches.add(node.getElseStatement());
                } else {
                    this.scan((Tree)node.getElseStatement(), null);
                    this.deadBranches.add(node.getThenStatement());
                }
                return null;
            }
            Map<VariableElement, State> oldVariable2State = this.variable2State;
            this.variable2State = new HashMap<VariableElement, State>(oldVariable2State);
            this.scan((Tree)node.getThenStatement(), null);
            if (node.getElseStatement() != null) {
                HashMap<VariableElement, State> variableStatesAfterThen = new HashMap<VariableElement, State>(this.variable2State);
                this.variable2State = new HashMap<VariableElement, State>(oldVariable2State);
                this.scan((Tree)node.getElseStatement(), null);
                this.variable2State = this.mergeOr(this.variable2State, variableStatesAfterThen);
            } else {
                this.variable2State = this.mergeOr(this.variable2State, oldVariable2State);
            }
            return null;
        }

        public Boolean visitBinary(BinaryTree node, Void p) {
            Boolean left = this.scan((Tree)node.getLeftOperand(), p);
            if (left != null && (node.getKind() == Tree.Kind.CONDITIONAL_AND || node.getKind() == Tree.Kind.CONDITIONAL_OR)) {
                if (left.booleanValue()) {
                    if (node.getKind() == Tree.Kind.CONDITIONAL_AND) {
                        return this.scan((Tree)node.getRightOperand(), p);
                    }
                    return true;
                }
                if (node.getKind() == Tree.Kind.CONDITIONAL_AND) {
                    return false;
                }
                return this.scan((Tree)node.getRightOperand(), p);
            }
            Map<VariableElement, State> oldVariable2State = this.variable2State;
            this.variable2State = new HashMap<VariableElement, State>(oldVariable2State);
            Boolean right = this.scan((Tree)node.getRightOperand(), p);
            this.variable2State = this.mergeOr(this.variable2State, oldVariable2State);
            if (left == null || right == null) {
                return null;
            }
            switch (node.getKind()) {
                case AND: 
                case CONDITIONAL_AND: {
                    return left != false && right != false;
                }
                case OR: 
                case CONDITIONAL_OR: {
                    return left != false || right != false;
                }
                case EQUAL_TO: {
                    return left == right;
                }
                case NOT_EQUAL_TO: {
                    return left != right;
                }
            }
            return null;
        }

        public Boolean visitConditionalExpression(ConditionalExpressionTree node, Void p) {
            Boolean result = this.scan((Tree)node.getCondition(), p);
            if (result != null) {
                if (result.booleanValue()) {
                    this.scan((Tree)node.getTrueExpression(), null);
                } else {
                    this.scan((Tree)node.getFalseExpression(), null);
                }
                return null;
            }
            Map<VariableElement, State> oldVariable2State = this.variable2State;
            this.variable2State = new HashMap<VariableElement, State>(oldVariable2State);
            this.scan((Tree)node.getTrueExpression(), null);
            if (node.getFalseExpression() != null) {
                HashMap<VariableElement, State> variableStatesAfterThen = new HashMap<VariableElement, State>(this.variable2State);
                this.variable2State = new HashMap<VariableElement, State>(oldVariable2State);
                this.scan((Tree)node.getFalseExpression(), null);
                this.variable2State = this.mergeOr(this.variable2State, variableStatesAfterThen);
            } else {
                this.variable2State = this.mergeOr(this.variable2State, oldVariable2State);
            }
            return null;
        }

        public Boolean visitIdentifier(IdentifierTree node, Void p) {
            super.visitIdentifier(node, (Object)p);
            Element e = this.info.getTrees().getElement(this.getCurrentPath());
            if (e != null && LOCAL_VARIABLES.contains((Object)e.getKind())) {
                this.use2Values.put(node, this.variable2State.get((VariableElement)e));
            }
            return null;
        }

        public Boolean visitUnary(UnaryTree node, Void p) {
            Element e;
            Boolean val = (Boolean)super.visitUnary(node, (Object)p);
            if (val != null && node.getKind() == Tree.Kind.LOGICAL_COMPLEMENT) {
                return val == false;
            }
            if ((node.getKind() == Tree.Kind.PREFIX_DECREMENT || node.getKind() == Tree.Kind.PREFIX_INCREMENT || node.getKind() == Tree.Kind.POSTFIX_DECREMENT || node.getKind() == Tree.Kind.POSTFIX_INCREMENT) && (e = this.info.getTrees().getElement(new TreePath(this.getCurrentPath(), node.getExpression()))) != null && LOCAL_VARIABLES.contains((Object)e.getKind())) {
                State prev = this.variable2State.get((VariableElement)e);
                this.use2Values.put(node.getExpression(), prev);
                this.variable2State.put((VariableElement)e, State.create(this.getCurrentPath()));
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Boolean visitMethod(MethodTree node, Void p) {
            Tree oldNearestMethod = this.nearestMethod;
            Set<VariableElement> oldCurrentMethodVariables = this.currentMethodVariables;
            Map<TypeMirror, Collection<Map<VariableElement, State>>> oldResumeOnExceptionHandler = this.resumeOnExceptionHandler;
            this.nearestMethod = node;
            this.currentMethodVariables = Collections.newSetFromMap(new IdentityHashMap());
            this.resumeOnExceptionHandler = new IdentityHashMap<TypeMirror, Collection<Map<VariableElement, State>>>();
            try {
                this.scan((Tree)node.getModifiers(), p);
                this.scan(node.getReturnType(), p);
                this.scan(node.getTypeParameters(), p);
                this.inParameters = true;
                try {
                    this.scan(node.getParameters(), p);
                }
                finally {
                    this.inParameters = false;
                }
                this.scan(node.getThrows(), p);
                this.scan((Tree)node.getBody(), p);
                this.scan(node.getDefaultValue(), p);
            }
            finally {
                this.nearestMethod = oldNearestMethod;
                this.currentMethodVariables = oldCurrentMethodVariables;
                this.resumeOnExceptionHandler = oldResumeOnExceptionHandler;
            }
            return null;
        }

        public Boolean visitWhileLoop(WhileLoopTree node, Void p) {
            Map<VariableElement, State> beforeLoop = this.variable2State;
            this.variable2State = new HashMap<VariableElement, State>(beforeLoop);
            Boolean condValue = this.scan((Tree)node.getCondition(), null);
            if (condValue != null && !condValue.booleanValue()) {
                return null;
            }
            this.scan((Tree)node.getStatement(), null);
            this.variable2State = this.mergeOr(beforeLoop, this.variable2State);
            this.resume(node.getCondition(), this.resumeBefore);
            beforeLoop = new HashMap<VariableElement, State>(this.variable2State);
            this.scan((Tree)node.getCondition(), null);
            this.scan((Tree)node.getStatement(), null);
            this.variable2State = beforeLoop;
            return null;
        }

        public Boolean visitDoWhileLoop(DoWhileLoopTree node, Void p) {
            Map<VariableElement, State> beforeLoop = this.variable2State;
            this.variable2State = new HashMap<VariableElement, State>(beforeLoop);
            this.scan((Tree)node.getStatement(), null);
            Boolean condValue = this.scan((Tree)node.getCondition(), null);
            if (condValue != null && !condValue.booleanValue()) {
                return null;
            }
            this.variable2State = this.mergeOr(beforeLoop, this.variable2State);
            beforeLoop = new HashMap<VariableElement, State>(this.variable2State);
            this.scan((Tree)node.getStatement(), null);
            this.scan((Tree)node.getCondition(), null);
            this.variable2State = beforeLoop;
            return null;
        }

        public Boolean visitForLoop(ForLoopTree node, Void p) {
            this.scan(node.getInitializer(), null);
            Map<VariableElement, State> beforeLoop = this.variable2State;
            this.variable2State = new HashMap<VariableElement, State>(beforeLoop);
            Boolean condValue = this.scan((Tree)node.getCondition(), null);
            if (condValue != null && !condValue.booleanValue()) {
                return null;
            }
            this.scan((Tree)node.getStatement(), null);
            this.scan(node.getUpdate(), null);
            this.variable2State = this.mergeOr(beforeLoop, this.variable2State);
            this.resume(node.getCondition(), this.resumeBefore);
            beforeLoop = new HashMap<VariableElement, State>(this.variable2State);
            this.scan((Tree)node.getCondition(), null);
            this.scan((Tree)node.getStatement(), null);
            this.scan(node.getUpdate(), null);
            this.variable2State = this.mergeOr(beforeLoop, this.variable2State);
            return null;
        }

        public Boolean visitTry(TryTree node, Void p) {
            if (node.getFinallyBlock() != null) {
                this.pendingFinally.add(0, new TreePath(this.getCurrentPath(), node.getFinallyBlock()));
            }
            this.scan(node.getResources(), null);
            Map<VariableElement, State> oldVariable2State = this.variable2State;
            this.variable2State = new HashMap<VariableElement, State>(oldVariable2State);
            this.scan((Tree)node.getBlock(), null);
            HashMap<VariableElement, State> afterBlockVariable2State = new HashMap<VariableElement, State>(this.variable2State);
            for (CatchTree catchTree : node.getCatches()) {
                TypeMirror caught;
                Map<VariableElement, State> variable2StateBeforeCatch = this.variable2State;
                this.variable2State = new HashMap<VariableElement, State>(oldVariable2State);
                if (catchTree.getParameter() != null && (caught = this.info.getTrees().getTypeMirror(new TreePath(this.getCurrentPath(), catchTree.getParameter()))) != null && caught.getKind() != TypeKind.ERROR) {
                    Iterator<Map.Entry<TypeMirror, Collection<Map<VariableElement, State>>>> it = this.resumeOnExceptionHandler.entrySet().iterator();
                    while (it.hasNext()) {
                        Map.Entry<TypeMirror, Collection<Map<VariableElement, State>>> e = it.next();
                        if (!this.info.getTypes().isSubtype(e.getKey(), caught)) continue;
                        for (Map<VariableElement, State> s : e.getValue()) {
                            this.variable2State = this.mergeOr(this.variable2State, s);
                        }
                        it.remove();
                    }
                }
                this.scan((Tree)catchTree, null);
                this.variable2State = this.mergeOr(variable2StateBeforeCatch, this.variable2State);
            }
            if (node.getFinallyBlock() != null) {
                this.pendingFinally.remove(0);
                this.variable2State = this.mergeOr(this.mergeOr(oldVariable2State, this.variable2State), afterBlockVariable2State);
                this.scan((Tree)node.getFinallyBlock(), null);
            }
            return null;
        }

        public Boolean visitReturn(ReturnTree node, Void p) {
            super.visitReturn(node, (Object)p);
            this.variable2State = new HashMap<VariableElement, State>(this.variable2State);
            if (this.pendingFinally.isEmpty()) {
                for (VariableElement ve : this.currentMethodVariables) {
                    this.variable2State.remove(ve);
                }
            }
            this.resumeAfter(this.nearestMethod, this.variable2State);
            this.variable2State = new HashMap<VariableElement, State>();
            return null;
        }

        public Boolean visitBreak(BreakTree node, Void p) {
            super.visitBreak(node, (Object)p);
            StatementTree target = this.info.getTreeUtilities().getBreakContinueTarget(this.getCurrentPath());
            this.resumeAfter(target, this.variable2State);
            this.variable2State = new HashMap<VariableElement, State>();
            return null;
        }

        public Boolean visitSwitch(SwitchTree node, Void p) {
            this.scan((Tree)node.getExpression(), null);
            HashMap<VariableElement, State> origVariable2State = new HashMap<VariableElement, State>(this.variable2State);
            this.variable2State = new HashMap<VariableElement, State>();
            boolean exhaustive = false;
            for (CaseTree caseTree : node.getCases()) {
                this.variable2State = this.mergeOr(this.variable2State, origVariable2State);
                if (caseTree.getExpression() == null) {
                    exhaustive = true;
                }
                this.scan((Tree)caseTree, null);
            }
            if (!exhaustive) {
                this.variable2State = this.mergeOr(this.variable2State, origVariable2State);
            }
            return null;
        }

        public Boolean visitEnhancedForLoop(EnhancedForLoopTree node, Void p) {
            this.scan((Tree)node.getVariable(), null);
            this.scan((Tree)node.getExpression(), null);
            Map<VariableElement, State> beforeLoop = this.variable2State;
            this.variable2State = new HashMap<VariableElement, State>(beforeLoop);
            this.scan((Tree)node.getStatement(), null);
            this.variable2State = this.mergeOr(beforeLoop, this.variable2State);
            this.resume(node.getStatement(), this.resumeBefore);
            beforeLoop = new HashMap<VariableElement, State>(this.variable2State);
            this.scan((Tree)node.getStatement(), null);
            this.variable2State = this.mergeOr(beforeLoop, this.variable2State);
            return null;
        }

        public Boolean visitAssert(AssertTree node, Void p) {
            Map<VariableElement, State> oldVariable2State = this.variable2State;
            this.variable2State = new HashMap<VariableElement, State>(oldVariable2State);
            this.scan((Tree)node.getCondition(), null);
            if (node.getDetail() != null) {
                HashMap<VariableElement, State> beforeDetailState = new HashMap<VariableElement, State>(this.variable2State);
                this.scan((Tree)node.getDetail(), null);
                this.variable2State = this.mergeOr(this.variable2State, beforeDetailState);
            }
            this.variable2State = this.mergeOr(this.variable2State, oldVariable2State);
            this.recordResumeOnExceptionHandler("java.lang.AssertionError");
            return null;
        }

        public Boolean visitContinue(ContinueTree node, Void p) {
            Tree resumePoint;
            StatementTree loop = this.info.getTreeUtilities().getBreakContinueTarget(this.getCurrentPath());
            if (loop == null) {
                super.visitContinue(node, (Object)p);
                return null;
            }
            if (loop.getKind() == Tree.Kind.LABELED_STATEMENT) {
                loop = ((LabeledStatementTree)loop).getStatement();
            }
            switch (loop.getKind()) {
                case WHILE_LOOP: {
                    resumePoint = ((WhileLoopTree)loop).getCondition();
                    break;
                }
                case FOR_LOOP: {
                    resumePoint = ((ForLoopTree)loop).getCondition();
                    if (resumePoint != null) break;
                    resumePoint = ((ForLoopTree)loop).getStatement();
                    break;
                }
                case DO_WHILE_LOOP: {
                    resumePoint = ((DoWhileLoopTree)loop).getCondition();
                    break;
                }
                case ENHANCED_FOR_LOOP: {
                    resumePoint = ((EnhancedForLoopTree)loop).getStatement();
                    break;
                }
                default: {
                    boolean ae = false;
                    if (!$assertionsDisabled) {
                        ae = true;
                        if (!true) {
                            throw new AssertionError();
                        }
                    }
                    if (ae) {
                        throw new IllegalStateException(loop.getKind().name());
                    }
                    resumePoint = null;
                }
            }
            if (resumePoint != null) {
                VisitorImpl.recordResume(this.resumeBefore, resumePoint, this.variable2State);
            }
            this.variable2State = new HashMap<VariableElement, State>();
            super.visitContinue(node, (Object)p);
            return null;
        }

        public Boolean visitThrow(ThrowTree node, Void p) {
            super.visitThrow(node, (Object)p);
            if (node.getExpression() != null) {
                TypeMirror thrown = this.info.getTrees().getTypeMirror(new TreePath(this.getCurrentPath(), node.getExpression()));
                this.recordResumeOnExceptionHandler(thrown);
            }
            return null;
        }

        public Boolean visitMethodInvocation(MethodInvocationTree node, Void p) {
            super.visitMethodInvocation(node, (Object)p);
            Element invoked = this.info.getTrees().getElement(this.getCurrentPath());
            if (invoked != null && invoked.getKind() == ElementKind.METHOD) {
                this.recordResumeOnExceptionHandler((ExecutableElement)invoked);
            }
            return null;
        }

        public Boolean visitNewClass(NewClassTree node, Void p) {
            super.visitNewClass(node, (Object)p);
            Element invoked = this.info.getTrees().getElement(this.getCurrentPath());
            if (invoked != null && invoked.getKind() == ElementKind.CONSTRUCTOR) {
                this.recordResumeOnExceptionHandler((ExecutableElement)invoked);
            }
            return null;
        }

        private void recordResumeOnExceptionHandler(ExecutableElement invoked) {
            for (TypeMirror typeMirror : invoked.getThrownTypes()) {
                this.recordResumeOnExceptionHandler(typeMirror);
            }
            this.recordResumeOnExceptionHandler("java.lang.RuntimeException");
            this.recordResumeOnExceptionHandler("java.lang.Error");
        }

        private void recordResumeOnExceptionHandler(String exceptionTypeFQN) {
            TypeElement exc = this.info.getElements().getTypeElement(exceptionTypeFQN);
            if (exc == null) {
                return;
            }
            this.recordResumeOnExceptionHandler(exc.asType());
        }

        private void recordResumeOnExceptionHandler(TypeMirror thrown) {
            if (thrown == null || thrown.getKind() == TypeKind.ERROR) {
                return;
            }
            Collection<Map<VariableElement, State>> r = this.resumeOnExceptionHandler.get(thrown);
            if (r == null) {
                r = new ArrayList<Map<VariableElement, State>>();
                this.resumeOnExceptionHandler.put(thrown, r);
            }
            r.add(new HashMap<VariableElement, State>(this.variable2State));
        }

        public Boolean visitParenthesized(ParenthesizedTree node, Void p) {
            return (Boolean)super.visitParenthesized(node, (Object)p);
        }

        private void resumeAfter(Tree target, Map<VariableElement, State> state) {
            for (TreePath tp : this.pendingFinally) {
                boolean shouldBeRun = false;
                for (Tree t : tp) {
                    if (t != target) continue;
                    shouldBeRun = true;
                    break;
                }
                if (!shouldBeRun) break;
                VisitorImpl.recordResume(this.resumeBefore, tp.getLeaf(), state);
            }
            VisitorImpl.recordResume(this.resumeAfter, target, state);
        }

        private static void recordResume(Map<Tree, Collection<Map<VariableElement, State>>> resume, Tree target, Map<VariableElement, State> state) {
            Collection<Map<VariableElement, State>> r = resume.get(target);
            if (r == null) {
                r = new ArrayList<Map<VariableElement, State>>();
                resume.put(target, r);
            }
            r.add(new HashMap<VariableElement, State>(state));
        }

        public Boolean visitWildcard(WildcardTree node, Void p) {
            super.visitWildcard(node, (Object)p);
            return null;
        }

        public Boolean visitUnionType(UnionTypeTree node, Void p) {
            super.visitUnionType(node, (Object)p);
            return null;
        }

        public Boolean visitTypeParameter(TypeParameterTree node, Void p) {
            super.visitTypeParameter(node, (Object)p);
            return null;
        }

        public Boolean visitTypeCast(TypeCastTree node, Void p) {
            super.visitTypeCast(node, (Object)p);
            return null;
        }

        public Boolean visitSynchronized(SynchronizedTree node, Void p) {
            super.visitSynchronized(node, (Object)p);
            return null;
        }

        public Boolean visitPrimitiveType(PrimitiveTypeTree node, Void p) {
            super.visitPrimitiveType(node, (Object)p);
            return null;
        }

        public Boolean visitParameterizedType(ParameterizedTypeTree node, Void p) {
            super.visitParameterizedType(node, (Object)p);
            return null;
        }

        public Boolean visitOther(Tree node, Void p) {
            super.visitOther(node, (Object)p);
            return null;
        }

        public Boolean visitNewArray(NewArrayTree node, Void p) {
            super.visitNewArray(node, (Object)p);
            return null;
        }

        public Boolean visitModifiers(ModifiersTree node, Void p) {
            super.visitModifiers(node, (Object)p);
            return null;
        }

        public Boolean visitLabeledStatement(LabeledStatementTree node, Void p) {
            super.visitLabeledStatement(node, (Object)p);
            return null;
        }

        public Boolean visitInstanceOf(InstanceOfTree node, Void p) {
            super.visitInstanceOf(node, (Object)p);
            return null;
        }

        public Boolean visitImport(ImportTree node, Void p) {
            super.visitImport(node, (Object)p);
            return null;
        }

        public Boolean visitExpressionStatement(ExpressionStatementTree node, Void p) {
            super.visitExpressionStatement(node, (Object)p);
            return null;
        }

        public Boolean visitErroneous(ErroneousTree node, Void p) {
            super.visitErroneous(node, (Object)p);
            return null;
        }

        public Boolean visitEmptyStatement(EmptyStatementTree node, Void p) {
            super.visitEmptyStatement(node, (Object)p);
            return null;
        }

        public Boolean visitCompilationUnit(CompilationUnitTree node, Void p) {
            super.visitCompilationUnit(node, (Object)p);
            return null;
        }

        public Boolean visitClass(ClassTree node, Void p) {
            super.visitClass(node, (Object)p);
            return null;
        }

        public Boolean visitCatch(CatchTree node, Void p) {
            super.visitCatch(node, (Object)p);
            return null;
        }

        public Boolean visitCase(CaseTree node, Void p) {
            super.visitCase(node, (Object)p);
            return null;
        }

        public Boolean visitBlock(BlockTree node, Void p) {
            super.visitBlock(node, (Object)p);
            return null;
        }

        public Boolean visitArrayType(ArrayTypeTree node, Void p) {
            super.visitArrayType(node, (Object)p);
            return null;
        }

        public Boolean visitArrayAccess(ArrayAccessTree node, Void p) {
            super.visitArrayAccess(node, (Object)p);
            return null;
        }

        public Boolean visitAnnotation(AnnotationTree node, Void p) {
            super.visitAnnotation(node, (Object)p);
            return null;
        }

        private Map<VariableElement, State> mergeOr(Map<VariableElement, State> into, Map<VariableElement, State> what) {
            for (Map.Entry<VariableElement, State> e : what.entrySet()) {
                State stt = into.get(e.getKey());
                if (stt != null) {
                    into.put(e.getKey(), stt.merge(e.getValue()));
                    continue;
                }
                into.put(e.getKey(), e.getValue());
            }
            return into;
        }
    }
}

