/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.infrastructure;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.TextAction;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.cookies.EditorCookie;
import org.openide.loaders.DataObject;
import org.openide.text.NbDocument;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;
import org.openide.windows.TopComponent;

public abstract class HintAction
extends TextAction
implements PropertyChangeListener {
    private Reference<EditorCookie.Observable> lastECO;
    private Reference<PropertyChangeListener> lastECOListener;

    protected HintAction() {
        this(null);
    }

    protected HintAction(String key) {
        super(key);
        this.putValue("noIconInMenu", Boolean.TRUE);
        TopComponent.getRegistry().addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)TopComponent.getRegistry()));
        this.setEnabled(false);
        this.updateEnabled();
    }

    private void updateEnabled() {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    HintAction.this.doUpdateEnabled();
                }
            });
        } else {
            this.doUpdateEnabled();
        }
    }

    private void doUpdateEnabled() {
        this.setEnabled(this.getCurrentFile(null) != null);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String error = this.doPerform();
        if (error != null) {
            String errorText = NbBundle.getMessage(HintAction.class, (String)error);
            NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)errorText, 0);
            DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)nd);
        }
    }

    private String doPerform() {
        int[] span = new int[2];
        JTextComponent pane = this.getCurrentFile(span);
        Document doc = pane.getDocument();
        if (doc == null) {
            if (span[0] != span[1]) {
                return "ERR_Not_Selected";
            }
            return "ERR_No_Selection";
        }
        JavaSource js = JavaSource.forDocument((Document)doc);
        if (js == null) {
            return "ERR_Not_Supported";
        }
        this.perform(js, pane, span);
        return null;
    }

    protected abstract void perform(JavaSource var1, JTextComponent var2, int[] var3);

    private JTextComponent getCurrentFile(int[] span) {
        Document doc;
        Object stream;
        JEditorPane pane;
        TopComponent tc = TopComponent.getRegistry().getActivated();
        Lookup l = tc != null ? tc.getLookup() : null;
        EditorCookie ec = l != null ? (EditorCookie)l.lookup(EditorCookie.class) : null;
        JEditorPane jEditorPane = pane = ec != null ? NbDocument.findRecentEditorPane((EditorCookie)ec) : null;
        if (pane == null) {
            if (ec instanceof EditorCookie.Observable) {
                PropertyChangeListener lastECOListener;
                EditorCookie.Observable lastECO = this.lastECO != null ? this.lastECO.get() : null;
                PropertyChangeListener propertyChangeListener = lastECOListener = this.lastECOListener != null ? this.lastECOListener.get() : null;
                if (lastECO != null && lastECOListener != null) {
                    lastECO.removePropertyChangeListener(lastECOListener);
                }
                EditorCookie.Observable eco = (EditorCookie.Observable)ec;
                PropertyChangeListener ecoListener = WeakListeners.propertyChange((PropertyChangeListener)this, (Object)eco);
                eco.addPropertyChangeListener(ecoListener);
                this.lastECO = new WeakReference<EditorCookie.Observable>(eco);
                this.lastECOListener = new WeakReference<PropertyChangeListener>(ecoListener);
            }
            return null;
        }
        if (span != null) {
            span[0] = pane.getSelectionStart();
            span[1] = pane.getSelectionEnd();
            if (span[0] == span[1] && this.requiresSelection()) {
                return null;
            }
        }
        Object object = stream = (doc = pane.getDocument()) != null ? doc.getProperty("stream") : null;
        if (!(stream instanceof DataObject)) {
            return null;
        }
        if ("text/x-java".equals(NbEditorUtilities.getMimeType((Document)doc))) {
            return pane;
        }
        return null;
    }

    protected boolean requiresSelection() {
        return true;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.updateEnabled();
    }
}

