/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.infrastructure;

import java.util.List;
import javax.swing.text.Document;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.modules.java.hints.infrastructure.CreatorBasedLazyFixList;
import org.netbeans.modules.java.hints.infrastructure.ErrorHintsProvider;
import org.netbeans.modules.java.hints.providers.spi.PositionRefresherHelper;
import org.netbeans.spi.editor.hints.Context;
import org.netbeans.spi.editor.hints.ErrorDescription;

public class ErrorPositionRefresherHelper
extends PositionRefresherHelper<PositionRefresherHelper.DocumentVersion> {
    private static final Object KEY_ERRORS = new Object();

    public ErrorPositionRefresherHelper() {
        super(ErrorHintsProvider.class.getName());
    }

    protected boolean isUpToDate(Context context, Document doc, PositionRefresherHelper.DocumentVersion oldVersion) {
        List errors = (List)doc.getProperty(KEY_ERRORS);
        if (errors == null) {
            return false;
        }
        for (ErrorDescription ed : errors) {
            if (ed.getRange().getBegin().getOffset() > context.getPosition() || context.getPosition() > ed.getRange().getEnd().getOffset() || ed.getFixes().isComputed()) continue;
            return false;
        }
        return true;
    }

    public List<ErrorDescription> getErrorDescriptionsAt(CompilationInfo info, Context context, Document doc) throws Exception {
        List<ErrorDescription> errors = (List<ErrorDescription>)doc.getProperty(KEY_ERRORS);
        if (errors == null) {
            errors = new ErrorHintsProvider().computeErrors(info, doc, context.getPosition(), "text/x-java");
        }
        for (ErrorDescription ed : errors) {
            if (ed.getRange().getBegin().getOffset() > context.getPosition() || context.getPosition() > ed.getRange().getEnd().getOffset() || ed.getFixes().isComputed()) continue;
            ((CreatorBasedLazyFixList)ed.getFixes()).compute(info, context.getCancel());
        }
        return errors;
    }

    static void setVersion(Document doc, List<ErrorDescription> errors) {
        for (ErrorPositionRefresherHelper h : MimeLookup.getLookup((String)"text/x-java").lookupAll(ErrorPositionRefresherHelper.class)) {
            if (!(h instanceof ErrorPositionRefresherHelper)) continue;
            h.setVersion(doc, new PositionRefresherHelper.DocumentVersion(doc));
        }
        doc.putProperty(KEY_ERRORS, errors);
    }

    static final class DocumentVersionImpl
    extends PositionRefresherHelper.DocumentVersion {
        private final List<ErrorDescription> errorsContent;

        public DocumentVersionImpl(Document doc, List<ErrorDescription> errorsContent) {
            super(doc);
            this.errorsContent = errorsContent;
        }
    }
}

