/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.infrastructure;

import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.PackageElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Position;
import javax.swing.text.StyledDocument;
import javax.tools.Diagnostic;
import org.netbeans.api.java.lexer.JavaTokenId;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaParserResultTask;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;
import org.netbeans.modules.editor.NbEditorDocument;
import org.netbeans.modules.java.hints.infrastructure.CreatorBasedLazyFixList;
import org.netbeans.modules.java.hints.infrastructure.ErrorPositionRefresherHelper;
import org.netbeans.modules.java.hints.infrastructure.LazyHintComputationFactory;
import org.netbeans.modules.java.hints.jdk.ConvertToDiamondBulkHint;
import org.netbeans.modules.java.hints.legacy.spi.RulesManager;
import org.netbeans.modules.java.hints.spi.ErrorRule;
import org.netbeans.modules.java.hints.spiimpl.Utilities;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.parsing.spi.Scheduler;
import org.netbeans.modules.parsing.spi.SchedulerEvent;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.ErrorDescriptionFactory;
import org.netbeans.spi.editor.hints.HintsController;
import org.netbeans.spi.editor.hints.LazyFixList;
import org.netbeans.spi.editor.hints.Severity;
import org.openide.ErrorManager;
import org.openide.cookies.LineCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.text.Line;
import org.openide.text.NbDocument;
import org.openide.util.Exceptions;

public final class ErrorHintsProvider
extends JavaParserResultTask {
    public static ErrorManager ERR = ErrorManager.getDefault().getInstance("org.netbeans.modules.java.hints");
    public static Logger LOG = Logger.getLogger("org.netbeans.modules.java.hints");
    private static final Map<Diagnostic.Kind, Severity> errorKind2Severity = new EnumMap<Diagnostic.Kind, Severity>(Diagnostic.Kind.class);
    private static final Set<String> INVALID_METHOD_INVOCATION;
    private static final Set<String> CANNOT_RESOLVE;
    private static final Set<String> UNDERLINE_IDENTIFIER;
    private static final Set<JavaTokenId> WHITESPACE;
    private boolean cancel;

    ErrorHintsProvider() {
        super(JavaSource.Phase.RESOLVED);
    }

    List<ErrorDescription> computeErrors(CompilationInfo info, Document doc, String mimeType) throws IOException {
        return this.computeErrors(info, doc, null, mimeType);
    }

    List<ErrorDescription> computeErrors(CompilationInfo info, Document doc, Integer forPosition, String mimeType) throws IOException {
        if ("text/x-javahints".equals(mimeType) && info.getText().startsWith("//no-errors")) {
            return Collections.emptyList();
        }
        List errors = info.getDiagnostics();
        ArrayList<ErrorDescription> descs = new ArrayList<ErrorDescription>();
        if (ERR.isLoggable(1)) {
            ERR.log(1, "errors = " + errors);
        }
        boolean isJava = "text/x-java".equals(mimeType);
        HashMap<Class, ErrorRule.Data> data = new HashMap<Class, ErrorRule.Data>();
        for (Diagnostic d : errors) {
            LazyFixList ehm;
            if (ConvertToDiamondBulkHint.CODES.contains(d.getCode()) && (isJava || !ConvertToDiamondBulkHint.isHintEnabled())) continue;
            if (this.isCanceled()) {
                return null;
            }
            if (ERR.isLoggable(1)) {
                ERR.log(1, "d = " + d);
            }
            Map code2Rules = RulesManager.getInstance().getErrors(mimeType);
            List rules = (List)code2Rules.get(d.getCode());
            if (ERR.isLoggable(1)) {
                ERR.log(1, "code= " + d.getCode());
                ERR.log(1, "rules = " + rules);
            }
            if (rules != null) {
                int pos = (int)this.getPrefferedPosition(info, d);
                ehm = new CreatorBasedLazyFixList(info.getFileObject(), d.getCode(), pos, rules, data);
            } else {
                ehm = ErrorDescriptionFactory.lazyListForFixes(Collections.emptyList());
            }
            if (ERR.isLoggable(1)) {
                ERR.log(1, "ehm=" + ehm);
            }
            String desc = d.getMessage(null);
            Position[] range = this.getLine(info, d, doc, (int)d.getStartPosition(), (int)d.getEndPosition());
            if (this.isCanceled()) {
                return null;
            }
            if (range[0] == null || range[1] == null) continue;
            if (forPosition != null) {
                try {
                    int posRowStart = org.netbeans.editor.Utilities.getRowStart((BaseDocument)((NbEditorDocument)doc), (int)forPosition);
                    int errRowStart = org.netbeans.editor.Utilities.getRowStart((BaseDocument)((NbEditorDocument)doc), (int)range[0].getOffset());
                    if (posRowStart != errRowStart) {
                        continue;
                    }
                }
                catch (BadLocationException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            descs.add(ErrorDescriptionFactory.createErrorDescription((Severity)errorKind2Severity.get((Object)d.getKind()), (String)desc, (LazyFixList)ehm, (Document)doc, (Position)range[0], (Position)range[1]));
        }
        if (this.isCanceled()) {
            return null;
        }
        Set disabled = Utilities.disableErrors((FileObject)info.getFileObject());
        ArrayList<ErrorDescription> result = new ArrayList<ErrorDescription>(descs.size());
        for (ErrorDescription ed : descs) {
            if (disabled.contains(ed.getSeverity())) continue;
            result.add(ed);
        }
        if (isJava) {
            LazyHintComputationFactory.getAndClearToCompute(info.getFileObject());
        } else {
            for (ErrorDescription d : result) {
                d.getFixes().getFixes();
            }
        }
        return result;
    }

    public static Token findUnresolvedElementToken(CompilationInfo info, int offset) throws IOException {
        TokenHierarchy th = info.getTokenHierarchy();
        TokenSequence ts = th.tokenSequence(JavaTokenId.language());
        if (ts == null) {
            return null;
        }
        ts.move(offset);
        if (ts.moveNext()) {
            Token t = ts.token();
            if (t.id() == JavaTokenId.DOT) {
                ts.moveNext();
                t = ts.token();
            } else if (t.id() == JavaTokenId.LT) {
                ts.moveNext();
                t = ts.token();
            } else if (t.id() == JavaTokenId.NEW || t.id() == JavaTokenId.WHITESPACE ? (t = ErrorHintsProvider.skipWhitespaces((TokenSequence<JavaTokenId>)ts)) == null : t.id() == JavaTokenId.IMPORT && (t = ErrorHintsProvider.skipWhitespaces((TokenSequence<JavaTokenId>)ts)) == null) {
                return null;
            }
            if (t.id() == JavaTokenId.IDENTIFIER) {
                return ts.offsetToken();
            }
        }
        return null;
    }

    private static Token skipWhitespaces(TokenSequence<JavaTokenId> ts) {
        boolean cont = ts.moveNext();
        while (cont && ts.token().id() == JavaTokenId.WHITESPACE) {
            cont = ts.moveNext();
        }
        if (!cont) {
            return null;
        }
        return ts.token();
    }

    private static int[] findUnresolvedElementSpan(CompilationInfo info, int offset) throws IOException {
        Token t = ErrorHintsProvider.findUnresolvedElementToken(info, offset);
        if (t != null) {
            return new int[]{t.offset(null), t.offset(null) + t.length()};
        }
        return null;
    }

    public static TreePath findUnresolvedElement(CompilationInfo info, int offset) throws IOException {
        int[] span = ErrorHintsProvider.findUnresolvedElementSpan(info, offset);
        if (span != null) {
            return info.getTreeUtilities().pathFor(span[0] + 1);
        }
        return null;
    }

    private int[] handlePossibleMethodInvocation(CompilationInfo info, Diagnostic d, Document doc, int startOffset, int endOffset) throws IOException {
        int pos = (int)this.getPrefferedPosition(info, d);
        TreePath tp = info.getTreeUtilities().pathFor(pos + 1);
        if (tp != null && tp.getParentPath() != null && tp.getParentPath().getLeaf() != null && (tp.getParentPath().getLeaf().getKind() == Tree.Kind.METHOD_INVOCATION || tp.getParentPath().getLeaf().getKind() == Tree.Kind.NEW_CLASS)) {
            int[] index = new int[1];
            if (org.netbeans.modules.editor.java.Utilities.fuzzyResolveMethodInvocation((CompilationInfo)info, (TreePath)(tp = tp.getParentPath()), (TypeMirror[])new TypeMirror[1], (int[])index) != null) {
                Tree a;
                ExpressionTree mit;
                if (tp.getLeaf().getKind() == Tree.Kind.METHOD_INVOCATION) {
                    mit = (MethodInvocationTree)tp.getLeaf();
                    a = mit.getArguments().get(index[0]);
                } else {
                    mit = (NewClassTree)tp.getLeaf();
                    a = mit.getArguments().get(index[0]);
                }
                int start = (int)info.getTrees().getSourcePositions().getStartPosition(info.getCompilationUnit(), a);
                int end = (int)info.getTrees().getSourcePositions().getEndPosition(info.getCompilationUnit(), a);
                return new int[]{start, end};
            }
        }
        return null;
    }

    private Position[] getLine(CompilationInfo info, Diagnostic d, final Document doc, int startOffset, int endOffset) throws IOException {
        int originalEndOffset;
        int[] span;
        StyledDocument sdoc = (StyledDocument)doc;
        DataObject dObj = (DataObject)doc.getProperty("stream");
        if (dObj == null) {
            return new Position[]{null, null};
        }
        LineCookie lc = (LineCookie)dObj.getCookie(LineCookie.class);
        int originalStartOffset = info.getSnapshot().getOriginalOffset(startOffset);
        int lineNumber = NbDocument.findLineNumber((StyledDocument)sdoc, (int)originalStartOffset);
        int lineOffset = NbDocument.findLineOffset((StyledDocument)sdoc, (int)lineNumber);
        Line line = lc.getLineSet().getCurrent(lineNumber);
        boolean rangePrepared = false;
        if (INVALID_METHOD_INVOCATION.contains(d.getCode()) && (span = this.translatePositions(info, this.handlePossibleMethodInvocation(info, d, doc, startOffset, endOffset))) != null) {
            startOffset = span[0];
            endOffset = span[1];
            rangePrepared = true;
        }
        if (CANNOT_RESOLVE.contains(d.getCode()) && !rangePrepared && (span = this.translatePositions(info, ErrorHintsProvider.findUnresolvedElementSpan(info, (int)this.getPrefferedPosition(info, d)))) != null) {
            startOffset = span[0];
            endOffset = span[1];
            rangePrepared = true;
        }
        if (UNDERLINE_IDENTIFIER.contains(d.getCode())) {
            int offset = (int)this.getPrefferedPosition(info, d);
            TokenSequence ts = info.getTokenHierarchy().tokenSequence(JavaTokenId.language());
            int diff = ts.move(offset);
            if (ts.moveNext() && diff >= 0 && diff < ts.token().length()) {
                int[] span2;
                Token t = ts.token();
                if (t.id() == JavaTokenId.DOT) {
                    while (ts.moveNext() && WHITESPACE.contains(ts.token().id())) {
                    }
                    t = ts.token();
                }
                if (t.id() == JavaTokenId.NEW) {
                    while (ts.moveNext() && WHITESPACE.contains(ts.token().id())) {
                    }
                    t = ts.token();
                }
                if (t.id() == JavaTokenId.CLASS) {
                    while (ts.moveNext() && WHITESPACE.contains(ts.token().id())) {
                    }
                    t = ts.token();
                }
                if (t.id() == JavaTokenId.IDENTIFIER && (span2 = this.translatePositions(info, new int[]{ts.offset(), ts.offset() + t.length()})) != null) {
                    startOffset = span2[0];
                    endOffset = span2[1];
                    rangePrepared = true;
                }
            }
        }
        String text = null;
        if (!rangePrepared && (text = line.getText()) == null) {
            this.cancel();
            return null;
        }
        if (!rangePrepared && d.getCode().endsWith("proc.messager") && (originalEndOffset = info.getSnapshot().getOriginalOffset(endOffset)) <= lineOffset + text.length() && originalStartOffset != -1 && originalEndOffset != -1) {
            startOffset = originalStartOffset;
            endOffset = originalEndOffset;
            rangePrepared = true;
        }
        if (!rangePrepared) {
            int column;
            int length = text.length();
            for (column = 0; column < text.length() && Character.isWhitespace(text.charAt(column)); ++column) {
            }
            while (length > 0 && Character.isWhitespace(text.charAt(length - 1))) {
                --length;
            }
            startOffset = length == 0 ? lineOffset : lineOffset + column;
            endOffset = lineOffset + length;
        }
        if (ERR.isLoggable(1)) {
            ERR.log(1, "startOffset = " + startOffset);
            ERR.log(1, "endOffset = " + endOffset);
        }
        final int startOffsetFinal = startOffset;
        final int endOffsetFinal = endOffset;
        final Position[] result = new Position[2];
        doc.render(new Runnable(){

            @Override
            public void run() {
                if (ErrorHintsProvider.this.isCanceled()) {
                    return;
                }
                int len = doc.getLength();
                if (startOffsetFinal >= len || endOffsetFinal > len) {
                    if (!ErrorHintsProvider.this.isCanceled() && ERR.isLoggable(16)) {
                        ERR.log(16, "document changed, but not canceled?");
                        ERR.log(16, "len = " + len);
                        ERR.log(16, "startOffset = " + startOffsetFinal);
                        ERR.log(16, "endOffset = " + endOffsetFinal);
                    }
                    ErrorHintsProvider.this.cancel();
                    return;
                }
                try {
                    result[0] = NbDocument.createPosition((Document)doc, (int)startOffsetFinal, (Position.Bias)Position.Bias.Forward);
                    result[1] = NbDocument.createPosition((Document)doc, (int)endOffsetFinal, (Position.Bias)Position.Bias.Backward);
                }
                catch (BadLocationException e) {
                    ERR.notify(65536, (Throwable)e);
                }
            }
        });
        return result;
    }

    synchronized boolean isCanceled() {
        return this.cancel;
    }

    public synchronized void cancel() {
        this.cancel = true;
    }

    synchronized void resume() {
        this.cancel = false;
    }

    public void run(Parser.Result result, SchedulerEvent event) {
        this.resume();
        CompilationInfo info = CompilationInfo.get((Parser.Result)result);
        if (info == null) {
            return;
        }
        Document doc = result.getSnapshot().getSource().getDocument(false);
        if (doc == null) {
            Logger.getLogger(ErrorHintsProvider.class.getName()).log(Level.FINE, "SemanticHighlighter: Cannot get document!");
            return;
        }
        long version = DocumentUtilities.getDocumentVersion((Document)doc);
        String mimeType = result.getSnapshot().getSource().getMimeType();
        long start = System.currentTimeMillis();
        try {
            List<ErrorDescription> errors = this.computeErrors(info, doc, mimeType);
            if (errors == null) {
                return;
            }
            HintsController.setErrors((Document)doc, (String)ErrorHintsProvider.class.getName(), errors);
            ErrorPositionRefresherHelper.setVersion(doc, errors);
            long end = System.currentTimeMillis();
            Logger.getLogger("TIMER").log(Level.FINE, "Java Hints", new Object[]{info.getFileObject(), end - start});
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public int getPriority() {
        return 200;
    }

    public Class<? extends Scheduler> getSchedulerClass() {
        return Scheduler.EDITOR_SENSITIVE_TASK_SCHEDULER;
    }

    private int[] translatePositions(CompilationInfo info, int[] span) {
        if (span == null || span[0] == -1 || span[1] == -1) {
            return null;
        }
        int start = info.getSnapshot().getOriginalOffset(span[0]);
        int end = info.getSnapshot().getOriginalOffset(span[1]);
        if (start == -1 || end == -1) {
            return null;
        }
        return new int[]{start, end};
    }

    private long getPrefferedPosition(CompilationInfo info, Diagnostic d) throws IOException {
        if ("compiler.err.doesnt.exist".equals(d.getCode())) {
            return d.getStartPosition();
        }
        if ("compiler.err.cant.resolve.location".equals(d.getCode()) || "compiler.err.cant.resolve.location.args".equals(d.getCode())) {
            int[] span = ErrorHintsProvider.findUnresolvedElementSpan(info, (int)d.getPosition());
            if (span != null) {
                return span[0];
            }
            return d.getPosition();
        }
        if ("compiler.err.not.stmt".equals(d.getCode())) {
            Element el;
            TreePath path = ErrorHintsProvider.findUnresolvedElement(info, (int)d.getStartPosition() - 1);
            Element element = el = path != null ? info.getTrees().getElement(path) : null;
            if (el == null || el.asType().getKind() == TypeKind.ERROR) {
                return d.getStartPosition() - 1L;
            }
            if (el.asType().getKind() == TypeKind.PACKAGE) {
                String s = ((PackageElement)el).getQualifiedName().toString();
                if (info.getElements().getPackageElement(s) == null) {
                    return d.getStartPosition() - 1L;
                }
            }
            return d.getStartPosition();
        }
        return d.getPosition();
    }

    static {
        errorKind2Severity.put(Diagnostic.Kind.ERROR, Severity.ERROR);
        errorKind2Severity.put(Diagnostic.Kind.MANDATORY_WARNING, Severity.WARNING);
        errorKind2Severity.put(Diagnostic.Kind.WARNING, Severity.WARNING);
        errorKind2Severity.put(Diagnostic.Kind.NOTE, Severity.WARNING);
        errorKind2Severity.put(Diagnostic.Kind.OTHER, Severity.WARNING);
        INVALID_METHOD_INVOCATION = new HashSet<String>(Arrays.asList("compiler.err.prob.found.req", "compiler.err.cant.apply.symbol", "compiler.err.cant.apply.symbol.1", "compiler.err.cant.resolve.location.args"));
        CANNOT_RESOLVE = new HashSet<String>(Arrays.asList("compiler.err.cant.resolve", "compiler.err.cant.resolve.location", "compiler.err.cant.resolve.location.args", "compiler.err.doesnt.exist", "compiler.err.type.error"));
        UNDERLINE_IDENTIFIER = new HashSet<String>(Arrays.asList("compiler.err.local.var.accessed.from.icls.needs.final", "compiler.err.var.might.not.have.been.initialized", "compiler.err.report.access", "compiler.err.does.not.override.abstract", "compiler.err.abstract.cant.be.instantiated", "compiler.warn.missing.SVUID", "compiler.warn.has.been.deprecated", "compiler.warn.raw.class.use"));
        WHITESPACE = EnumSet.of(JavaTokenId.BLOCK_COMMENT, JavaTokenId.JAVADOC_COMMENT, JavaTokenId.LINE_COMMENT, JavaTokenId.WHITESPACE);
    }
}

