/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.errors;

import java.util.Set;
import javax.lang.model.element.Modifier;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.modules.java.hints.errors.CreateElement;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.RefactoringSession;
import org.netbeans.modules.refactoring.api.ui.RefactoringActionsFactory;
import org.netbeans.modules.refactoring.java.api.ChangeParametersRefactoring;
import org.netbeans.modules.refactoring.java.api.ui.JavaRefactoringActionsFactory;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.Fix;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import org.openide.util.lookup.Lookups;

public final class ChangeParametersFix
implements Fix {
    private final boolean doFullRefactoring;
    private final TreePathHandle tph;
    private final String declaration;
    private final String newDeclaration;
    private final ChangeParametersRefactoring.ParameterInfo[] newParameterInfo;
    private final Set<Modifier> modifiers;

    public ChangeParametersFix(boolean doFullRefactoring, TreePathHandle tph, Set<Modifier> modifiers, String declaration, String newDeclaration, ChangeParametersRefactoring.ParameterInfo[] newParameterInfo) {
        this.doFullRefactoring = doFullRefactoring;
        this.tph = tph;
        this.modifiers = modifiers;
        this.declaration = declaration;
        this.newDeclaration = newDeclaration;
        this.newParameterInfo = newParameterInfo;
    }

    public String getText() {
        return NbBundle.getMessage(CreateElement.class, (String)"LBL_FIX_ChangeMethodParameters", (Object)this.declaration, (Object)this.newDeclaration);
    }

    public ChangeInfo implement() throws Exception {
        if (this.doFullRefactoring) {
            ChangeParametersFix.doFullChangeMethodParameters(this.tph, this.newParameterInfo);
            return null;
        }
        ChangeParametersRefactoring refactoring = new ChangeParametersRefactoring(this.tph);
        refactoring.setParameterInfo(new ChangeParametersRefactoring.ParameterInfo[0]);
        refactoring.setModifiers(this.modifiers);
        refactoring.setParameterInfo(this.newParameterInfo);
        RefactoringSession session = RefactoringSession.create((String)"ChangeMethodParameterHint");
        Problem problem = null;
        problem = refactoring.preCheck();
        if (problem != null) {
            ChangeParametersFix.doFullChangeMethodParameters(this.tph, this.newParameterInfo);
            return null;
        }
        problem = refactoring.prepare(session);
        if (problem != null) {
            ChangeParametersFix.doFullChangeMethodParameters(this.tph, this.newParameterInfo);
            return null;
        }
        problem = session.doRefactoring(false);
        if (problem != null) {
            ChangeParametersFix.doFullChangeMethodParameters(this.tph, this.newParameterInfo);
            return null;
        }
        return null;
    }

    private static void doFullChangeMethodParameters(TreePathHandle tph, ChangeParametersRefactoring.ParameterInfo[] newParameterInfo) {
        InstanceContent ic = new InstanceContent();
        ic.add((Object)tph);
        for (ChangeParametersRefactoring.ParameterInfo parameterInfo : newParameterInfo) {
            ic.add((Object)parameterInfo);
        }
        AbstractLookup nodeLookup = new AbstractLookup((AbstractLookup.Content)ic);
        AbstractNode actionContext = new AbstractNode(Children.LEAF, (Lookup)nodeLookup);
        final Action a = JavaRefactoringActionsFactory.changeParametersAction().createContextAwareInstance(Lookups.singleton((Object)actionContext));
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                a.actionPerformed(RefactoringActionsFactory.DEFAULT_EVENT);
            }
        });
    }
}

