/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.util.Collections;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.java.hints.ErrorDescriptionFactory;
import org.netbeans.spi.java.hints.HintContext;
import org.netbeans.spi.java.hints.JavaFix;
import org.openide.util.NbBundle;

public class UtilityClass {
    public static ErrorDescription utilityClass(HintContext ctx) {
        CompilationInfo compilationInfo = ctx.getInfo();
        TreePath treePath = ctx.getPath();
        Element e = compilationInfo.getTrees().getElement(treePath);
        if (e == null) {
            return null;
        }
        if (!UtilityClass.isUtilityClass(compilationInfo, e)) {
            return null;
        }
        for (ExecutableElement c : ElementFilter.constructorsIn(e.getEnclosedElements())) {
            if (compilationInfo.getElementUtilities().isSynthetic((Element)c)) continue;
            return null;
        }
        return ErrorDescriptionFactory.forName((HintContext)ctx, (TreePath)treePath, (String)NbBundle.getMessage(UtilityClass.class, (String)"MSG_UtilityClass"), (Fix[])new Fix[]{new FixImpl(true, TreePathHandle.create((Element)e, (CompilationInfo)compilationInfo)).toEditorFix()});
    }

    public static ErrorDescription constructor(HintContext ctx) {
        CompilationInfo compilationInfo = ctx.getInfo();
        TreePath treePath = ctx.getPath();
        Element e = compilationInfo.getTrees().getElement(treePath);
        if (e == null) {
            return null;
        }
        if (e.getKind() != ElementKind.CONSTRUCTOR || compilationInfo.getElementUtilities().isSynthetic(e) || !e.getModifiers().contains((Object)Modifier.PROTECTED) && !e.getModifiers().contains((Object)Modifier.PUBLIC)) {
            return null;
        }
        if (!UtilityClass.isUtilityClass(compilationInfo, e.getEnclosingElement())) {
            return null;
        }
        return ErrorDescriptionFactory.forName((HintContext)ctx, (TreePath)treePath, (String)NbBundle.getMessage(UtilityClass.class, (String)"MSG_PublicConstructor"), (Fix[])new Fix[]{new FixImpl(false, TreePathHandle.create((Element)e, (CompilationInfo)compilationInfo)).toEditorFix()});
    }

    private static boolean isMainMethod(ExecutableElement m) {
        return m.getModifiers().contains((Object)Modifier.STATIC) && m.getSimpleName().contentEquals("main") && m.getReturnType().getKind() == TypeKind.VOID && m.getParameters().size() == 1 && ((Object)m.getParameters().get(0).asType()).toString().equals("java.lang.String[]");
    }

    private static boolean isUtilityClass(CompilationInfo compilationInfo, Element clazz) {
        Name superName;
        if (clazz.getKind() != ElementKind.CLASS) {
            return false;
        }
        TypeMirror supr = ((TypeElement)clazz).getSuperclass();
        if (supr == null) {
            return false;
        }
        Element superElem = compilationInfo.getTypes().asElement(supr);
        if (superElem instanceof TypeElement && (superName = compilationInfo.getElements().getBinaryName((TypeElement)superElem)) != null && !superName.contentEquals("java.lang.Object")) {
            return false;
        }
        int cnt = 0;
        for (Element element : clazz.getEnclosedElements()) {
            if (element.getKind() == ElementKind.METHOD && UtilityClass.isMainMethod((ExecutableElement)element)) {
                return false;
            }
            if (element.getKind() != ElementKind.METHOD && element.getKind() != ElementKind.FIELD) continue;
            if (!element.getModifiers().contains((Object)Modifier.STATIC)) {
                return false;
            }
            ++cnt;
        }
        return cnt > 0;
    }

    private static final class FixImpl
    extends JavaFix {
        private boolean clazz;

        public FixImpl(boolean clazz, TreePathHandle handle) {
            super(handle);
            this.clazz = clazz;
        }

        public String getText() {
            return NbBundle.getMessage(UtilityClass.class, (String)(this.clazz ? "MSG_PrivateConstructor" : "MSG_MakePrivate"));
        }

        public String toString() {
            return "FixUtilityClass";
        }

        protected void performRewrite(JavaFix.TransformationContext ctx) {
            WorkingCopy wc = ctx.getWorkingCopy();
            TreePath tp = ctx.getPath();
            Element e = wc.getTrees().getElement(tp);
            if (e == null) {
                return;
            }
            Tree outer = wc.getTrees().getTree(e);
            if (this.clazz) {
                if (outer == null || !TreeUtilities.CLASS_TREE_KINDS.contains((Object)outer.getKind())) {
                    return;
                }
                ClassTree cls = (ClassTree)outer;
                ModifiersTree modifiers = wc.getTreeMaker().Modifiers(Collections.singleton(Modifier.PRIVATE));
                MethodTree m = wc.getTreeMaker().Constructor(modifiers, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), wc.getTreeMaker().Block(Collections.emptyList(), false));
                wc.rewrite((Tree)cls, (Tree)wc.getTreeMaker().addClassMember(cls, (Tree)m));
            } else {
                if (outer == null || outer.getKind() != Tree.Kind.METHOD) {
                    return;
                }
                MethodTree met = (MethodTree)outer;
                ModifiersTree modifiers = wc.getTreeMaker().Modifiers(Collections.singleton(Modifier.PRIVATE), met.getModifiers().getAnnotations());
                wc.rewrite((Tree)met.getModifiers(), (Tree)modifiers);
            }
        }
    }
}

