/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jdbc.pool;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.enhydra.jdbc.core.JdbcThreadFactory;
import org.enhydra.jdbc.pool.GenerationObject;
import org.enhydra.jdbc.pool.PoolHelper;
import org.enhydra.jdbc.pool.PoolKeeper;
import org.enhydra.jdbc.util.Logger;

public class GenericPool {
    private long lifeTime;
    private Hashtable locked;
    private Hashtable unlocked;
    private Vector hitList;
    private JdbcThreadFactory threadFactory = null;
    private int minSize;
    private int maxSize;
    private PoolHelper poolHelper;
    private int count;
    private boolean gc;
    private boolean debug;
    private long deadLockMaxWait;
    private long deadLockRetryWait;
    private Logger log;
    private int checkLevelObject;
    protected Thread keeper;
    protected PoolKeeper poolKeeper;
    private long sleepTime;
    protected int generation = 1;
    public static final long DEFAULT_EXPIRATION = 600000L;
    public static final long DEFAULT_SLEEPTIME = 300000L;
    public static final int DEFAULT_MINSIZE = 2;
    public static final int DEFAULT_MAXSIZE = 50;
    public static final int DEFAULT_DEADLOCKMAXWAIT = 300000;
    public static final int DEFAULT_DEADLOCKRETRYWAIT = 10000;

    public GenericPool(PoolHelper helper) {
        this(helper, 2, 50, 600000L, 300000L);
    }

    public GenericPool(PoolHelper helper, int initSize) {
        this(helper, 2, initSize, 600000L, 300000L);
    }

    public GenericPool(PoolHelper helper, int minSize, int maxSize, long lifeTime, long sleepTime) {
        this.lifeTime = lifeTime;
        this.minSize = minSize;
        this.maxSize = maxSize;
        this.poolHelper = helper;
        this.sleepTime = sleepTime;
        this.checkLevelObject = 0;
        this.deadLockMaxWait = 300000L;
        this.deadLockRetryWait = 10000L;
    }

    public synchronized void start() {
        this.locked = new Hashtable();
        this.unlocked = new Hashtable();
        this.hitList = new Vector();
        this.count = 0;
        this.gc = false;
        long now = System.currentTimeMillis();
        int i = 0;
        while (i < this.minSize) {
            try {
                GenerationObject genObject = this.poolHelper.create();
                this.unlocked.put(genObject, new Long(now));
            }
            catch (Exception e) {
                this.log.error("Error Exception in GenericPool:start " + e);
            }
            ++this.count;
            ++i;
        }
        if (this.threadFactory != null) {
            try {
                this.poolKeeper = new PoolKeeper(this.sleepTime, this);
                this.keeper = this.threadFactory.getThread(this.poolKeeper);
            }
            catch (Exception e) {
                throw new IllegalStateException(e.getMessage());
            }
        } else {
            this.poolKeeper = new PoolKeeper(this.sleepTime, this);
            this.keeper = new Thread(this.poolKeeper);
        }
        this.keeper.start();
        this.log.debug("GenericPool:start pool started");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getFromPool(String user, String password) throws Exception {
        Object realObject;
        long now = System.currentTimeMillis();
        if (this.getUnlockedObjectCount() > 0) {
            GenerationObject o = null;
            realObject = null;
            Long life = null;
            Enumeration e = this.unlocked.keys();
            while (e.hasMoreElements()) {
                GenericPool genericPool = this;
                synchronized (genericPool) {
                    if (!e.hasMoreElements()) {
                        break;
                    }
                    o = (GenerationObject)e.nextElement();
                    life = (Long)this.unlocked.get(o);
                    this.unlocked.remove(o);
                    realObject = o.getObj();
                }
                if (now - life > this.lifeTime) {
                    this.log.debug("GenericPool:getFromPool an object has expired");
                    this.removeUnlockedObject(o);
                    continue;
                }
                this.log.debug("GenericPool:getFromPool check the owner of the connection");
                if (this.checkOwner(o, user, password)) {
                    this.log.debug("GenericPool:getFromPool owner is verified");
                    if (this.checkLevelObject == 0 || this.checkLevelObject == 1 && this.poolHelper.checkThisObject(realObject) || this.checkLevelObject == 2 && this.poolHelper.testThisObject(realObject)) {
                        this.locked.put(o, new Long(now));
                        this.log.debug("GenericPool:getFromPool return an object (after verification if needed)");
                        return o.getObj();
                    }
                    this.log.debug("GenericPool:getFromPool kill an object from the pool");
                    this.removeUnlockedObject(o);
                    continue;
                }
                this.log.debug("GenericPool:getFromPool owner is FALSE");
            }
        }
        boolean create = false;
        realObject = this;
        synchronized (realObject) {
            if (this.count < this.maxSize) {
                create = true;
                ++this.count;
            }
        }
        if (create) {
            this.log.debug("GenericPool:getFromPool no objects available, create a new one");
            try {
                GenerationObject genObject = this.poolHelper.create(user, password);
                this.locked.put(genObject, new Long(now));
                return genObject.getObj();
            }
            catch (Exception excp) {
                GenericPool genericPool = this;
                synchronized (genericPool) {
                    --this.count;
                }
                this.log.error("GenericPool:getFromPool Error Exception in GenericPool:getFromPool");
                throw excp;
            }
        }
        return null;
    }

    public synchronized boolean checkOwner(GenerationObject genObject, String user, String password) {
        return this.equals(user, genObject.getUser()) && this.equals(password, genObject.getPassword());
    }

    JdbcThreadFactory getThreadFactory() {
        return this.threadFactory;
    }

    void setThreadFactory(JdbcThreadFactory tf) {
        this.threadFactory = tf;
    }

    private boolean equals(String a, String b) {
        if (a == null) {
            return b == null;
        }
        if (b == null) {
            return a == null;
        }
        return a.equals(b);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object checkOut(String user, String password) throws Exception {
        this.log.debug("GenericPool:checkOut an object");
        long now = System.currentTimeMillis();
        this.log.debug("GenericPool:checkOut UnlockedObjectCount=" + this.getUnlockedObjectCount());
        this.log.debug("GenericPool:checkOut LockedObjectCount=" + this.getLockedObjectCount());
        this.log.debug("GenericPool:checkOut count=" + this.count + " maxSize=" + this.maxSize);
        if (this.getUnlockedObjectCount() > 0 && (this.checkLevelObject == 3 || this.checkLevelObject == 4)) {
            Enumeration e = this.unlocked.keys();
            while (e.hasMoreElements()) {
                GenerationObject o = (GenerationObject)e.nextElement();
                Object realObject = o.getObj();
                if (now - (Long)this.unlocked.get(o) > this.lifeTime) {
                    this.log.debug("GenericPool:checkOut an object has expired");
                    this.removeUnlockedObject(o);
                    continue;
                }
                this.log.debug("GenericPool:checkOut check the owner of the connection");
                if (!this.checkOwner(o, user, password) || (this.checkLevelObject != 3 || this.poolHelper.checkThisObject(realObject)) && (this.checkLevelObject != 4 || this.poolHelper.testThisObject(realObject))) continue;
                this.log.debug("GenericPool:checkOut remove object checkLevelObject=" + this.checkLevelObject);
                this.removeUnlockedObject(o);
            }
        }
        int currentWait = 0;
        Object obj = this.getFromPool(user, password);
        while (obj == null && (long)currentWait < this.getDeadLockMaxWait()) {
            this.log.info("GenericPool:checkOut waiting for an object :" + this.poolHelper.toString());
            try {
                GenericPool genericPool = this;
                synchronized (genericPool) {
                    this.wait(this.getDeadLockRetryWait());
                }
            }
            catch (InterruptedException excp) {
                this.log.error("GenericPool:checkOut ERROR Failed while waiting for an object: " + excp);
            }
            currentWait = (int)((long)currentWait + this.getDeadLockRetryWait());
            obj = this.getFromPool(user, password);
        }
        if (obj == null) {
            throw new Exception("GenericPool:checkOut ERROR  impossible to obtain a new object from the pool");
        }
        return obj;
    }

    public synchronized void minimumObject() {
        this.minimumObject(null, null);
    }

    public synchronized void minimumObject(String user, String password) {
        this.log.debug("GenericPool:minimumObject create object if there are less than minSize objects in the pool count =" + this.count);
        if (this.count < this.minSize && this.unlocked != null) {
            long now = System.currentTimeMillis();
            int i = this.count;
            while (i < this.minSize) {
                try {
                    GenerationObject genObject = user != null && password != null ? this.poolHelper.create() : this.poolHelper.create(user, password);
                    this.unlocked.put(genObject, new Long(now));
                }
                catch (Exception e) {
                    this.log.error("GenericPool:minimumObject Error Exception in GenericPool:minimumObject");
                }
                ++i;
            }
            this.log.debug("GenericPool:minimumObject count=" + this.count + " Unlocked=" + this.getUnlockedObjectCount() + " locked=" + this.getLockedObjectCount());
            this.count = this.minSize;
        }
    }

    public synchronized void checkIn(Object o) {
        this.log.debug("GenericPool:checkIn return an object to the pool");
        Enumeration enumeration = this.locked.keys();
        while (enumeration.hasMoreElements()) {
            GenerationObject obj = (GenerationObject)enumeration.nextElement();
            if (!obj.getObj().equals(o)) continue;
            this.locked.remove(obj);
            this.unlocked.put(obj, new Long(System.currentTimeMillis()));
            int genObj = obj.getGeneration();
            if (this.generation > genObj && !this.poolHelper.checkThisObject(obj.getObj())) {
                this.removeUnlockedObject(obj);
            }
            this.notifyAll();
        }
        if (this.count > this.maxSize) {
            this.log.info("GenericPool:checkIn more than maxSize object in the pool");
            enumeration = this.unlocked.keys();
            int i = this.maxSize;
            while (i < this.count) {
                if (this.getUnlockedObjectCount() > 0) {
                    GenerationObject obj = (GenerationObject)enumeration.nextElement();
                    this.removeUnlockedObject(obj);
                }
                ++i;
            }
            this.count = this.getUnlockedObjectCount() + this.getLockedObjectCount();
            if (this.count > this.maxSize) {
                this.log.warn("GenericPool:checkIn Be careful, the maximum size of the pool does not correspond to your data. When objects will be check in, the pool will decrease");
            }
        }
    }

    private synchronized void removeUnlockedObject(GenerationObject obj) {
        --this.count;
        this.notifyAll();
        this.unlocked.remove(obj);
        this.hitList.add(obj);
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public synchronized void setMinSize(int min) throws Exception {
        if (min < 0) {
            throw new Exception("GenericPool:setMinSize Minimum size of the pool can't be lesser than 0");
        }
        if (min > this.maxSize) {
            throw new Exception("GenericPool:setMinSize Minimum size of the pool can't be greater than the maxSize (" + this.maxSize + ")");
        }
        this.minSize = min;
    }

    public synchronized void setMaxSize(int max) throws Exception {
        if (max < 0) {
            throw new Exception("GenericPool:setMaxSize Maximum size of the pool can't be lesser than 0");
        }
        if (max < this.minSize) {
            throw new Exception("GenericPool:setMaxSize Maximum size of the pool can't be lesser than the minSize (" + this.minSize + ")");
        }
        this.maxSize = max;
        if (this.count > max) {
            this.log.info("GenericPool:setMaxSize pool has more than max element");
            Enumeration enumeration = this.unlocked.keys();
            int i = max;
            while (i < this.count) {
                if (this.getUnlockedObjectCount() > 0) {
                    GenerationObject o = (GenerationObject)enumeration.nextElement();
                    this.removeUnlockedObject(o);
                }
                ++i;
            }
            this.count = this.getUnlockedObjectCount() + this.getLockedObjectCount();
            if (this.count > max) {
                this.log.warn("GenericPool:setMaxSize Be careful, the maximum size of the pool does not correspond to your data. When objects will be check in, the pool will decrease");
            }
        }
    }

    public void setLifeTime(long lifeTime) {
        this.lifeTime = lifeTime;
    }

    public void setSleepTime(long sleepTime) {
        this.sleepTime = sleepTime;
    }

    public void setGeneration(int generation) {
        this.generation = generation;
        this.log.debug("GenericPool:setGeneration Be careful, it is very dangerous to change the generation number, many objects could be destroyed");
    }

    public void setGC(boolean gc) {
        this.gc = gc;
    }

    public void setCheckLevelObject(int level) {
        if (level > 0 && level <= 4) {
            this.checkLevelObject = level;
        }
    }

    public void setDeadLockMaxWait(long deadLock) {
        this.deadLockMaxWait = deadLock;
    }

    public void setDeadLockRetryWait(long deadLockRetryWait) {
        this.deadLockRetryWait = deadLockRetryWait;
    }

    public int getMinSize() {
        return this.minSize;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public long getLifeTime() {
        return this.lifeTime;
    }

    public boolean isGC() {
        return this.gc;
    }

    public int getCount() {
        return this.count;
    }

    public long getSleepTime() {
        return this.sleepTime;
    }

    public int getGeneration() {
        return this.generation;
    }

    public int getCheckLevelObject() {
        return this.checkLevelObject;
    }

    public void stop() {
        this.log.debug("GenericPool:stop start to stop the pool");
        if (this.getLockedObjectCount() != 0 || this.getUnlockedObjectCount() != 0) {
            this.expireAll();
            if (this.poolKeeper != null) {
                this.poolKeeper.stop();
            }
            this.keeper.interrupt();
            this.locked.clear();
            this.unlocked.clear();
            this.locked = null;
            this.unlocked = null;
            this.count = 0;
        }
        this.log.debug("GenericPool:stop pool stopped");
    }

    public int getLockedObjectCount() {
        if (this.locked != null) {
            return this.locked.size();
        }
        return 0;
    }

    public int getUnlockedObjectCount() {
        if (this.unlocked != null) {
            return this.unlocked.size();
        }
        return 0;
    }

    public long getDeadLockMaxWait() {
        return this.deadLockMaxWait;
    }

    public long getDeadLockRetryWait() {
        return this.deadLockRetryWait;
    }

    public String toString() {
        GenerationObject o;
        Enumeration e;
        StringBuffer sb = new StringBuffer();
        sb.append("GenericPool:\n");
        sb.append("     num of element =<" + this.count + ">\n");
        sb.append("     minSize =<" + this.minSize + ">\n");
        sb.append("     maxSize =<" + this.maxSize + ">\n");
        sb.append("     lifeTime =<" + this.lifeTime + ">\n");
        sb.append("     ngeneration =<" + this.generation + ">\n");
        sb.append("     getLockedObjectCount() =<" + this.getLockedObjectCount() + ">\n");
        sb.append("     getUnlockedObjectCount() =<" + this.getUnlockedObjectCount() + ">\n");
        sb.append("     getDeadLockMaxWait() =<" + this.getDeadLockMaxWait() + ">\n");
        sb.append("     getDeadLockRetryWait() =<" + this.getDeadLockRetryWait() + ">\n");
        if (this.unlocked != null) {
            sb.append("Unlocked pool:\n");
            e = this.unlocked.keys();
            while (e.hasMoreElements()) {
                o = (GenerationObject)e.nextElement();
                sb.append(o.getObj().toString());
            }
        }
        if (this.locked != null) {
            sb.append("Locked pool:\n");
            e = this.unlocked.keys();
            while (e.hasMoreElements()) {
                o = (GenerationObject)e.nextElement();
                sb.append(o.getObj().toString());
            }
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected void cleanUp() {
        var1_1 = this;
        synchronized (var1_1) {
            if (this.unlocked == null) {
                return;
            }
        }
        now = System.currentTimeMillis();
        var3_3 = this;
        synchronized (var3_3) {
            enum = this.unlocked.keys();
            while (enum.hasMoreElements()) {
                o = (GenerationObject)enum.nextElement();
                lasttouch = (Long)this.unlocked.get(o);
                if (now - lasttouch <= this.lifeTime) continue;
                this.log.debug("GenericPool:cleanUp clean up the pool");
                this.removeUnlockedObject(o);
            }
            // MONITOREXIT @DISABLED, blocks:[1, 7] lbl24 : MonitorExitStatement: MONITOREXIT : var3_3
            if (true) ** GOTO lbl30
        }
        do {
            obj = (GenerationObject)this.hitList.remove(0);
            this.log.debug("GenericPool:cleanUp killing an object");
            this.poolHelper.expire(obj.getObj());
            obj.killObject();
lbl30:
            // 2 sources

        } while (this.hitList.size() > 0);
        if (this.isGC()) {
            System.gc();
        }
        resize = false;
        enum = this;
        synchronized (enum) {
            resize = this.count < this.minSize;
        }
        if (resize) {
            this.log.info("GenericPool:cleanUp less than minSize objects in the pool min=" + this.minSize + " max=" + this.maxSize + " count=" + this.count);
            while (true) {
                try {
                    genObject = this.poolHelper.create();
                    var5_7 = this;
                    synchronized (var5_7) {
                        this.unlocked.put(genObject, new Long(now));
                        ++this.count;
                        this.notifyAll();
                        if (this.count >= this.minSize) {
                            break;
                        }
                    }
                }
                catch (Exception e) {
                    this.log.error("GenericPool:cleanUp Error Exception in GenericPool:cleanUp");
                }
                var4_5 = this;
                synchronized (var4_5) {
                    this.notifyAll();
                }
            }
            this.log.info("GenericPool:cleanUp done min=" + this.minSize + " max=" + this.maxSize + " count=" + this.count);
        }
    }

    void expireAll() {
        GenerationObject o;
        this.log.debug("GenericPool:expireAll close all object in the unlocked and locked structures");
        Enumeration enumeration = this.unlocked.keys();
        while (enumeration.hasMoreElements()) {
            o = (GenerationObject)enumeration.nextElement();
            this.poolHelper.expire(o.getObj());
            o.killObject();
            o = null;
        }
        enumeration = this.locked.keys();
        while (enumeration.hasMoreElements()) {
            o = (GenerationObject)enumeration.nextElement();
            this.poolHelper.expire(o.getObj());
            o.killObject();
            Object var2_2 = null;
        }
    }

    public void nextGeneration(Object obj) {
        GenerationObject o;
        this.log.debug("GenericPool:nextGeneration");
        int genObj = 0;
        Enumeration enumeration = this.locked.keys();
        while (enumeration.hasMoreElements()) {
            o = (GenerationObject)enumeration.nextElement();
            if (!o.getObj().equals(obj)) continue;
            genObj = o.getGeneration();
        }
        enumeration = this.unlocked.keys();
        while (enumeration.hasMoreElements()) {
            o = (GenerationObject)enumeration.nextElement();
            if (o.getGeneration() > genObj || this.poolHelper.checkThisObject(o.getObj())) continue;
            this.removeUnlockedObject(o);
        }
        ++this.generation;
    }

    public synchronized void removeLockedObject(Object obj) {
        this.log.debug("GenericPool:removeObject remove an object");
        Enumeration enumeration = this.locked.keys();
        while (enumeration.hasMoreElements()) {
            GenerationObject o = (GenerationObject)enumeration.nextElement();
            if (!o.getObj().equals(obj)) continue;
            this.locked.remove(o);
            --this.count;
            o.killObject();
            Object var3_3 = null;
        }
    }

    public void setLogger(Logger alog) {
        this.log = alog;
    }

    public Hashtable getLockedObject() {
        return this.locked;
    }
}

