/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.libs.svnclientadapter.javahl;

import java.io.File;
import java.util.logging.Level;
import java.util.prefs.Preferences;
import org.netbeans.libs.svnclientadapter.SvnClientAdapterFactory;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.NbPreferences;
import org.openide.util.Utilities;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.javahl.JhlClientAdapter;
import org.tigris.subversion.svnclientadapter.javahl.JhlClientAdapterFactory;

public class JavaHlClientAdapterFactory
extends SvnClientAdapterFactory {
    private static final String SUBVERSION_NATIVE_LIBRARY = "subversion.native.library";
    private static boolean javahlCrash = false;
    private static final int JAVAHL_INIT_NOCRASH = 1;
    private static final int JAVAHL_INIT_STOP_REPORTING = 2;
    private boolean available = false;

    public SvnClientAdapterFactory.Client provides() {
        return SvnClientAdapterFactory.Client.JAVAHL;
    }

    public boolean isAvailable() {
        if (!this.available) {
            this.presetJavahl();
            try {
                JhlClientAdapterFactory.setup();
            }
            catch (Throwable t) {
                String jhlErorrs = JhlClientAdapterFactory.getLibraryLoadErrors();
                LOG.log(Level.INFO, t.getMessage());
                LOG.log(Level.WARNING, "{0}\n", jhlErorrs);
                return false;
            }
            String version = this.getVersion();
            if (!this.isSupportedJavahlVersion(version)) {
                LOG.log(Level.INFO, "Unsupported version {0} of subversion javahl bindings.", version);
                return false;
            }
            this.available = JhlClientAdapterFactory.isAvailable();
        }
        return this.available;
    }

    public ISVNClientAdapter createClient() {
        return JhlClientAdapterFactory.createSVNClient((String)"javahl");
    }

    private boolean isSupportedJavahlVersion(String version) {
        boolean retval = false;
        if (version != null && ((version = version.toLowerCase()).startsWith("1.7") || version.contains("version 1.7"))) {
            retval = true;
        }
        return retval;
    }

    private String getVersion() {
        ISVNClientAdapter adapter = this.createClient();
        if (adapter != null) {
            JhlClientAdapter jhlAdapter = (JhlClientAdapter)adapter;
            String version = jhlAdapter.getNativeLibraryVersionString();
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "getVersion: version {0}", version);
            }
            return version;
        }
        return null;
    }

    private void presetJavahl() {
        if (Utilities.isUnix() && !Utilities.isMac()) {
            this.presetJavahlUnix();
        } else if (Utilities.isWindows()) {
            this.presetJavahlWindows();
        }
    }

    private void presetJavahlUnix() {
        LOG.log(Level.FINE, "looking for svn native library...");
        String libPath = System.getProperty(SUBVERSION_NATIVE_LIBRARY);
        if (libPath != null && !libPath.trim().equals("")) {
            LOG.log(Level.FINE, "won't preset javahl due to subversion.native.library={0}", new Object[]{libPath});
            return;
        }
        String name = "libsvnjavahl-1.so";
        String[] locations = new String[]{"/usr/lib/", "/usr/lib/jni/", "/usr/local/lib/", "/usr/lib64/", "/usr/lib64/jni/", "/usr/local/lib64/"};
        File location = null;
        for (String loc : locations) {
            File file = new File(loc, name);
            LOG.log(Level.FINE, " checking existence of {0}", new Object[]{file.getAbsolutePath()});
            if (!file.exists()) continue;
            location = file;
            break;
        }
        if (location == null) {
            location = this.getJavahlFromExecutablePath(name);
        }
        if (location != null) {
            System.setProperty(SUBVERSION_NATIVE_LIBRARY, location.getAbsolutePath());
            LOG.log(Level.FINE, "   found javahl library. Setting subversion.native.library={0}", new Object[]{location.getAbsolutePath()});
        }
    }

    private void presetJavahlWindows() {
        String libPath = System.getProperty(SUBVERSION_NATIVE_LIBRARY);
        if (libPath != null && !libPath.trim().equals("")) {
            LOG.log(Level.FINE, "preset subversion.native.library={0}", new Object[]{libPath});
            int idx = libPath.lastIndexOf(File.separator);
            if (idx > -1) {
                libPath = libPath.substring(0, idx);
                LOG.log(Level.FINE, "loading dependencies from ", new Object[]{libPath});
                this.loadJavahlDependencies(libPath);
            }
            return;
        }
        File location = InstalledFileLocator.getDefault().locate("modules/lib/libsvnjavahl-1.dll", "org.netbeans.libs.svnjavahlwin32", false);
        if (location == null) {
            LOG.fine("could not find location for bundled javahl library");
            location = this.getJavahlFromExecutablePath("libsvnjavahl-1.dll");
            if (location == null) {
                return;
            }
        }
        LOG.fine("libsvnjavahl-1.dll located : " + location.getAbsolutePath());
        String locationPath = location.getParentFile().getAbsolutePath();
        this.loadJavahlDependencies(locationPath);
        locationPath = location.getAbsolutePath();
        LOG.log(Level.FINE, "setting subversion.native.library={0}", new Object[]{locationPath});
        System.setProperty(SUBVERSION_NATIVE_LIBRARY, locationPath);
    }

    private void loadJavahlDependencies(String locationPath) {
        try {
            System.load(locationPath + "/msvcr100.dll");
        }
        catch (Throwable t) {
            // empty catch block
        }
        try {
            System.load(locationPath + "/msvcp100.dll");
        }
        catch (Throwable t) {
            // empty catch block
        }
        try {
            System.load(locationPath + "/libapr-1.dll");
        }
        catch (Throwable t) {
            // empty catch block
        }
        try {
            System.load(locationPath + "/libapriconv-1.dll");
        }
        catch (Throwable t) {
            // empty catch block
        }
        try {
            System.load(locationPath + "/libeay32.dll");
        }
        catch (Throwable t) {
            // empty catch block
        }
        try {
            System.load(locationPath + "/ssleay32.dll");
        }
        catch (Throwable t) {
            // empty catch block
        }
        try {
            System.load(locationPath + "/libaprutil-1.dll");
        }
        catch (Throwable t) {
            // empty catch block
        }
        try {
            System.load(locationPath + "/dbghelp.dll");
        }
        catch (Throwable t) {
            // empty catch block
        }
        try {
            System.load(locationPath + "/libsasl.dll");
        }
        catch (Throwable t) {
            // empty catch block
        }
        try {
            System.load(locationPath + "/libsvn_subr-1.dll");
        }
        catch (Throwable t) {
            // empty catch block
        }
        try {
            System.load(locationPath + "/libsvn_delta-1.dll");
        }
        catch (Throwable t) {
            // empty catch block
        }
        try {
            System.load(locationPath + "/libsvn_diff-1.dll");
        }
        catch (Throwable t) {
            // empty catch block
        }
        try {
            System.load(locationPath + "/libsvn_wc-1.dll");
        }
        catch (Throwable t) {
            // empty catch block
        }
        try {
            System.load(locationPath + "/libsvn_fs-1.dll");
        }
        catch (Throwable t) {
            // empty catch block
        }
        try {
            System.load(locationPath + "/libsvn_repos-1.dll");
        }
        catch (Throwable t) {
            // empty catch block
        }
        try {
            System.load(locationPath + "/libsvn_ra-1.dll");
        }
        catch (Throwable t) {
            // empty catch block
        }
        try {
            System.load(locationPath + "/libsvn_client-1.dll");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private File getJavahlFromExecutablePath(String libName) {
        Preferences prefs = NbPreferences.root().node("org/netbeans/modules/subversion");
        String executablePath = prefs.get("svnExecBinary", "");
        if (executablePath == null || executablePath.trim().equals("")) {
            return null;
        }
        LOG.log(Level.FINE, "looking for svn native library in executable path={0}", new Object[]{executablePath});
        File location = new File(executablePath);
        if (location.isFile()) {
            location = location.getParentFile();
        }
        if (location != null && (location = new File(location.getAbsolutePath() + File.separatorChar + libName)).exists()) {
            LOG.log(Level.FINE, "found svn native library in executable path={0}", new Object[]{location.getAbsolutePath()});
            return location;
        }
        return null;
    }
}

